/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import java.util.Collections;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.validation.ComponentLocationModelValidator;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class ComponentLocationModelValidatorTestCase
extends AbstractMuleTestCase {
    @Mock
    private ExtensionModel extensionModel;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private SourceModel sourceModel;
    private ComponentLocationModelValidator validator = new ComponentLocationModelValidator();
    private ProblemsReporter reporter = new ProblemsReporter(this.extensionModel);

    @Before
    public void before() {
        Mockito.when((Object)this.extensionModel.getSourceModels()).thenReturn(Collections.singletonList(this.sourceModel));
        Mockito.when((Object)this.sourceModel.getSuccessCallback()).thenReturn(Optional.empty());
        Mockito.when((Object)this.sourceModel.getErrorCallback()).thenReturn(Optional.empty());
    }

    @Test
    public void noImplementingType() {
        Mockito.when((Object)this.sourceModel.getModelProperty(ImplementingTypeModelProperty.class)).thenReturn(Optional.empty());
        this.assertValid();
    }

    @Test
    public void noLocationField() {
        ExtensionsTestUtils.mockImplementingType((EnrichableModel)this.sourceModel, NoLocation.class);
        this.assertValid();
    }

    @Test
    public void oneLocationField() {
        ExtensionsTestUtils.mockImplementingType((EnrichableModel)this.sourceModel, OneLocation.class);
        this.assertValid();
    }

    @Test
    public void twoLocationFields() {
        ExtensionsTestUtils.mockImplementingType((EnrichableModel)this.sourceModel, TwoLocation.class);
        this.validator.validate(this.extensionModel, this.reporter);
        Assert.assertThat((Object)this.reporter.getErrors(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)((Problem)this.reporter.getErrors().get(0)).getMessage(), (Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)ComponentLocation.class.getSimpleName()), CoreMatchers.containsString((String)"2")}));
    }

    private void assertValid() {
        this.validator.validate(this.extensionModel, this.reporter);
        Assert.assertThat((Object)this.reporter.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
    }

    private static class TwoLocation
    extends OneLocation {
        private ComponentLocation secondLocation;

        private TwoLocation() {
        }
    }

    private static class OneLocation
    extends TestSource {
        private ComponentLocation location;

        private OneLocation() {
        }
    }

    private static class NoLocation
    extends TestSource {
        private NoLocation() {
        }
    }

    private static abstract class TestSource
    extends Source<Void, Void> {
        private TestSource() {
        }

        public void onStart(SourceCallback<Void, Void> sourceCallback) throws MuleException {
        }

        public void onStop() {
        }
    }
}

