/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.JavaTypeLoader;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.core.internal.el.DefaultExpressionManager;
import org.mule.runtime.core.internal.el.ExtendedExpressionLanguageAdaptor;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.internal.runtime.resolver.TypeSafeExpressionValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.util.MuleContextUtils;

@Feature(value="Expression Language")
@Story(value="Support both MVEL and DW")
public class TypeSafeExpressionValueResolverMelTestCase
extends AbstractMuleContextTestCase {
    private static final String HELLO_WORLD = "Hello World!";
    private static final MetadataType STRING = new JavaTypeLoader(Thread.currentThread().getContextClassLoader()).load(String.class);
    @Rule
    public ExpectedException expected = ExpectedException.none();
    private ExtendedExpressionManager expressionManager;

    protected void doSetUp() throws Exception {
        muleContext = (MuleContext)Mockito.spy((Object)muleContext);
        this.expressionManager = (ExtendedExpressionManager)Mockito.spy((Object)muleContext.getExpressionManager());
        ((DefaultExpressionManager)this.expressionManager).setExpressionLanguage((ExtendedExpressionLanguageAdaptor)((MuleContextWithRegistry)muleContext).getRegistry().lookupObject("_muleExpressionLanguage"));
        Mockito.when((Object)muleContext.getExpressionManager()).thenReturn((Object)this.expressionManager);
        ((MuleContextWithRegistry)muleContext).getRegistry().registerObject("_muleExpressionManager", (Object)this.expressionManager);
    }

    @Test
    public void expressionLanguageWithoutTransformation() throws Exception {
        ValueResolvingContext context = this.buildContext(MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"World!")).build());
        this.assertResolved(this.getResolver("#[mel:'Hello ' + payload]", STRING).resolve(context), HELLO_WORLD, Mockito.never());
    }

    @Test
    public void expressionTemplateWithoutTransformation() throws Exception {
        this.assertResolved(this.getResolver("Hello #[mel:payload]", STRING).resolve(this.buildContext(MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"World!")).build())), HELLO_WORLD, Mockito.times((int)1));
    }

    @Test
    public void constant() throws Exception {
        this.assertResolved(this.getResolver(HELLO_WORLD, STRING).resolve(this.buildContext(MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)HELLO_WORLD)).build())), HELLO_WORLD, Mockito.never());
    }

    @Test
    public void expressionWithTransformation() throws Exception {
        this.assertResolved(this.getResolver("#[mel:true]", STRING).resolve(this.buildContext(MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)HELLO_WORLD)).build())), "true", Mockito.never());
    }

    @Test
    public void templateWithTransformation() throws Exception {
        this.assertResolved(this.getResolver("tru#[mel:'e']", STRING).resolve(this.buildContext(MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)HELLO_WORLD)).build())), "true", Mockito.times((int)1));
    }

    @Test
    public void nullExpression() throws Exception {
        this.expected.expect(IllegalArgumentException.class);
        this.expected.expectMessage("Expression cannot be blank or null");
        this.getResolver(null, STRING);
    }

    @Test
    public void blankExpression() throws Exception {
        this.expected.expect(IllegalArgumentException.class);
        this.expected.expectMessage("Expression cannot be blank or null");
        this.getResolver("", STRING);
    }

    @Test
    public void nullExpectedType() throws Exception {
        this.expected.expect(IllegalArgumentException.class);
        this.expected.expectMessage("expected type cannot be null");
        this.getResolver("#[mel:payload]", null);
    }

    private ValueResolvingContext buildContext(CoreEvent event) {
        return ValueResolvingContext.builder((CoreEvent)event).withExpressionManager((ExpressionManager)this.expressionManager).build();
    }

    private void assertResolved(Object resolvedValue, Object expected, VerificationMode expressionManagerVerificationMode) {
        Assert.assertThat((Object)resolvedValue, (Matcher)IsInstanceOf.instanceOf(String.class));
        Assert.assertThat((Object)resolvedValue, (Matcher)CoreMatchers.equalTo((Object)expected));
        this.verifyExpressionManager(expressionManagerVerificationMode);
    }

    private void verifyExpressionManager(VerificationMode mode) {
        ((ExtendedExpressionManager)Mockito.verify((Object)this.expressionManager, (VerificationMode)mode)).parse(ArgumentMatchers.anyString(), (CoreEvent)ArgumentMatchers.any(CoreEvent.class), (ComponentLocation)ArgumentMatchers.nullable(ComponentLocation.class));
    }

    private <T> ValueResolver<T> getResolver(String expression, MetadataType expectedType) throws Exception {
        TypeSafeExpressionValueResolver valueResolver = new TypeSafeExpressionValueResolver(expression, (Class)ExtensionMetadataTypeUtils.getType((MetadataType)expectedType).orElse(null), IntrospectionUtils.toDataType((MetadataType)expectedType));
        muleContext.getInjector().inject((Object)valueResolver);
        valueResolver.setExtendedExpressionManager(this.expressionManager);
        valueResolver.setTransformationService(muleContext.getTransformationService());
        valueResolver.initialise();
        return valueResolver;
    }
}

