/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.parser.java;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Test;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.metadata.resolving.AttributesStaticTypeResolver;
import org.mule.runtime.api.metadata.resolving.OutputStaticTypeResolver;
import org.mule.runtime.extension.api.annotation.metadata.MetadataScope;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.metadata.fixed.AttributesJsonType;
import org.mule.runtime.extension.api.annotation.metadata.fixed.AttributesXmlType;
import org.mule.runtime.extension.api.annotation.metadata.fixed.InputJsonType;
import org.mule.runtime.extension.api.annotation.metadata.fixed.InputXmlType;
import org.mule.runtime.extension.api.annotation.metadata.fixed.OutputJsonType;
import org.mule.runtime.extension.api.declaration.type.DefaultExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.api.loader.java.type.OperationElement;
import org.mule.runtime.module.extension.api.loader.java.type.SourceElement;
import org.mule.runtime.module.extension.internal.loader.annotations.CustomDefinedStaticTypeAnnotation;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.OperationWrapper;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.ParameterWrapper;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.SourceTypeWrapper;
import org.mule.runtime.module.extension.internal.loader.parser.java.type.CustomStaticTypeUtils;
import org.mule.sdk.api.annotation.metadata.fixed.OutputXmlType;
import org.mule.sdk.api.metadata.resolving.InputStaticTypeResolver;

public class CustomStaticTypeUtilsTestCase {
    private static final String TEST_PARAMETER_METHOD = "testParameterMethod";
    private static final MetadataType CUSTOM_STATIC_METADATATYPE = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType().id("custom-java").build();

    @Test
    public void xmlInputStaticType() throws Exception {
        this.assertXmlType(CustomStaticTypeUtils.getParameterType((ExtensionParameter)this.getExtensionParameter("xmlInputStaticType")));
    }

    @Test
    public void jsonInputStaticType() throws Exception {
        this.assertJsonType(CustomStaticTypeUtils.getParameterType((ExtensionParameter)this.getExtensionParameter("jsonInputStaticType")));
    }

    @Test
    public void customInputStaticType() throws Exception {
        this.assertCustomType(CustomStaticTypeUtils.getParameterType((ExtensionParameter)this.getExtensionParameter("customInputStaticType")));
    }

    @Test
    public void xmlOutputStaticType() throws Exception {
        this.assertXmlType(CustomStaticTypeUtils.getOperationOutputType((OperationElement)this.getOperationElementMethodName("xmlOutputStaticTypeOperation")));
    }

    @Test
    public void jsonOutputStaticType() throws Exception {
        this.assertJsonType(CustomStaticTypeUtils.getOperationOutputType((OperationElement)this.getOperationElementMethodName("jsonOutputStaticTypeOperation")));
    }

    @Test
    public void customOutputStaticType() throws Exception {
        this.assertCustomType(CustomStaticTypeUtils.getOperationOutputType((OperationElement)this.getOperationElementMethodName("customOutputStaticTypeOperation")));
    }

    @Test
    public void xmlAttributesStaticType() throws Exception {
        this.assertXmlType(CustomStaticTypeUtils.getOperationAttributesType((OperationElement)this.getOperationElementMethodName("xmlAttributeStaticTypeOperation")));
    }

    @Test
    public void jsonAttributesStaticType() throws Exception {
        this.assertJsonType(CustomStaticTypeUtils.getOperationAttributesType((OperationElement)this.getOperationElementMethodName("jsonAttributesStaticTypeOperation")));
    }

    @Test
    public void customAttributesStaticType() throws Exception {
        this.assertCustomType(CustomStaticTypeUtils.getOperationAttributesType((OperationElement)this.getOperationElementMethodName("customAttributesStaticTypeOperation")));
    }

    @Test
    public void xmlOutputStaticTypeSource() {
        this.assertXmlType(CustomStaticTypeUtils.getSourceOutputType((SourceElement)this.getSourceElementWithClass(XmlOutputStaticTypeSource.class)));
    }

    @Test
    public void jsonOutputStaticTypeSource() {
        this.assertJsonType(CustomStaticTypeUtils.getSourceOutputType((SourceElement)this.getSourceElementWithClass(JsonOutputStaticTypeSource.class)));
    }

    @Test
    public void customOutputStaticTypeSource() {
        this.assertCustomType(CustomStaticTypeUtils.getSourceOutputType((SourceElement)this.getSourceElementWithClass(CustomOutputStaticTypeSource.class)));
    }

    @Test
    public void xmlAttributesStaticTypeSource() {
        this.assertXmlType(CustomStaticTypeUtils.getSourceAttributesType((SourceElement)this.getSourceElementWithClass(XmlAttributesStaticTypeSource.class)));
    }

    @Test
    public void jsonAttributesStaticTypeSource() {
        this.assertJsonType(CustomStaticTypeUtils.getSourceAttributesType((SourceElement)this.getSourceElementWithClass(JsonAttributesStaticTypeSource.class)));
    }

    @Test
    public void customAttributesStaticTypeSource() {
        this.assertCustomType(CustomStaticTypeUtils.getSourceAttributesType((SourceElement)this.getSourceElementWithClass(CustomAttributesStaticTypeSource.class)));
    }

    @Test
    public void sdkXmlInputStaticType() throws Exception {
        this.assertXmlType(CustomStaticTypeUtils.getParameterType((ExtensionParameter)this.getExtensionParameter("sdkXmlInputStaticType")));
    }

    @Test
    public void sdkJsonInputStaticType() throws Exception {
        this.assertJsonType(CustomStaticTypeUtils.getParameterType((ExtensionParameter)this.getExtensionParameter("sdkJsonInputStaticType")));
    }

    @Test
    public void sdkCustomInputStaticType() throws Exception {
        this.assertCustomType(CustomStaticTypeUtils.getParameterType((ExtensionParameter)this.getExtensionParameter("sdkCustomInputStaticType")));
    }

    @Test
    public void sdkXmlOutputStaticType() throws Exception {
        this.assertXmlType(CustomStaticTypeUtils.getOperationOutputType((OperationElement)this.getOperationElementMethodName("sdkXmlOutputStaticTypeOperation")));
    }

    @Test
    public void sdkJsonOutputStaticType() throws Exception {
        this.assertJsonType(CustomStaticTypeUtils.getOperationOutputType((OperationElement)this.getOperationElementMethodName("sdkJsonOutputStaticTypeOperation")));
    }

    @Test
    public void sdkCustomOutputStaticType() throws Exception {
        this.assertCustomType(CustomStaticTypeUtils.getOperationOutputType((OperationElement)this.getOperationElementMethodName("sdkCustomOutputStaticTypeOperation")));
    }

    @Test
    public void sdkXmlAttributesStaticType() throws Exception {
        this.assertXmlType(CustomStaticTypeUtils.getOperationAttributesType((OperationElement)this.getOperationElementMethodName("sdkXmlAttributeStaticTypeOperation")));
    }

    @Test
    public void sdkJsonAttributesStaticType() throws Exception {
        this.assertJsonType(CustomStaticTypeUtils.getOperationAttributesType((OperationElement)this.getOperationElementMethodName("sdkJsonAttributesStaticTypeOperation")));
    }

    @Test
    public void sdkCustomAttributesStaticType() throws Exception {
        this.assertCustomType(CustomStaticTypeUtils.getOperationAttributesType((OperationElement)this.getOperationElementMethodName("sdkCustomAttributesStaticTypeOperation")));
    }

    @Test
    public void sdkXmlOutputStaticTypeSource() {
        this.assertXmlType(CustomStaticTypeUtils.getSourceOutputType((SourceElement)this.getSourceElementWithClass(SdkXmlOutputStaticTypeSource.class)));
    }

    @Test
    public void sdkJsonOutputStaticTypeSource() {
        this.assertJsonType(CustomStaticTypeUtils.getSourceOutputType((SourceElement)this.getSourceElementWithClass(SdkJsonOutputStaticTypeSource.class)));
    }

    @Test
    public void sdkCustomOutputStaticTypeSource() {
        this.assertCustomType(CustomStaticTypeUtils.getSourceOutputType((SourceElement)this.getSourceElementWithClass(SdkCustomOutputStaticTypeSource.class)));
    }

    @Test
    public void sdkXmlAttributesStaticTypeSource() {
        this.assertXmlType(CustomStaticTypeUtils.getSourceAttributesType((SourceElement)this.getSourceElementWithClass(SdkXmlAttributesStaticTypeSource.class)));
    }

    @Test
    public void sdkJsonAttributesStaticTypeSource() {
        this.assertJsonType(CustomStaticTypeUtils.getSourceAttributesType((SourceElement)this.getSourceElementWithClass(SdkJsonAttributesStaticTypeSource.class)));
    }

    @Test
    public void sdkCustomAttributesStaticTypeSource() {
        this.assertCustomType(CustomStaticTypeUtils.getSourceAttributesType((SourceElement)this.getSourceElementWithClass(SdkCustomAttributesStaticTypeSource.class)));
    }

    private SourceElement getSourceElementWithClass(Class<? extends Source> sourceClass) {
        return new SourceTypeWrapper(sourceClass, new DefaultExtensionsTypeLoaderFactory().createTypeLoader(Thread.currentThread().getContextClassLoader()));
    }

    private OperationElement getOperationElementMethodName(String methodName) throws Exception {
        return new OperationWrapper(this.getMethod(methodName), new DefaultExtensionsTypeLoaderFactory().createTypeLoader(Thread.currentThread().getContextClassLoader()));
    }

    private ExtensionParameter getExtensionParameter(String parameterName) throws Exception {
        Method parametersMethod = this.getMethod(TEST_PARAMETER_METHOD);
        return new ParameterWrapper(parametersMethod, this.getParameterIndex(parameterName, parametersMethod), new DefaultExtensionsTypeLoaderFactory().createTypeLoader(Thread.currentThread().getContextClassLoader()));
    }

    private Method getMethod(String methodName) throws NoSuchMethodException {
        return Arrays.stream(this.getClass().getMethods()).filter(method -> method.getName().equals(methodName)).findFirst().get();
    }

    private int getParameterIndex(String parameterName, Method method) {
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            if (!parameters[i].getName().equals(parameterName)) continue;
            return i;
        }
        throw new IllegalArgumentException("No parameter for the given arguments");
    }

    private void assertXmlType(MetadataType type) {
        MatcherAssert.assertThat((Object)type, (Matcher)CoreMatchers.instanceOf(ObjectType.class));
        ObjectType objectType = (ObjectType)type;
        MatcherAssert.assertThat((Object)objectType.getFields(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)objectType.getFieldByName("shiporder").isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)type.getAnnotation(CustomDefinedStaticTypeAnnotation.class).isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((ClassInformationAnnotation)type.getAnnotation(ClassInformationAnnotation.class).get()).getClassname(), (Matcher)CoreMatchers.is((Object)String.class.getName()));
        MatcherAssert.assertThat((Object)((TypeIdAnnotation)type.getAnnotation(TypeIdAnnotation.class).get()).getValue(), (Matcher)CoreMatchers.is((Object)"#root:shiporder"));
    }

    private void assertJsonType(MetadataType type) {
        MatcherAssert.assertThat((Object)type, (Matcher)CoreMatchers.instanceOf(ObjectType.class));
        ObjectType objectType = (ObjectType)type;
        MatcherAssert.assertThat((Object)objectType.getFields(), (Matcher)IsCollectionWithSize.hasSize((int)3));
        MatcherAssert.assertThat((Object)objectType.getFieldByName("firstName").isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)type.getAnnotation(CustomDefinedStaticTypeAnnotation.class).isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((ClassInformationAnnotation)type.getAnnotation(ClassInformationAnnotation.class).get()).getClassname(), (Matcher)CoreMatchers.is((Object)String.class.getName()));
        MatcherAssert.assertThat((Object)((TypeIdAnnotation)type.getAnnotation(TypeIdAnnotation.class).get()).getValue(), (Matcher)CoreMatchers.is((Object)"http://example.com/example.json"));
    }

    private void assertCustomType(MetadataType type) {
        MatcherAssert.assertThat((Object)type.getMetadataFormat(), (Matcher)CoreMatchers.is((Object)MetadataFormat.JAVA));
        MatcherAssert.assertThat((Object)type, (Matcher)CoreMatchers.instanceOf(ObjectType.class));
        ObjectType objectType = (ObjectType)type;
        MatcherAssert.assertThat((Object)objectType.getFields(), (Matcher)IsCollectionWithSize.hasSize((int)0));
        MatcherAssert.assertThat((Object)type.getAnnotation(CustomDefinedStaticTypeAnnotation.class).isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((ClassInformationAnnotation)type.getAnnotation(ClassInformationAnnotation.class).get()).getClassname(), (Matcher)CoreMatchers.is((Object)String.class.getName()));
        MatcherAssert.assertThat((Object)((TypeIdAnnotation)type.getAnnotation(TypeIdAnnotation.class).get()).getValue(), (Matcher)CoreMatchers.is((Object)"custom-java"));
    }

    public void testParameterMethod(@InputXmlType(schema="order.xsd", qname="shiporder") String xmlInputStaticType, @org.mule.sdk.api.annotation.metadata.fixed.InputXmlType(schema="order.xsd", qname="shiporder") String sdkXmlInputStaticType, @InputJsonType(schema="person-schema.json") String jsonInputStaticType, @org.mule.sdk.api.annotation.metadata.fixed.InputJsonType(schema="person-schema.json") String sdkJsonInputStaticType, @TypeResolver(value=TestInputStaticTypeResolver.class) String customInputStaticType, @org.mule.sdk.api.annotation.metadata.TypeResolver(value=SdkTestInputStaticTypeResolver.class) String sdkCustomInputStaticType) {
    }

    @org.mule.runtime.extension.api.annotation.metadata.fixed.OutputXmlType(schema="order.xsd", qname="shiporder")
    public String xmlOutputStaticTypeOperation() {
        return null;
    }

    @OutputXmlType(schema="order.xsd", qname="shiporder")
    public String sdkXmlOutputStaticTypeOperation() {
        return null;
    }

    @OutputJsonType(schema="person-schema.json")
    public String jsonOutputStaticTypeOperation() {
        return null;
    }

    @org.mule.sdk.api.annotation.metadata.fixed.OutputJsonType(schema="person-schema.json")
    public String sdkJsonOutputStaticTypeOperation() {
        return null;
    }

    @OutputResolver(output=TestOutputStaticTypeResolver.class)
    public String customOutputStaticTypeOperation() {
        return null;
    }

    @org.mule.sdk.api.annotation.metadata.OutputResolver(output=SdkTestOutputStaticTypeResolver.class)
    public String sdkCustomOutputStaticTypeOperation() {
        return null;
    }

    @AttributesXmlType(schema="order.xsd", qname="shiporder")
    public Result<String, String> xmlAttributeStaticTypeOperation() {
        return null;
    }

    @org.mule.sdk.api.annotation.metadata.fixed.AttributesXmlType(schema="order.xsd", qname="shiporder")
    public Result<String, String> sdkXmlAttributeStaticTypeOperation() {
        return null;
    }

    @AttributesJsonType(schema="person-schema.json")
    public Result<String, String> jsonAttributesStaticTypeOperation() {
        return null;
    }

    @org.mule.sdk.api.annotation.metadata.fixed.AttributesJsonType(schema="person-schema.json")
    public Result<String, String> sdkJsonAttributesStaticTypeOperation() {
        return null;
    }

    @OutputResolver(attributes=TestAttributesStaticTypeResolver.class)
    public Result<String, String> customAttributesStaticTypeOperation() {
        return null;
    }

    @org.mule.sdk.api.annotation.metadata.OutputResolver(attributes=SdkTestAttributesStaticTypeResolver.class)
    public Result<String, String> sdkCustomAttributesStaticTypeOperation() {
        return null;
    }

    public static class SdkTestAttributesStaticTypeResolver
    extends org.mule.sdk.api.metadata.resolving.AttributesStaticTypeResolver {
        public MetadataType getStaticMetadata() {
            return CUSTOM_STATIC_METADATATYPE;
        }
    }

    public static class SdkTestInputStaticTypeResolver
    extends InputStaticTypeResolver {
        public MetadataType getStaticMetadata() {
            return CUSTOM_STATIC_METADATATYPE;
        }
    }

    public static class SdkTestOutputStaticTypeResolver
    extends org.mule.sdk.api.metadata.resolving.OutputStaticTypeResolver {
        public MetadataType getStaticMetadata() {
            return CUSTOM_STATIC_METADATATYPE;
        }
    }

    public static class TestAttributesStaticTypeResolver
    extends AttributesStaticTypeResolver {
        public MetadataType getStaticMetadata() {
            return CUSTOM_STATIC_METADATATYPE;
        }
    }

    public static class TestInputStaticTypeResolver
    extends org.mule.runtime.api.metadata.resolving.InputStaticTypeResolver {
        public MetadataType getStaticMetadata() {
            return CUSTOM_STATIC_METADATATYPE;
        }
    }

    public static class TestOutputStaticTypeResolver
    extends OutputStaticTypeResolver {
        public MetadataType getStaticMetadata() {
            return CUSTOM_STATIC_METADATATYPE;
        }
    }

    @org.mule.sdk.api.annotation.metadata.MetadataScope(attributesResolver=SdkTestAttributesStaticTypeResolver.class)
    private static class SdkCustomAttributesStaticTypeSource
    extends BaseSource {
        private SdkCustomAttributesStaticTypeSource() {
        }
    }

    @MetadataScope(attributesResolver=TestAttributesStaticTypeResolver.class)
    private static class CustomAttributesStaticTypeSource
    extends BaseSource {
        private CustomAttributesStaticTypeSource() {
        }
    }

    @org.mule.sdk.api.annotation.metadata.fixed.AttributesJsonType(schema="person-schema.json")
    private static class SdkJsonAttributesStaticTypeSource
    extends BaseSource {
        private SdkJsonAttributesStaticTypeSource() {
        }
    }

    @AttributesJsonType(schema="person-schema.json")
    private static class JsonAttributesStaticTypeSource
    extends BaseSource {
        private JsonAttributesStaticTypeSource() {
        }
    }

    @org.mule.sdk.api.annotation.metadata.fixed.AttributesXmlType(schema="order.xsd", qname="shiporder")
    private static class SdkXmlAttributesStaticTypeSource
    extends BaseSource {
        private SdkXmlAttributesStaticTypeSource() {
        }
    }

    @AttributesXmlType(schema="order.xsd", qname="shiporder")
    private static class XmlAttributesStaticTypeSource
    extends BaseSource {
        private XmlAttributesStaticTypeSource() {
        }
    }

    @org.mule.sdk.api.annotation.metadata.MetadataScope(outputResolver=SdkTestOutputStaticTypeResolver.class)
    private static class SdkCustomOutputStaticTypeSource
    extends BaseSource {
        private SdkCustomOutputStaticTypeSource() {
        }
    }

    @MetadataScope(outputResolver=TestOutputStaticTypeResolver.class)
    private static class CustomOutputStaticTypeSource
    extends BaseSource {
        private CustomOutputStaticTypeSource() {
        }
    }

    @org.mule.sdk.api.annotation.metadata.fixed.OutputJsonType(schema="person-schema.json")
    private static class SdkJsonOutputStaticTypeSource
    extends BaseSource {
        private SdkJsonOutputStaticTypeSource() {
        }
    }

    @OutputJsonType(schema="person-schema.json")
    private static class JsonOutputStaticTypeSource
    extends BaseSource {
        private JsonOutputStaticTypeSource() {
        }
    }

    @OutputXmlType(schema="order.xsd", qname="shiporder")
    private static class SdkXmlOutputStaticTypeSource
    extends BaseSource {
        private SdkXmlOutputStaticTypeSource() {
        }
    }

    @org.mule.runtime.extension.api.annotation.metadata.fixed.OutputXmlType(schema="order.xsd", qname="shiporder")
    private static class XmlOutputStaticTypeSource
    extends BaseSource {
        private XmlOutputStaticTypeSource() {
        }
    }

    private static class BaseSource
    extends Source<String, String> {
        private BaseSource() {
        }

        public void onStart(SourceCallback<String, String> sourceCallback) throws MuleException {
        }

        public void onStop() {
        }
    }
}

