/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java;

import io.qameta.allure.Issue;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.extension.api.annotation.Extension;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.error.ErrorTypeProvider;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.error.MuleErrors;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.runtime.process.RouterCompletionCallback;
import org.mule.runtime.module.extension.internal.loader.enricher.LevelErrorTypes;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.sdk.api.annotation.error.ErrorTypes;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.test.heisenberg.extension.HeisenbergErrors;
import org.mule.test.heisenberg.extension.HeisenbergExtension;
import org.mule.test.heisenberg.extension.route.WhenRoute;

public class JavaErrorParsingTestCase
extends AbstractMuleTestCase {
    private static final String HEISENBERG = "HEISENBERG";
    private static final String MULE_NAMESPACE = "MULE";
    private static final String TYPE = "type";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private ExtensionModel extensionModel;

    @Test
    public void detectErrorTypesCycleDependency() {
        Assertions.assertThatThrownBy(() -> {
            this.extensionModel = org.mule.runtime.module.extension.api.util.MuleExtensionUtils.loadExtension(HeisenbergWithCyclicErrorTypes.class);
        }).hasMessageContaining("Cyclic Error Types reference detected").isInstanceOf(IllegalModelDefinitionException.class);
    }

    @Test
    public void operationsWithConnectionsThrowsConnectivityError() {
        this.extensionModel = org.mule.runtime.module.extension.api.util.MuleExtensionUtils.loadExtension(HeisenbergExtension.class);
        OperationModel callSaul = (OperationModel)MuleExtensionUtils.getNamedObject((List)((ConfigurationModel)this.extensionModel.getConfigurationModel("config").get()).getOperationModels(), (String)"callSaul");
        Set errorTypesIdentifiers = callSaul.getErrorModels();
        MatcherAssert.assertThat((Object)errorTypesIdentifiers, (Matcher)CoreMatchers.hasItem((Matcher)Matchers.hasProperty((String)TYPE, (Matcher)CoreMatchers.is((Object)"CONNECTIVITY"))));
    }

    @Test
    public void extensionErrorsInheritFromMuleErrors() {
        this.extensionModel = org.mule.runtime.module.extension.api.util.MuleExtensionUtils.loadExtension(HeisenbergExtension.class);
        OperationModel cureCancer = (OperationModel)MuleExtensionUtils.getNamedObject((List)this.extensionModel.getOperationModels(), (String)"cureCancer");
        MatcherAssert.assertThat((Object)cureCancer.getErrorModels(), (Matcher)CoreMatchers.hasItem((Matcher)Matchers.hasProperty((String)TYPE, (Matcher)CoreMatchers.is((Object)HeisenbergErrors.HEALTH.getType()))));
        Optional<ErrorModel> healthError = this.extensionModel.getErrorModels().stream().filter(errorModel -> errorModel.getType().equals(HeisenbergErrors.HEALTH.getType())).findFirst();
        MatcherAssert.assertThat((Object)healthError.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        Optional optConnectivityError = healthError.get().getParent();
        MatcherAssert.assertThat((Object)optConnectivityError.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        ErrorModel connectivityError = (ErrorModel)optConnectivityError.get();
        MatcherAssert.assertThat((Object)connectivityError.getType(), (Matcher)CoreMatchers.is((Object)"CONNECTIVITY"));
        MatcherAssert.assertThat((Object)connectivityError.getNamespace(), (Matcher)CoreMatchers.is((Object)HEISENBERG));
        Optional optMuleConnectivityError = connectivityError.getParent();
        MatcherAssert.assertThat((Object)optMuleConnectivityError.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        ErrorModel muleConnectivityError = (ErrorModel)optMuleConnectivityError.get();
        MatcherAssert.assertThat((Object)muleConnectivityError.getType(), (Matcher)CoreMatchers.is((Object)"CONNECTIVITY"));
        MatcherAssert.assertThat((Object)muleConnectivityError.getNamespace(), (Matcher)CoreMatchers.is((Object)MULE_NAMESPACE));
    }

    @Test
    public void operationUsesANotMappedErrorType() {
        Assertions.assertThatThrownBy(() -> {
            this.extensionModel = org.mule.runtime.module.extension.api.util.MuleExtensionUtils.loadExtension(HeisenbergWithNotMappedErrorType.class);
        }).hasMessageContaining("Invalid operation throws detected, the extension declared to throw errors").isInstanceOf(IllegalModelDefinitionException.class);
    }

    @Test
    public void orphanErrorsUsesAnyAsParent() {
        this.extensionModel = org.mule.runtime.module.extension.api.util.MuleExtensionUtils.loadExtension(HeisenbergWithOrphanErrors.class);
        ErrorModel errorModel = this.extensionModel.getErrorModels().stream().filter(error -> error.getType().equals("HEALTH")).findFirst().get();
        MatcherAssert.assertThat((Object)errorModel.getNamespace(), (Matcher)CoreMatchers.is((Object)HEISENBERG));
        Optional anyExtensionError = errorModel.getParent();
        MatcherAssert.assertThat((Object)anyExtensionError.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((ErrorModel)anyExtensionError.get()).getType(), (Matcher)CoreMatchers.is((Object)MuleErrors.ANY.getType()));
        MatcherAssert.assertThat((Object)((ErrorModel)anyExtensionError.get()).getNamespace(), (Matcher)CoreMatchers.is((Object)MULE_NAMESPACE));
    }

    @Test
    public void operationThrowsOverridesExtensionThrows() {
        this.extensionModel = org.mule.runtime.module.extension.api.util.MuleExtensionUtils.loadExtension(HeisenbergWithOperationThrows.class);
        this.assertErrorPresent((ComponentModel)this.extensionModel.getOperationModel("someOperation").get(), LevelErrorTypes.OPERATION.getType());
    }

    @Test
    public void operationAndConstructInheritExtensionErrorThrows() {
        this.extensionModel = org.mule.runtime.module.extension.api.util.MuleExtensionUtils.loadExtension(HeisenbergWithExtensionThrows.class);
        this.assertErrorPresent((ComponentModel)this.extensionModel.getOperationModel("someOperation").get(), LevelErrorTypes.EXTENSION.getType());
        this.assertErrorPresent((ComponentModel)this.extensionModel.getConstructModel("someConstruct").get(), LevelErrorTypes.EXTENSION.getType());
    }

    @Test
    @Issue(value="W-12289050")
    public void constructHasErrorModels() {
        this.extensionModel = org.mule.runtime.module.extension.api.util.MuleExtensionUtils.loadExtension(HeisenbergWithConstructThrows.class);
        this.assertErrorPresent((ComponentModel)this.extensionModel.getConstructModel("someConstruct").get(), LevelErrorTypes.CONSTRUCT.getType());
    }

    private void assertErrorPresent(ComponentModel componentModel, String errorType) {
        Optional<ErrorModel> componentError = componentModel.getErrorModels().stream().filter(errorModel -> errorModel.getType().equals(errorType)).findFirst();
        MatcherAssert.assertThat((Object)componentError.isPresent(), (Matcher)CoreMatchers.is((Object)true));
    }

    public static enum OrphanErrorTypes implements ErrorTypeDefinition<OrphanErrorTypes>
    {
        HEALTH,
        CONNECTIVITY,
        OAUTH2;

    }

    public static class ExtensionLevelErrorTypeProvider
    implements ErrorTypeProvider {
        public Set<ErrorTypeDefinition> getErrorTypes() {
            return Collections.singleton(LevelErrorTypes.EXTENSION);
        }
    }

    public static class ConstructLevelErrorTypeProvider
    implements ErrorTypeProvider {
        public Set<ErrorTypeDefinition> getErrorTypes() {
            return Collections.singleton(LevelErrorTypes.CONSTRUCT);
        }
    }

    public static class OperationLevelErrorTypeProvider
    implements ErrorTypeProvider {
        public Set<ErrorTypeDefinition> getErrorTypes() {
            return Collections.singleton(LevelErrorTypes.OPERATION);
        }
    }

    private static class ConstructWithoutThrows {
        private ConstructWithoutThrows() {
        }

        public void someConstruct(WhenRoute route, RouterCompletionCallback completionCallback) {
        }
    }

    private static class ConstructWithThrows {
        private ConstructWithThrows() {
        }

        @Throws(value={ConstructLevelErrorTypeProvider.class})
        public void someConstruct(WhenRoute route, RouterCompletionCallback completionCallback) {
        }
    }

    private static class OperationWithoutThrows {
        private OperationWithoutThrows() {
        }

        public void someOperation() {
        }
    }

    private static class OperationWithThrows {
        private OperationWithThrows() {
        }

        @Throws(value={OperationLevelErrorTypeProvider.class})
        public void someOperation() {
        }
    }

    public static enum CyclicErrorTypes implements ErrorTypeDefinition<CyclicErrorTypes>
    {
        TYPE_A{

            public Optional<ErrorTypeDefinition<?>> getParent() {
                return Optional.of(TYPE_B);
            }
        }
        ,
        TYPE_B{

            public Optional<ErrorTypeDefinition<?>> getParent() {
                return Optional.of(TYPE_C);
            }
        }
        ,
        TYPE_C{

            public Optional<ErrorTypeDefinition<?>> getParent() {
                return Optional.of(TYPE_A);
            }
        };

    }

    private static class InvalidErrorOperations {
        private InvalidErrorOperations() {
        }

        @Throws(value={ErrorTypeProviderWithInvalidErrors.class})
        public void someOperation() {
        }

        public static class ErrorTypeProviderWithInvalidErrors
        implements ErrorTypeProvider {
            public Set<ErrorTypeDefinition> getErrorTypes() {
                return Collections.singleton(WrongErrors.WHATEVER);
            }

            public static enum WrongErrors implements ErrorTypeDefinition<MuleErrors>
            {
                WHATEVER{

                    @Override
                    public Optional<ErrorTypeDefinition<?>> getParent() {
                        return Optional.empty();
                    }
                };


                public Optional<ErrorTypeDefinition<?>> getParent() {
                    return Optional.of(MuleErrors.ANY);
                }
            }
        }
    }

    @Extension(name="Heisenberg")
    @org.mule.runtime.extension.api.annotation.error.ErrorTypes(value=LevelErrorTypes.class)
    @Throws(value={ExtensionLevelErrorTypeProvider.class})
    @Operations(value={OperationWithoutThrows.class, ConstructWithoutThrows.class})
    public static class HeisenbergWithExtensionThrows
    extends HeisenbergExtension {
    }

    @Extension(name="Heisenberg")
    @org.mule.runtime.extension.api.annotation.error.ErrorTypes(value=LevelErrorTypes.class)
    @Throws(value={ExtensionLevelErrorTypeProvider.class})
    @Operations(value={ConstructWithThrows.class})
    public static class HeisenbergWithConstructThrows
    extends HeisenbergExtension {
    }

    @Extension(name="Heisenberg")
    @org.mule.runtime.extension.api.annotation.error.ErrorTypes(value=LevelErrorTypes.class)
    @Throws(value={ExtensionLevelErrorTypeProvider.class})
    @Operations(value={OperationWithThrows.class})
    public static class HeisenbergWithOperationThrows
    extends HeisenbergExtension {
    }

    @Extension(name="Heisenberg")
    @org.mule.runtime.extension.api.annotation.error.ErrorTypes(value=OrphanErrorTypes.class)
    public static class HeisenbergWithOrphanErrors
    extends HeisenbergExtension {
    }

    @Extension(name="Heisenberg")
    @Operations(value={InvalidErrorOperations.class})
    @ErrorTypes(value=HeisenbergErrors.class)
    public static class HeisenbergWithNotMappedErrorType
    extends HeisenbergExtension {
    }

    @org.mule.runtime.extension.api.annotation.error.ErrorTypes(value=CyclicErrorTypes.class)
    @Extension(name="Heisenberg")
    public static class HeisenbergWithCyclicErrorTypes
    extends HeisenbergExtension {
    }
}

