/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.streaming;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.extension.api.property.ClassLoaderModelProperty;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.connectivity.ExtensionConnectionSupplier;
import org.mule.runtime.module.extension.internal.runtime.streaming.PagingProviderProducer;
import org.mule.runtime.tracer.api.component.ComponentTracer;
import org.mule.tck.size.SmallTest;

@SmallTest
public class PagingProviderProducerTestCase {
    @Rule
    public MockitoRule rule = MockitoJUnit.rule();
    private final ExtensionConnectionSupplier extensionConnectionSupplier = (ExtensionConnectionSupplier)Mockito.mock(ExtensionConnectionSupplier.class);
    private final ExecutionContextAdapter executionContext = (ExecutionContextAdapter)Mockito.mock(ExecutionContextAdapter.class);
    private final PagingProvider<Object, String> delegate = (PagingProvider)Mockito.mock(PagingProvider.class);
    private final ConfigurationInstance config = (ConfigurationInstance)Mockito.mock(ConfigurationInstance.class);
    private PagingProviderProducer<String> producer;

    private PagingProviderProducer<String> createProducer() {
        return new PagingProviderProducer(this.delegate, this.config, this.executionContext, this.extensionConnectionSupplier, (ComponentTracer)Mockito.mock(ComponentTracer.class));
    }

    @Before
    public void setUp() throws MuleException {
        ExtensionModel extensionModel = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        Mockito.when((Object)this.executionContext.getExtensionModel()).thenReturn((Object)extensionModel);
        ClassLoaderModelProperty property = new ClassLoaderModelProperty(this.getClass().getClassLoader());
        Mockito.when((Object)extensionModel.getModelProperty(ClassLoaderModelProperty.class)).thenReturn(Optional.of(property));
        this.producer = this.createProducer();
        MockitoAnnotations.initMocks(this.producer);
        ConnectionHandler handler = (ConnectionHandler)Mockito.mock(ConnectionHandler.class);
        Mockito.when((Object)handler.getConnection()).thenReturn(new Object());
        Mockito.when((Object)this.extensionConnectionSupplier.getConnection((ExecutionContextAdapter)ArgumentMatchers.eq((Object)this.executionContext), (ComponentTracer)ArgumentMatchers.any())).thenReturn((Object)handler);
    }

    @Test
    public void produce() throws Exception {
        List<String> page = Arrays.asList("bleh");
        Mockito.when((Object)this.delegate.getPage(ArgumentMatchers.any())).thenReturn(page);
        MatcherAssert.assertThat(page, (Matcher)Matchers.sameInstance((Object)this.producer.produce()));
    }

    @Test
    public void produceWithDifferentConnections() throws Exception {
        ConnectionHandler connectionHandler = (ConnectionHandler)Mockito.mock(ConnectionHandler.class);
        Mockito.when((Object)this.extensionConnectionSupplier.getConnection((ExecutionContextAdapter)ArgumentMatchers.any(), (ComponentTracer)ArgumentMatchers.any())).thenReturn((Object)connectionHandler);
        this.produce();
        this.produce();
        ((ConnectionHandler)Mockito.verify((Object)connectionHandler, (VerificationMode)Mockito.times((int)2))).getConnection();
        ((ConnectionHandler)Mockito.verify((Object)connectionHandler, (VerificationMode)Mockito.times((int)2))).release();
    }

    @Test
    public void produceWithStickyConnection() throws Exception {
        Mockito.when((Object)this.delegate.useStickyConnections()).thenReturn((Object)true);
        this.producer = this.createProducer();
        ConnectionHandler connectionHandler = (ConnectionHandler)Mockito.mock(ConnectionHandler.class);
        Mockito.when((Object)this.extensionConnectionSupplier.getConnection((ExecutionContextAdapter)ArgumentMatchers.any(), (ComponentTracer)ArgumentMatchers.any())).thenReturn((Object)connectionHandler);
        this.produce();
        this.produce();
        ((ConnectionHandler)Mockito.verify((Object)connectionHandler, (VerificationMode)Mockito.times((int)1))).getConnection();
        ((ConnectionHandler)Mockito.verify((Object)connectionHandler, (VerificationMode)Mockito.never())).release();
        this.producer.close();
        ((ConnectionHandler)Mockito.verify((Object)connectionHandler)).release();
    }

    @Test
    public void totalAvailable() {
        int total = 10;
        Mockito.when((Object)this.delegate.getTotalResults(ArgumentMatchers.any())).thenReturn(Optional.of(10));
        MatcherAssert.assertThat((Object)10, (Matcher)Matchers.is((Object)this.producer.getSize()));
    }

    @Test
    public void closeQuietly() throws Exception {
        ConnectionHandler connectionHandler = (ConnectionHandler)Mockito.mock(ConnectionHandler.class);
        Mockito.when((Object)this.extensionConnectionSupplier.getConnection((ExecutionContextAdapter)ArgumentMatchers.any(), (ComponentTracer)ArgumentMatchers.any())).thenReturn((Object)connectionHandler);
        this.producer.close();
        ((PagingProvider)Mockito.verify(this.delegate)).close(ArgumentMatchers.any());
        ((ConnectionHandler)Mockito.verify((Object)connectionHandler, (VerificationMode)Mockito.times((int)1))).release();
    }

    @Test(expected=Exception.class)
    public void closeNoisely() throws Exception {
        ((PagingProvider)Mockito.doThrow((Throwable[])new Throwable[]{new DefaultMuleException((Throwable)new Exception())}).when(this.delegate)).close(ArgumentMatchers.any());
        this.producer.close();
    }

    @Test
    public void connectionIsInvalidatedOnConnectionExceptionInProduce() throws Exception {
        this.producer = this.createProducer();
        ConnectionHandler connectionHandler = (ConnectionHandler)Mockito.mock(ConnectionHandler.class);
        Mockito.when((Object)this.extensionConnectionSupplier.getConnection((ExecutionContextAdapter)ArgumentMatchers.any(), (ComponentTracer)ArgumentMatchers.any())).thenReturn((Object)connectionHandler);
        ((PagingProvider)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException((Throwable)new ConnectionException("Invalid Connection"))}).when(this.delegate)).getPage(ArgumentMatchers.any());
        try {
            this.producer.produce();
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)Matchers.instanceOf(ConnectionException.class));
            ((PagingProvider)Mockito.verify(this.delegate, (VerificationMode)Mockito.times((int)1))).close(ArgumentMatchers.any());
            ((ConnectionHandler)Mockito.verify((Object)connectionHandler, (VerificationMode)Mockito.times((int)1))).invalidate();
        }
    }

    @Test
    public void connectionIsReleasedOnExceptionInProduce() throws Exception {
        this.producer = this.createProducer();
        ConnectionHandler connectionHandler = (ConnectionHandler)Mockito.mock(ConnectionHandler.class);
        Mockito.when((Object)this.extensionConnectionSupplier.getConnection((ExecutionContextAdapter)ArgumentMatchers.any(), (ComponentTracer)ArgumentMatchers.any())).thenReturn((Object)connectionHandler);
        ((PagingProvider)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalArgumentException("Invalid arguments")}).when(this.delegate)).getPage(ArgumentMatchers.any());
        try {
            this.producer.produce();
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e, (Matcher)Matchers.instanceOf(IllegalArgumentException.class));
            ((PagingProvider)Mockito.verify(this.delegate, (VerificationMode)Mockito.times((int)1))).close(ArgumentMatchers.any());
            ((ConnectionHandler)Mockito.verify((Object)connectionHandler, (VerificationMode)Mockito.times((int)1))).release();
        }
    }

    @Test
    public void pagingProviderDelegateIsClosedQuietlyOnExceptionInProduceFirstPage() throws Exception {
        this.producer = this.createProducer();
        ConnectionHandler connectionHandler = (ConnectionHandler)Mockito.mock(ConnectionHandler.class);
        Mockito.when((Object)this.extensionConnectionSupplier.getConnection((ExecutionContextAdapter)ArgumentMatchers.any(), (ComponentTracer)ArgumentMatchers.any())).thenReturn((Object)connectionHandler);
        ((PagingProvider)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalArgumentException("Invalid arguments")}).when(this.delegate)).getPage(ArgumentMatchers.any());
        ((PagingProvider)Mockito.doThrow((Throwable[])new Throwable[]{new DefaultMuleException("Error while closing delegate")}).when(this.delegate)).close(ArgumentMatchers.any());
        try {
            this.producer.produce();
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e, (Matcher)Matchers.instanceOf(IllegalArgumentException.class));
            ((PagingProvider)Mockito.verify(this.delegate, (VerificationMode)Mockito.times((int)1))).close(ArgumentMatchers.any());
            ((ConnectionHandler)Mockito.verify((Object)connectionHandler, (VerificationMode)Mockito.times((int)1))).release();
        }
    }

    @Test
    public void connectionIsClosedQuietlyInClose() throws Exception {
        this.producer = this.createProducer();
        ConnectionHandler connectionHandler = (ConnectionHandler)Mockito.mock(ConnectionHandler.class);
        ((ConnectionHandler)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalArgumentException("There was a problem releasing the connection")}).when((Object)connectionHandler)).release();
        Mockito.when((Object)this.extensionConnectionSupplier.getConnection((ExecutionContextAdapter)ArgumentMatchers.any(), (ComponentTracer)ArgumentMatchers.any())).thenReturn((Object)connectionHandler);
        this.producer.close();
        ((PagingProvider)Mockito.verify(this.delegate, (VerificationMode)Mockito.times((int)1))).close(ArgumentMatchers.any());
        ((ConnectionHandler)Mockito.verify((Object)connectionHandler, (VerificationMode)Mockito.times((int)1))).release();
    }
}

