/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.exception;

import io.qameta.allure.Description;
import io.qameta.allure.Issue;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.api.meta.model.error.ErrorModelBuilder;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.extension.api.runtime.exception.SdkExceptionHandlerFactory;
import org.mule.runtime.module.extension.internal.runtime.exception.ExceptionHandlerManager;
import org.mule.runtime.module.extension.internal.runtime.exception.SdkMethodInvocationException;
import org.mule.sdk.api.runtime.exception.ExceptionHandler;
import org.mule.tck.size.SmallTest;
import org.mule.test.heisenberg.extension.exception.HeisenbergException;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class ExceptionHandlerManagerTestCase {
    private static final String EXTENSION_NAME = "Extension";
    private static final String EXTENSION_NAMESPACE = "EXTENSION";
    private static final String MULE_NAMESPACE = "MULE";
    private static final String CONNECTIVITY_ERROR_TYPE = "CONNECTIVITY";
    private static final String ERROR_MESSAGE = "ERROR MESSAGE";
    private static final String EXTENSION_NAME_WITH_SPACES = "extension With Spaces";
    @Mock(lenient=true)
    private ExtensionModel extensionModel;
    @Mock(lenient=true)
    private SourceModel sourceModel;
    @Mock
    private SdkExceptionHandlerFactory extensionFactory;
    @Mock
    private ExceptionHandler extensionEnricher;
    @Mock
    private SdkExceptionHandlerFactory sourceFactory;
    @Mock
    private ExceptionHandler sourceEnricher;
    @Mock
    private ErrorTypeRepository errorTypeRepository;
    private ExceptionHandlerManager manager;

    @Before
    public void beforeTest() {
        Mockito.when((Object)this.extensionFactory.createHandler()).thenReturn((Object)this.extensionEnricher);
        ExtensionsTestUtils.mockExceptionEnricher((EnrichableModel)this.extensionModel, this.extensionFactory);
        ExtensionsTestUtils.mockExceptionEnricher((EnrichableModel)this.sourceModel, this.sourceFactory);
        Mockito.when((Object)this.sourceEnricher.enrichException((Exception)ArgumentMatchers.any(Exception.class))).thenReturn((Object)new HeisenbergException(ERROR_MESSAGE));
        Mockito.when((Object)this.sourceFactory.createHandler()).thenReturn((Object)this.sourceEnricher);
        Mockito.when((Object)this.extensionModel.getXmlDslModel()).thenReturn((Object)XmlDslModel.builder().setPrefix("test-extension").build());
        Mockito.when((Object)this.extensionModel.getName()).thenReturn((Object)EXTENSION_NAME);
        Mockito.when((Object)this.extensionModel.getErrorModels()).thenReturn((Object)Collections.EMPTY_SET);
        Mockito.when((Object)this.sourceModel.getName()).thenReturn((Object)"Test Source");
        this.manager = new ExceptionHandlerManager(this.extensionModel, (ComponentModel)this.sourceModel);
        this.mockErrorTypesRepository();
    }

    @Test
    public void processAndEnrich() {
        ConnectionException connectionException = new ConnectionException("Connection Error");
        Throwable throwable = this.manager.process((Throwable)connectionException);
        MatcherAssert.assertThat((Object)throwable, (Matcher)Is.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)connectionException))));
        MatcherAssert.assertThat((Object)throwable, (Matcher)Is.is((Matcher)CoreMatchers.instanceOf(HeisenbergException.class)));
        MatcherAssert.assertThat((Object)throwable.getMessage(), (Matcher)Is.is((Object)ERROR_MESSAGE));
    }

    @Test
    public void handleConnectionException() {
        ConnectionException rootCause = new ConnectionException(ERROR_MESSAGE, (Throwable)new Exception());
        Throwable throwable = this.manager.handleThrowable(new Throwable(new RuntimeException(new ExecutionException((Throwable)rootCause))));
        MatcherAssert.assertThat((Object)throwable, (Matcher)Is.is((Matcher)CoreMatchers.instanceOf(ConnectionException.class)));
        MatcherAssert.assertThat((Object)throwable.getMessage(), (Matcher)Is.is((Object)ERROR_MESSAGE));
        MatcherAssert.assertThat((Object)throwable, (Matcher)Is.is((Matcher)CoreMatchers.sameInstance((Object)rootCause)));
    }

    @Test
    public void handleSdkMethodInvocationExceptionCause() {
        IOException rootCause = new IOException(ERROR_MESSAGE, new Exception());
        Throwable throwable = this.manager.handleThrowable((Throwable)new SdkMethodInvocationException((Throwable)rootCause));
        MatcherAssert.assertThat((Object)throwable, (Matcher)Is.is((Matcher)CoreMatchers.instanceOf(IOException.class)));
        MatcherAssert.assertThat((Object)throwable.getMessage(), (Matcher)Is.is((Object)ERROR_MESSAGE));
        MatcherAssert.assertThat((Object)throwable, (Matcher)Is.is((Matcher)CoreMatchers.sameInstance((Object)rootCause)));
    }

    @Test
    public void findCorrectEnricher() {
        MatcherAssert.assertThat((Object)this.manager.getExceptionHandler(), (Matcher)Is.is((Object)this.sourceEnricher));
        ExtensionsTestUtils.mockExceptionEnricher((EnrichableModel)this.sourceModel, null);
        ExceptionHandlerManager manager = new ExceptionHandlerManager(this.extensionModel, (ComponentModel)this.sourceModel);
        MatcherAssert.assertThat((Object)manager.getExceptionHandler(), (Matcher)Is.is((Object)this.extensionEnricher));
    }

    @Test
    public void processError() {
        Error rootCause = new Error(ERROR_MESSAGE, new Exception());
        Throwable throwable = this.manager.process((Throwable)rootCause);
        MatcherAssert.assertThat((Object)throwable.getMessage(), (Matcher)Is.is((Object)ERROR_MESSAGE));
        MatcherAssert.assertThat((Object)throwable, (Matcher)Is.is((Matcher)CoreMatchers.sameInstance((Object)rootCause)));
    }

    @Test
    public void handleConnectionExceptionExtensionWithCustomConnectivityError() {
        HashSet<ErrorModel> errorModels = new HashSet<ErrorModel>();
        errorModels.add(ErrorModelBuilder.newError((String)CONNECTIVITY_ERROR_TYPE, (String)EXTENSION_NAMESPACE).build());
        errorModels.add(ErrorModelBuilder.newError((String)CONNECTIVITY_ERROR_TYPE, (String)MULE_NAMESPACE).build());
        Mockito.when((Object)this.extensionModel.getErrorModels()).thenReturn(errorModels);
        ExceptionHandlerManager exceptionHandlerManager = new ExceptionHandlerManager(this.extensionModel, (ComponentModel)this.sourceModel, this.errorTypeRepository);
        ConnectionException connectionException = new ConnectionException(ERROR_MESSAGE, (Throwable)new Exception());
        Throwable throwable = exceptionHandlerManager.handleThrowable(new Throwable((Throwable)connectionException));
        MatcherAssert.assertThat((Object)throwable, (Matcher)Is.is((Matcher)CoreMatchers.instanceOf(ConnectionException.class)));
        MatcherAssert.assertThat((Object)throwable.getMessage(), (Matcher)Is.is((Object)ERROR_MESSAGE));
        MatcherAssert.assertThat((Object)((ConnectionException)throwable).getErrorType().isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((ErrorType)((ConnectionException)throwable).getErrorType().get()).getIdentifier(), (Matcher)Is.is((Object)CONNECTIVITY_ERROR_TYPE));
        MatcherAssert.assertThat((Object)((ErrorType)((ConnectionException)throwable).getErrorType().get()).getNamespace(), (Matcher)Is.is((Object)EXTENSION_NAMESPACE));
    }

    @Test
    @Issue(value="W-10617943")
    @Description(value="This test checks for extension names with spaces and verifies that correct error type is picked based on namespace")
    public void handleConnectionExceptionExtensionWithSpacesAndCustomConnectivityError() {
        HashSet<ErrorModel> errorModels = new HashSet<ErrorModel>();
        errorModels.add(ErrorModelBuilder.newError((String)CONNECTIVITY_ERROR_TYPE, (String)EXTENSION_NAMESPACE).build());
        errorModels.add(ErrorModelBuilder.newError((String)CONNECTIVITY_ERROR_TYPE, (String)MULE_NAMESPACE).build());
        Mockito.when((Object)this.extensionModel.getName()).thenReturn((Object)EXTENSION_NAME_WITH_SPACES);
        Mockito.when((Object)this.extensionModel.getErrorModels()).thenReturn(errorModels);
        Mockito.when((Object)this.extensionModel.getXmlDslModel()).thenReturn((Object)XmlDslModel.builder().setPrefix(EXTENSION_NAMESPACE).build());
        ExceptionHandlerManager exceptionHandlerManager = new ExceptionHandlerManager(this.extensionModel, (ComponentModel)this.sourceModel, this.errorTypeRepository);
        ConnectionException connectionException = new ConnectionException(ERROR_MESSAGE, (Throwable)new Exception());
        Throwable throwable = exceptionHandlerManager.handleThrowable(new Throwable((Throwable)connectionException));
        MatcherAssert.assertThat((Object)throwable, (Matcher)Is.is((Matcher)CoreMatchers.instanceOf(ConnectionException.class)));
        MatcherAssert.assertThat((Object)throwable.getMessage(), (Matcher)Is.is((Object)ERROR_MESSAGE));
        MatcherAssert.assertThat((Object)((ConnectionException)throwable).getErrorType().isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((ErrorType)((ConnectionException)throwable).getErrorType().get()).getIdentifier(), (Matcher)Is.is((Object)CONNECTIVITY_ERROR_TYPE));
        MatcherAssert.assertThat((Object)((ErrorType)((ConnectionException)throwable).getErrorType().get()).getNamespace(), (Matcher)Is.is((Object)EXTENSION_NAMESPACE));
    }

    @Test
    public void handleConnectionExceptionExtensionWithoutCustomConnectivityError() {
        HashSet<ErrorModel> errorModels = new HashSet<ErrorModel>();
        errorModels.add(ErrorModelBuilder.newError((String)CONNECTIVITY_ERROR_TYPE, (String)MULE_NAMESPACE).build());
        Mockito.when((Object)this.extensionModel.getErrorModels()).thenReturn(errorModels);
        ExceptionHandlerManager exceptionHandlerManager = new ExceptionHandlerManager(this.extensionModel, (ComponentModel)this.sourceModel, this.errorTypeRepository);
        ConnectionException connectionException = new ConnectionException(ERROR_MESSAGE, (Throwable)new Exception());
        Throwable throwable = exceptionHandlerManager.handleThrowable(new Throwable((Throwable)connectionException));
        MatcherAssert.assertThat((Object)throwable, (Matcher)Is.is((Matcher)CoreMatchers.instanceOf(ConnectionException.class)));
        MatcherAssert.assertThat((Object)throwable.getMessage(), (Matcher)Is.is((Object)ERROR_MESSAGE));
        MatcherAssert.assertThat((Object)((ConnectionException)throwable).getErrorType().isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((ErrorType)((ConnectionException)throwable).getErrorType().get()).getIdentifier(), (Matcher)Is.is((Object)CONNECTIVITY_ERROR_TYPE));
        MatcherAssert.assertThat((Object)((ErrorType)((ConnectionException)throwable).getErrorType().get()).getNamespace(), (Matcher)Is.is((Object)MULE_NAMESPACE));
    }

    private void mockErrorTypesRepository() {
        ErrorType extensionConnectivityErrorType = this.createErrorType(CONNECTIVITY_ERROR_TYPE, EXTENSION_NAMESPACE);
        ErrorType muleConnectivityErrorType = this.createErrorType(CONNECTIVITY_ERROR_TYPE, MULE_NAMESPACE);
        Mockito.when((Object)this.errorTypeRepository.getErrorType(ComponentIdentifier.builder().namespace(EXTENSION_NAMESPACE).name(CONNECTIVITY_ERROR_TYPE).build())).thenReturn(Optional.of(extensionConnectivityErrorType));
        Mockito.when((Object)this.errorTypeRepository.getErrorType(ComponentIdentifier.builder().namespace(MULE_NAMESPACE).name(CONNECTIVITY_ERROR_TYPE).build())).thenReturn(Optional.of(muleConnectivityErrorType));
    }

    private ErrorType createErrorType(final String identifier, final String namespace) {
        return new ErrorType(){

            public String getIdentifier() {
                return identifier;
            }

            public String getNamespace() {
                return namespace;
            }

            public ErrorType getParentErrorType() {
                return null;
            }
        };
    }
}

