/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.util.Collections;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.core.api.config.MuleManifest;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.ExtensionModelLoadingRequest;
import org.mule.runtime.extension.internal.loader.DefaultExtensionLoadingContext;
import org.mule.runtime.module.extension.internal.loader.enricher.EnricherTestUtils;
import org.mule.runtime.module.extension.internal.loader.java.enricher.JavaOAuthDeclarationEnricher;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.test.module.extension.internal.util.ExtensionDeclarationTestUtils;
import org.mule.test.oauth.TestOAuthExtension;

public class JavaOAuthDeclarationEnricherTestCase
extends AbstractMuleTestCase {
    private ExtensionDeclaration declaration = null;

    @Before
    public void setUp() {
        ExtensionDeclarer declarer = ExtensionDeclarationTestUtils.declarerFor(TestOAuthExtension.class, MuleManifest.getProductVersion());
        new JavaOAuthDeclarationEnricher().enrich((ExtensionLoadingContext)new DefaultExtensionLoadingContext(declarer, ExtensionModelLoadingRequest.builder((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (DslResolvingContext)DslResolvingContext.getDefault(Collections.emptySet())).build()));
        this.declaration = (ExtensionDeclaration)declarer.getDeclaration();
    }

    @Test
    public void verifyUnauthorizeOperationIsAddedToAllConfigs() {
        this.declaration.getConfigurations().stream().forEach(configurationDeclaration -> {
            OperationDeclaration operationDeclaration = (OperationDeclaration)EnricherTestUtils.getDeclaration(configurationDeclaration.getOperations(), "unauthorize");
            MatcherAssert.assertThat((Object)operationDeclaration, (Matcher)Is.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        });
    }
}

