/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.delegate;

import io.qameta.allure.Issue;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.BaseDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.NamedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OutputDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.core.api.config.MuleManifest;
import org.mule.runtime.extension.api.property.MetadataKeyPartModelProperty;
import org.mule.runtime.extension.api.property.ResolverInformation;
import org.mule.runtime.extension.api.property.TypeResolversInformationModelProperty;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.ParameterTypeWrapper;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.TypeWrapper;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.test.metadata.extension.MetadataExtension;
import org.mule.test.metadata.extension.model.attribute.AbstractOutputAttributes;
import org.mule.test.metadata.extension.model.shapes.Shape;
import org.mule.test.metadata.extension.resolver.TestInputResolver;
import org.mule.test.module.extension.internal.util.ExtensionDeclarationTestUtils;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

public class OperationModelLoaderDelegateTestCase
extends AbstractMuleTestCase {
    private static final String SDK_CONTENT_METADATA_WITH_KEY_ID = "sdkContentMetadataWithKeyId";
    private ExtensionDeclaration declaration;

    @Before
    public void setUp() {
        ExtensionDeclarer declarer = ExtensionDeclarationTestUtils.declarerFor(MetadataExtension.class, MuleManifest.getProductVersion());
        this.declaration = (ExtensionDeclaration)declarer.getDeclaration();
    }

    @Test
    public void parseMetadataAnnotationsOnParameter() {
        OperationDeclaration operationDeclaration = (OperationDeclaration)OperationModelLoaderDelegateTestCase.getDeclaration(((ConfigurationDeclaration)this.declaration.getConfigurations().get(0)).getOperations(), SDK_CONTENT_METADATA_WITH_KEY_ID);
        List parameters = operationDeclaration.getAllParameters();
        this.assertParameterIsMetadataKeyPart((ParameterDeclaration)OperationModelLoaderDelegateTestCase.getDeclaration(parameters, "type"));
        this.assertParameterIsMetadataContent((ParameterDeclaration)OperationModelLoaderDelegateTestCase.getDeclaration(parameters, "content"));
    }

    @Test
    public void declareStaticAndDynamicTypesInOperation() {
        List operations = ((ConfigurationDeclaration)this.declaration.getConfigurations().get(0)).getOperations();
        MetadataType outputMetadataType = IntrospectionUtils.getReturnType((Type)new TypeWrapper(Object.class, ExtensionsTestUtils.TYPE_LOADER));
        MetadataType objectParameterMetadataType = new ParameterTypeWrapper(Object.class, ExtensionsTestUtils.TYPE_LOADER).asMetadataType();
        OperationDeclaration dynamicContent = (OperationDeclaration)OperationModelLoaderDelegateTestCase.getDeclaration(operations, SDK_CONTENT_METADATA_WITH_KEY_ID);
        this.assertOutputType(dynamicContent.getOutput(), outputMetadataType, true);
        this.assertOutputType(dynamicContent.getOutputAttributes(), ExtensionsTestUtils.toMetadataType(Void.TYPE), false);
        List params = dynamicContent.getAllParameters();
        this.assertParameterType((ParameterDeclaration)OperationModelLoaderDelegateTestCase.getDeclaration(params, "type"), ExtensionsTestUtils.toMetadataType(String.class));
        this.assertParameterType((ParameterDeclaration)OperationModelLoaderDelegateTestCase.getDeclaration(params, "content"), objectParameterMetadataType);
        OperationDeclaration dynamicOutput = (OperationDeclaration)OperationModelLoaderDelegateTestCase.getDeclaration(operations, "outputMetadataWithKeyId");
        this.assertOutputType(dynamicOutput.getOutput(), outputMetadataType, true);
        this.assertOutputType(dynamicOutput.getOutputAttributes(), ExtensionsTestUtils.toMetadataType(Void.TYPE), false);
        params = dynamicOutput.getAllParameters();
        this.assertParameterType((ParameterDeclaration)OperationModelLoaderDelegateTestCase.getDeclaration(params, "type"), ExtensionsTestUtils.toMetadataType(String.class));
        this.assertParameterType((ParameterDeclaration)OperationModelLoaderDelegateTestCase.getDeclaration(params, "content"), objectParameterMetadataType);
        OperationDeclaration dynamicContentAndOutput = (OperationDeclaration)OperationModelLoaderDelegateTestCase.getDeclaration(operations, "contentAndOutputMetadataWithKeyId");
        this.assertOutputType(dynamicContentAndOutput.getOutput(), outputMetadataType, true);
        this.assertOutputType(dynamicContentAndOutput.getOutputAttributes(), ExtensionsTestUtils.toMetadataType(Void.TYPE), false);
        params = dynamicContentAndOutput.getAllParameters();
        this.assertParameterType((ParameterDeclaration)OperationModelLoaderDelegateTestCase.getDeclaration(params, "type"), ExtensionsTestUtils.toMetadataType(String.class));
        this.assertParameterType((ParameterDeclaration)OperationModelLoaderDelegateTestCase.getDeclaration(params, "content"), objectParameterMetadataType);
        operations = this.declaration.getOperations();
        OperationDeclaration dynamicOutputAndAttributes = (OperationDeclaration)OperationModelLoaderDelegateTestCase.getDeclaration(operations, "sdkOutputAttributesWithDynamicMetadata");
        this.assertOutputType(dynamicOutputAndAttributes.getOutput(), ExtensionsTestUtils.toMetadataType(Object.class), true);
        this.assertOutputType(dynamicOutputAndAttributes.getOutputAttributes(), ExtensionsTestUtils.toMetadataType(AbstractOutputAttributes.class), true);
        params = dynamicOutputAndAttributes.getAllParameters();
        this.assertParameterType((ParameterDeclaration)OperationModelLoaderDelegateTestCase.getDeclaration(params, "type"), ExtensionsTestUtils.toMetadataType(String.class));
        OperationDeclaration staticOutputOnly = (OperationDeclaration)OperationModelLoaderDelegateTestCase.getDeclaration(operations, "typeWithDeclaredSubtypesMetadata");
        this.assertOutputType(staticOutputOnly.getOutput(), ExtensionsTestUtils.toMetadataType(Boolean.TYPE), false);
        this.assertOutputType(staticOutputOnly.getOutputAttributes(), ExtensionsTestUtils.toMetadataType(Void.TYPE), false);
        OperationDeclaration staticOutputAndAttributes = (OperationDeclaration)OperationModelLoaderDelegateTestCase.getDeclaration(operations, "outputAttributesWithDeclaredSubtypesMetadata");
        this.assertOutputType(staticOutputAndAttributes.getOutput(), ExtensionsTestUtils.toMetadataType(Shape.class), false);
        this.assertOutputType(staticOutputAndAttributes.getOutputAttributes(), ExtensionsTestUtils.toMetadataType(AbstractOutputAttributes.class), false);
    }

    @Test
    public void typeResolverInformationSkippedForStaticResolver() throws Exception {
        OperationDeclaration operation = (OperationDeclaration)OperationModelLoaderDelegateTestCase.getDeclaration(this.declaration.getOperations(), "outputAttributesWithDeclaredSubtypesMetadata");
        Optional info = operation.getModelProperty(TypeResolversInformationModelProperty.class);
        Assert.assertThat((String)"Static resolvers information should not be declared in the model", (Object)info.isPresent(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void declaresTypeResolverInformationForDynamicResolver() throws Exception {
        List operations = ((ConfigurationDeclaration)this.declaration.getConfigurations().get(0)).getOperations();
        OperationDeclaration dynamicContent = (OperationDeclaration)OperationModelLoaderDelegateTestCase.getDeclaration(operations, SDK_CONTENT_METADATA_WITH_KEY_ID);
        this.assertCategoryInfo((BaseDeclaration)dynamicContent, "MetadataExtensionResolver");
        this.assertOutputResolverInfo((BaseDeclaration)dynamicContent, Optional.of("SdkTestOutputAnyTypeResolver"));
        this.assertAttributesResolverInfo((BaseDeclaration)dynamicContent, Optional.empty());
        this.assertParamResolverInfo((BaseDeclaration)dynamicContent, "type", Optional.empty());
        this.assertParamResolverInfo((BaseDeclaration)dynamicContent, "content", Optional.of("SdkTestInputResolverWithKeyResolver"));
        OperationDeclaration dynamicOutput = (OperationDeclaration)OperationModelLoaderDelegateTestCase.getDeclaration(operations, "outputMetadataWithKeyId");
        this.assertCategoryInfo((BaseDeclaration)dynamicOutput, "MetadataExtensionResolver");
        this.assertOutputResolverInfo((BaseDeclaration)dynamicOutput, Optional.of("TestOutputResolverWithKeyResolver"));
        this.assertAttributesResolverInfo((BaseDeclaration)dynamicOutput, Optional.empty());
        this.assertKeysResolverInfo((BaseDeclaration)dynamicOutput, Optional.of("TestOutputResolverWithKeyResolver"));
        this.assertParamResolverInfo((BaseDeclaration)dynamicOutput, "type", Optional.empty());
        this.assertParamResolverInfo((BaseDeclaration)dynamicOutput, "content", Optional.empty());
        OperationDeclaration outputAndmultipleInput = (OperationDeclaration)OperationModelLoaderDelegateTestCase.getDeclaration(operations, "outputAndMultipleInputWithKeyId");
        this.assertCategoryInfo((BaseDeclaration)outputAndmultipleInput, "MetadataExtensionResolver");
        this.assertOutputResolverInfo((BaseDeclaration)outputAndmultipleInput, Optional.of("TestInputAndOutputResolverWithKeyResolver"));
        this.assertAttributesResolverInfo((BaseDeclaration)outputAndmultipleInput, Optional.empty());
        this.assertParamResolverInfo((BaseDeclaration)outputAndmultipleInput, "type", Optional.empty());
        this.assertParamResolverInfo((BaseDeclaration)outputAndmultipleInput, "firstPerson", Optional.of("TestInputAndOutputResolverWithKeyResolver"));
        this.assertParamResolverInfo((BaseDeclaration)outputAndmultipleInput, "otherPerson", Optional.of("TestInputAndOutputResolverWithKeyResolver"));
        OperationDeclaration simpleMultiLevelKeyResolver = (OperationDeclaration)OperationModelLoaderDelegateTestCase.getDeclaration(operations, "simpleMultiLevelKeyResolver");
        this.assertCategoryInfo((BaseDeclaration)simpleMultiLevelKeyResolver, "MetadataExtensionResolver");
        this.assertOutputResolverInfo((BaseDeclaration)simpleMultiLevelKeyResolver, Optional.empty());
        this.assertAttributesResolverInfo((BaseDeclaration)simpleMultiLevelKeyResolver, Optional.empty());
        this.assertKeysResolverInfo((BaseDeclaration)simpleMultiLevelKeyResolver, Optional.of("TestMultiLevelKeyResolver"));
        this.assertParamResolverInfo((BaseDeclaration)simpleMultiLevelKeyResolver, "content", Optional.of("TestMultiLevelKeyResolver"));
        this.assertParamResolverInfo((BaseDeclaration)simpleMultiLevelKeyResolver, "continent", Optional.empty());
        this.assertParamResolverInfo((BaseDeclaration)simpleMultiLevelKeyResolver, "country", Optional.empty());
        this.assertParamResolverInfo((BaseDeclaration)simpleMultiLevelKeyResolver, "city", Optional.empty());
        OperationDeclaration withoutKeysWithKeyId = (OperationDeclaration)OperationModelLoaderDelegateTestCase.getDeclaration(operations, "contentMetadataWithoutKeysWithKeyId");
        this.assertCategoryInfo((BaseDeclaration)withoutKeysWithKeyId, "MetadataExtensionResolver");
        this.assertOutputResolverInfo((BaseDeclaration)withoutKeysWithKeyId, Optional.empty());
        this.assertAttributesResolverInfo((BaseDeclaration)withoutKeysWithKeyId, Optional.empty());
        this.assertKeysResolverInfo((BaseDeclaration)withoutKeysWithKeyId, Optional.empty());
        this.assertParamResolverInfo((BaseDeclaration)withoutKeysWithKeyId, "content", Optional.of("TestInputResolverWithoutKeyResolver"));
        List messageSources = ((ConfigurationDeclaration)this.declaration.getConfigurations().get(0)).getMessageSources();
        SourceDeclaration sourceDynamicAttributes = (SourceDeclaration)OperationModelLoaderDelegateTestCase.getDeclaration(messageSources, "MetadataSource");
        this.assertCategoryInfo((BaseDeclaration)sourceDynamicAttributes, "MetadataExtensionResolver");
        this.assertOutputResolverInfo((BaseDeclaration)sourceDynamicAttributes, Optional.of("TestInputAndOutputWithAttributesResolverWithKeyResolver"));
        this.assertAttributesResolverInfo((BaseDeclaration)sourceDynamicAttributes, Optional.empty());
        this.assertKeysResolverInfo((BaseDeclaration)sourceDynamicAttributes, Optional.of("TestInputOutputSourceResolverWithKeyResolver"));
    }

    @Test
    @Issue(value="W-12739062")
    public void inputTypeResolverForParameterInParameterGroup() {
        List operations = this.declaration.getOperations();
        OperationDeclaration operation = (OperationDeclaration)OperationModelLoaderDelegateTestCase.getDeclaration(operations, "inputMetadataResolverInParameterInParameterGroup");
        this.assertParamResolverInfo((BaseDeclaration)operation, "bear", Optional.of(TestInputResolver.INPUT_RESOLVER_NAME));
    }

    private void assertParameterIsMetadataKeyPart(ParameterDeclaration param) {
        this.checkIsPresent((BaseDeclaration)param, MetadataKeyPartModelProperty.class);
    }

    private void assertParameterIsMetadataContent(ParameterDeclaration param) {
        Assert.assertThat((Object)param.getRole(), (Matcher)CoreMatchers.is((Object)ParameterRole.CONTENT));
    }

    private void assertOutputType(OutputDeclaration output, MetadataType type, boolean isDynamic) {
        Assert.assertThat((Object)output.getType(), (Matcher)CoreMatchers.equalTo((Object)type));
        Assert.assertThat((Object)output.hasDynamicType(), (Matcher)CoreMatchers.is((Object)isDynamic));
    }

    private void assertOutputResolverInfo(BaseDeclaration declaration, Optional<String> expectedName) {
        this.assertResolverInfo(declaration, info -> info.getOutputResolver(), "OutputResolver", expectedName);
    }

    private void assertParameterType(ParameterDeclaration param, MetadataType type) {
        Assert.assertThat((Object)param.getType(), (Matcher)CoreMatchers.equalTo((Object)type));
    }

    private void assertCategoryInfo(BaseDeclaration declaration, String expectedName) {
        TypeResolversInformationModelProperty info = this.getResolversInfo(declaration);
        Assert.assertThat((String)"Name miss match for the resolvers category: ", (Object)info.getCategoryName(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)expectedName)));
    }

    private void assertResolverInfo(BaseDeclaration declaration, Function<TypeResolversInformationModelProperty, Optional<ResolverInformation>> resolverSupplier, String kind, Optional<String> expectedName) {
        TypeResolversInformationModelProperty info = this.getResolversInfo(declaration);
        Optional<ResolverInformation> resolverName = resolverSupplier.apply(info);
        if (expectedName.isPresent() && !resolverName.isPresent()) {
            Assert.fail((String)String.format("Expected %s name to be '%s' but it was not declared in the model. Information was: %s", kind, expectedName, info.toString()));
        } else if (!expectedName.isPresent() && resolverName.isPresent()) {
            Assert.fail((String)String.format("Expected %s name to be empty, but a declaration was found in the model. Information was: %s", kind, info.toString()));
        }
        Assert.assertThat((String)("Name miss match for the " + kind), resolverName.map(ResolverInformation::getResolverName), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(expectedName)));
    }

    private void assertAttributesResolverInfo(BaseDeclaration declaration, Optional<String> expectedName) {
        this.assertResolverInfo(declaration, info -> info.getAttributesResolver(), "AttributesResolver", expectedName);
    }

    private void assertParamResolverInfo(BaseDeclaration declaration, String param, Optional<String> expectedName) {
        this.assertResolverInfo(declaration, info -> info.getParameterResolver(param), "ParameterResolver", expectedName);
    }

    private void assertKeysResolverInfo(BaseDeclaration declaration, Optional<String> expectedName) {
        this.assertResolverInfo(declaration, info -> info.getKeysResolver(), "KeysResolver", expectedName);
    }

    private static <T extends NamedDeclaration> T getDeclaration(List<T> operationList, String name) {
        return (T)((NamedDeclaration)operationList.stream().filter(operation -> operation.getName().equals(name)).collect(Collectors.toList()).get(0));
    }

    private TypeResolversInformationModelProperty getResolversInfo(BaseDeclaration declaration) {
        Optional info = declaration.getModelProperty(TypeResolversInformationModelProperty.class);
        if (!info.isPresent()) {
            Assert.fail((String)("Expected to have information of TypeResolvers but found no model property of class: " + TypeResolversInformationModelProperty.class.getName()));
        }
        return (TypeResolversInformationModelProperty)info.get();
    }

    private <T extends ModelProperty> T checkIsPresent(BaseDeclaration declaration, Class<T> modelProperty) {
        Optional property = declaration.getModelProperty(modelProperty);
        Assert.assertThat((Object)property.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        return (T)((ModelProperty)property.get());
    }
}

