/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.execution;

import io.qameta.allure.Description;
import io.qameta.allure.Issue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.operation.CompletableComponentExecutor;
import org.mule.runtime.module.extension.internal.runtime.execution.SdkInternalContext;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class SdkInternalContextTestCase
extends AbstractMuleTestCase {
    @Rule
    public ExpectedException expected = ExpectedException.none();

    @Test
    @Issue(value="MULE-18189")
    @Description(value="scatter-gather sends the same event to different routes. In that case, the relationship of what context belongs to the operation on what route must be kept.")
    public void contextSharedOnParallelRoutes() throws MuleException {
        SdkInternalContext ctx = new SdkInternalContext();
        ComponentLocation comp1 = DefaultComponentLocation.from((String)"comp1");
        ComponentLocation comp2 = DefaultComponentLocation.from((String)"comp2");
        ArrayList<Pair<ComponentLocation, String>> completedForComponents = new ArrayList<Pair<ComponentLocation, String>>();
        this.pushContext(ctx, comp1, "event1", completedForComponents);
        this.pushContext(ctx, comp2, "event1", completedForComponents);
        ctx.getOperationExecutionParams(comp1, "event1").getCallback().complete((Object)comp1);
        ctx.getOperationExecutionParams(comp2, "event1").getCallback().complete((Object)comp2);
        MatcherAssert.assertThat(completedForComponents, (Matcher)Matchers.contains((Object[])new Pair[]{new Pair((Object)comp1, (Object)"event1"), new Pair((Object)comp2, (Object)"event1")}));
    }

    @Test
    @Issue(value="MULE-18227")
    @Description(value="parallel-foreach sends differenr events to the same routes. In that case, the relationship of what context belongs to the operation on what route must be kept.")
    public void contextSharedOnParallelEvents() throws MuleException {
        SdkInternalContext ctx = new SdkInternalContext();
        ComponentLocation comp1 = DefaultComponentLocation.from((String)"comp1");
        ArrayList<Pair<ComponentLocation, String>> completedForComponents = new ArrayList<Pair<ComponentLocation, String>>();
        this.pushContext(ctx, comp1, "event1", completedForComponents);
        this.pushContext(ctx, comp1, "event2", completedForComponents);
        ctx.getOperationExecutionParams(comp1, "event1").getCallback().complete((Object)comp1);
        ctx.getOperationExecutionParams(comp1, "event2").getCallback().complete((Object)comp1);
        MatcherAssert.assertThat(completedForComponents, (Matcher)Matchers.contains((Object[])new Pair[]{new Pair((Object)comp1, (Object)"event1"), new Pair((Object)comp1, (Object)"event2")}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Issue(value="W-17980769")
    public void putCollidingKeys() {
        SdkInternalContext ctx = new SdkInternalContext();
        ComponentLocation comp1 = DefaultComponentLocation.from((String)"comp1");
        ctx.putContext(comp1, "event1");
        ConfigurationInstance configInstance = (ConfigurationInstance)Mockito.mock(ConfigurationInstance.class);
        ctx.setConfiguration(comp1, "event1", Optional.of(configInstance));
        this.expected.expect(IllegalStateException.class);
        try {
            ctx.putContext(comp1, "event1");
        }
        finally {
            MatcherAssert.assertThat((String)"The failed call to `putContext` overwrote the original context", (Object)((ConfigurationInstance)ctx.getConfiguration(comp1, "event1").get()), (Matcher)Matchers.sameInstance((Object)configInstance));
        }
    }

    @Test
    @Issue(value="W-17980769")
    public void putOperationExecutionParamsTwice() throws MuleException {
        SdkInternalContext ctx = new SdkInternalContext();
        ComponentLocation comp1 = DefaultComponentLocation.from((String)"comp1");
        ctx.putContext(comp1, "event1");
        ctx.setOperationExecutionParams(comp1, "event1", Optional.empty(), Collections.emptyMap(), this.testEvent(), null, null);
        this.expected.expect(IllegalStateException.class);
        ctx.setOperationExecutionParams(comp1, "event1", Optional.empty(), Collections.emptyMap(), this.testEvent(), null, null);
    }

    @Test
    @Issue(value="W-17980769")
    public void putOperationExecutionWithoutContext() throws MuleException {
        SdkInternalContext ctx = new SdkInternalContext();
        ComponentLocation comp1 = DefaultComponentLocation.from((String)"comp1");
        this.expected.expect(NullPointerException.class);
        ctx.setOperationExecutionParams(comp1, "test", Optional.empty(), Collections.emptyMap(), this.testEvent(), null, null);
    }

    private void pushContext(SdkInternalContext ctx, final ComponentLocation location, final String eventId, final List<Pair<ComponentLocation, String>> completedForComponents) throws MuleException {
        ctx.putContext(location, eventId);
        ctx.setOperationExecutionParams(location, eventId, Optional.empty(), Collections.emptyMap(), this.testEvent(), new CompletableComponentExecutor.ExecutorCallback(){

            public void complete(Object value) {
                completedForComponents.add(new Pair((Object)location, (Object)eventId));
            }

            public void error(Throwable e) {
                throw new MuleRuntimeException(e);
            }
        }, null);
    }
}

