/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java;

import io.qameta.allure.Issue;
import java.util.Collections;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.api.config.MuleManifest;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.Extension;
import org.mule.runtime.extension.api.annotation.connectivity.ConnectionProviders;
import org.mule.runtime.extension.api.annotation.connectivity.oauth.AuthorizationCode;
import org.mule.runtime.extension.api.annotation.connectivity.oauth.OAuthParameter;
import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeState;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.internal.loader.DefaultExtensionLoadingContext;
import org.mule.runtime.extension.internal.loader.ExtensionModelFactory;
import org.mule.runtime.module.extension.internal.loader.java.validation.JavaOAuthConnectionProviderModelValidator;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.test.module.extension.internal.util.ExtensionDeclarationTestUtils;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;
import org.mule.test.oauth.TestOAuthConnection;

public class JavaOAuthConnectionProviderModelValidatorTestCase
extends AbstractMuleTestCase {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private final JavaOAuthConnectionProviderModelValidator validator = new JavaOAuthConnectionProviderModelValidator();

    @Test
    @Issue(value="W-14180661")
    public void verifyExpressionsNotSupportedInOAuthParameters() {
        this.exception.expect(IllegalModelDefinitionException.class);
        this.exception.expectMessage("is marked as supporting expressions. Expressions are not supported in OAuth parameters");
        Class<OAuthWithParameterSupportingExpressions> extensionClass = OAuthWithParameterSupportingExpressions.class;
        DefaultExtensionLoadingContext ctx = new DefaultExtensionLoadingContext(extensionClass.getClassLoader(), DslResolvingContext.getDefault(Collections.emptySet()));
        ExtensionDeclarationTestUtils.declarerFor(OAuthWithParameterSupportingExpressions.class, MuleManifest.getProductVersion(), (ExtensionLoadingContext)ctx);
        ExtensionModel extensionModel = new ExtensionModelFactory().create((ExtensionLoadingContext)ctx);
        ExtensionsTestUtils.validate(extensionModel, (ExtensionModelValidator)this.validator);
    }

    @AuthorizationCode(accessTokenUrl="tokenUrl", authorizationUrl="authorizationUrl", defaultScopes="defaultScope")
    private static class OAuthConnectionProviderWithParameterSupportingExpressions
    implements ConnectionProvider<TestOAuthConnection> {
        private AuthorizationCodeState oauthState;
        @Expression(value=ExpressionSupport.SUPPORTED)
        @OAuthParameter
        private String state;

        public TestOAuthConnection connect() throws ConnectionException {
            return null;
        }

        public void disconnect(TestOAuthConnection connection) {
        }

        public ConnectionValidationResult validate(TestOAuthConnection connection) {
            return null;
        }
    }

    @Extension(name="OAuth extension with parameter supporting expressions")
    @ConnectionProviders(value={OAuthConnectionProviderWithParameterSupportingExpressions.class})
    public static class OAuthWithParameterSupportingExpressions {
    }
}

