/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java.type.runtime;

import io.qameta.allure.Description;
import io.qameta.allure.Issue;
import java.lang.reflect.Field;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.runtime.extension.api.annotation.Extension;
import org.mule.runtime.extension.api.annotation.deprecated.Deprecated;
import org.mule.runtime.extension.api.declaration.type.DefaultExtensionsTypeLoaderFactory;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.api.loader.java.type.FieldElement;
import org.mule.runtime.module.extension.api.loader.java.type.MethodElement;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.api.loader.java.type.WithParameters;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.TypeWrapper;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.sdk.api.annotation.Alias;
import org.mule.sdk.api.annotation.param.Optional;
import org.mule.sdk.api.annotation.semantics.security.Password;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class TypeWrapperTestCase
extends AbstractMuleTestCase {
    @Test
    public void enumParameterType() {
        TypeWrapper type = new TypeWrapper(TestEnum.class, new DefaultExtensionsTypeLoaderFactory().createTypeLoader(Thread.currentThread().getContextClassLoader()));
        for (ExtensionParameter parameter : type.getMethod("compareTo", new Class[]{Enum.class}).map(WithParameters::getParameters).get()) {
            MatcherAssert.assertThat((Object)parameter.getType().getTypeName(), (Matcher)CoreMatchers.is((Object)"java.lang.Enum"));
        }
    }

    @Test
    public void recursiveParameterType() {
        TypeWrapper type = new TypeWrapper(SomeClass.class, new DefaultExtensionsTypeLoaderFactory().createTypeLoader(Thread.currentThread().getContextClassLoader()));
        for (ExtensionParameter parameter : type.getMethod("someMethod", new Class[]{SomeClass.class}).map(WithParameters::getParameters).get()) {
            MatcherAssert.assertThat((Object)parameter.getType().getTypeName(), (Matcher)CoreMatchers.is((Object)"org.mule.runtime.module.extension.internal.loader.java.type.runtime.TypeWrapperTestCase$SomeClass"));
        }
    }

    @Test
    @Issue(value="W-12622240")
    @Description(value="Ensure JDK internal fields are filtered out as we can't use reflection on them in Java 17 and above")
    public void filterInternalJdkFields() {
        TypeWrapper type = new TypeWrapper(LocalDateTime.class, new DefaultExtensionsTypeLoaderFactory().createTypeLoader(Thread.currentThread().getContextClassLoader()));
        List fields = type.getFields();
        MatcherAssert.assertThat((Object)fields, (Matcher)Matchers.empty());
    }

    @Test
    @Issue(value="W-13648907")
    @Description(value="Ensure synthetic fields are filtered out as they might be added to classes we can't use reflection on in Java 17 and above")
    public void filterSyntheticFields() {
        Collection allFiledNames = IntrospectionUtils.getFields(SomeClass.class).stream().filter(Field::isSynthetic).collect(Collectors.toSet());
        MatcherAssert.assertThat((Object)allFiledNames, (Matcher)Matchers.not((Matcher)Matchers.empty()));
        TypeWrapper type = new TypeWrapper(SomeClass.class, new DefaultExtensionsTypeLoaderFactory().createTypeLoader(Thread.currentThread().getContextClassLoader()));
        List fields = type.getFields();
        MatcherAssert.assertThat((Object)fields, (Matcher)Matchers.empty());
    }

    @Test
    @Issue(value="W-13759844")
    @Description(value="Ensure fields in enums are filtered out as they might be added to classes we can't use reflection on in Java 17 and above")
    public void filterFieldsFromEnums() {
        Collection allFiledNames = IntrospectionUtils.getFields(TestEnum.class).stream().collect(Collectors.toSet());
        MatcherAssert.assertThat((Object)allFiledNames, (Matcher)Matchers.not((Matcher)Matchers.empty()));
        TypeWrapper type = new TypeWrapper(TestEnum.class, new DefaultExtensionsTypeLoaderFactory().createTypeLoader(Thread.currentThread().getContextClassLoader()));
        List fields = type.getFields();
        MatcherAssert.assertThat((Object)fields, (Matcher)Matchers.empty());
    }

    @Test
    public void getAnnotations() {
        TypeWrapper type = new TypeWrapper(SomeClass.class, new DefaultExtensionsTypeLoaderFactory().createTypeLoader(Thread.currentThread().getContextClassLoader()));
        MatcherAssert.assertThat((Object)type.getAnnotations().count(), (Matcher)CoreMatchers.is((Object)2L));
        MatcherAssert.assertThat((Object)type.getAnnotations().anyMatch(ann -> ann.getTypeName().equals("org.mule.sdk.api.annotation.Alias")), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)type.getAnnotations().anyMatch(ann -> ann.getTypeName().equals("org.mule.runtime.extension.api.annotation.Extension")), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void getAnnotationsForMethodWrapper() {
        java.util.Optional<MethodElement> method = new TypeWrapper(ChildTestClass.class, new DefaultExtensionsTypeLoaderFactory().createTypeLoader(Thread.currentThread().getContextClassLoader())).getEnclosingMethods().filter(m -> m.getName().contains("childMethod")).findAny();
        MatcherAssert.assertThat((Object)method.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)method.get().getAnnotations().count(), (Matcher)CoreMatchers.is((Object)1L));
        MatcherAssert.assertThat((Object)method.get().getAnnotations().anyMatch(ann -> ann.getTypeName().equals("org.mule.runtime.extension.api.annotation.deprecated.Deprecated")), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void getAnnotationsForParameterWrapper() {
        java.util.Optional<MethodElement> method = new TypeWrapper(ChildTestClass.class, new DefaultExtensionsTypeLoaderFactory().createTypeLoader(Thread.currentThread().getContextClassLoader())).getEnclosingMethods().filter(m -> m.getName().contains("childMethod")).findAny();
        MatcherAssert.assertThat((Object)method.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)method.get().getParameters().size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((ExtensionParameter)method.get().getParameters().get(0)).getAnnotations().count(), (Matcher)CoreMatchers.is((Object)1L));
        MatcherAssert.assertThat((Object)((ExtensionParameter)method.get().getParameters().get(0)).getAnnotations().anyMatch(ann -> ann.getTypeName().equals("org.mule.sdk.api.annotation.param.Optional")), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void getAnnotationsForFieldWrapper() {
        java.util.Optional<FieldElement> field = new TypeWrapper(ChildTestClass.class, new DefaultExtensionsTypeLoaderFactory().createTypeLoader(Thread.currentThread().getContextClassLoader())).getFields().stream().filter(f -> f.getName().contains("someField")).findAny();
        MatcherAssert.assertThat((Object)field.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)field.get().getAnnotations().count(), (Matcher)CoreMatchers.is((Object)1L));
        MatcherAssert.assertThat((Object)field.get().getAnnotations().anyMatch(ann -> ann.getTypeName().equals("org.mule.sdk.api.annotation.semantics.security.Password")), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void getEnclosingMethods() {
        TypeWrapper method = new TypeWrapper(ChildTestClass.class, new DefaultExtensionsTypeLoaderFactory().createTypeLoader(Thread.currentThread().getContextClassLoader()));
        MatcherAssert.assertThat((Object)method.getEnclosingMethods().anyMatch(m -> m.getName().contains("childMethod")), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)method.getEnclosingMethods().anyMatch(m -> m.getName().contains("someMethod")), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void getImplementingInterfaces() {
        TypeWrapper type = new TypeWrapper(ChildTestClass.class, new DefaultExtensionsTypeLoaderFactory().createTypeLoader(Thread.currentThread().getContextClassLoader()));
        MatcherAssert.assertThat((Object)type.getImplementingInterfaces().count(), (Matcher)CoreMatchers.is((Object)1L));
        MatcherAssert.assertThat((Object)type.getImplementingInterfaces().anyMatch(i -> i.getTypeName().contains("org.mule.runtime.module.extension.internal.loader.java.type.runtime.TypeWrapperTestCase$TestInterface")), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void isArray() {
        java.util.Optional<FieldElement> field = new TypeWrapper(ChildTestClass.class, new DefaultExtensionsTypeLoaderFactory().createTypeLoader(Thread.currentThread().getContextClassLoader())).getFields().stream().filter(f -> f.getName().contains("arrayOfStrings")).findAny();
        MatcherAssert.assertThat((Object)field.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)field.get().getType().isArray(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((Type)field.get().getType().getArrayComponentType().get()).getTypeName(), (Matcher)CoreMatchers.containsString((String)"String"));
    }

    @Test
    public void listIsNotArray() {
        java.util.Optional<FieldElement> field = new TypeWrapper(ChildTestClass.class, new DefaultExtensionsTypeLoaderFactory().createTypeLoader(Thread.currentThread().getContextClassLoader())).getFields().stream().filter(f -> f.getName().contains("listOfStrings")).findAny();
        MatcherAssert.assertThat((Object)field.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)field.get().getType().isArray(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)field.get().getType().getArrayComponentType().isPresent(), (Matcher)CoreMatchers.is((Object)false));
    }

    public static enum TestEnum {
        SOME_VALUE("some"),
        ANOTHER_VALUE("another");

        private final String value;

        private TestEnum(String value) {
            this.value = value;
        }
    }

    private class ChildTestClass
    extends SomeClass
    implements TestInterface {
        @Password
        String someField;
        String[] arrayOfStrings;
        List<Boolean> listOfStrings;

        private ChildTestClass() {
        }

        @Deprecated(message="No longer supported", since="4.4")
        public void childMethod(@Optional String optionalParameter) {
        }
    }

    private static interface TestInterface {
    }

    @Alias(value="Some Class Alias")
    @Extension(name="Some Extension")
    public class SomeClass<T extends SomeClass> {
        public void someMethod(T someParameter) {
        }
    }
}

