/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import com.google.common.base.Predicate;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.BaseDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.module.extension.internal.loader.java.enricher.RefNameDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.RequireNameField;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.reflections.ReflectionUtils;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class RefNameDeclarationEnricherTestCase
extends AbstractMuleTestCase {
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExtensionLoadingContext extensionLoadingContext;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExtensionDeclarer extensionDeclarer;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExtensionDeclaration extensionDeclaration;
    @Mock
    private ConfigurationDeclaration configurationDeclaration;
    @Mock
    private ConnectionProviderDeclaration connectionProviderDeclaration;
    private Field configNameField;
    private Field providerNameField;
    private final RefNameDeclarationEnricher enricher = new RefNameDeclarationEnricher();

    @Before
    public void before() throws Exception {
        Mockito.when((Object)this.extensionLoadingContext.getExtensionDeclarer()).thenReturn((Object)this.extensionDeclarer);
        Mockito.when((Object)((ExtensionDeclaration)this.extensionDeclarer.getDeclaration())).thenReturn((Object)this.extensionDeclaration);
        Mockito.when((Object)this.extensionDeclaration.getConfigurations()).thenReturn(Arrays.asList(this.configurationDeclaration));
        Mockito.when((Object)this.extensionDeclaration.getConnectionProviders()).thenReturn(Arrays.asList(this.connectionProviderDeclaration));
        this.mockImplementingProperty((BaseDeclaration)this.configurationDeclaration, TestNameAwareConfig.class);
        this.mockImplementingProperty((BaseDeclaration)this.connectionProviderDeclaration, TestNameAwareConnectionProvider.class);
        this.configNameField = (Field)ReflectionUtils.getAllFields(TestNameAwareConfig.class, (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(RefName.class)}).iterator().next();
        this.providerNameField = (Field)ReflectionUtils.getAllFields(TestNameAwareConnectionProvider.class, (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(RefName.class)}).iterator().next();
    }

    @Test
    public void addModelProperty() throws Exception {
        this.enricher.enrich(this.extensionLoadingContext);
        this.assertModelPropertyAdded((BaseDeclaration)this.configurationDeclaration, this.configNameField);
    }

    @Test
    public void addModelPropertyOnConnectionProvider() {
        this.enricher.enrich(this.extensionLoadingContext);
        this.assertModelPropertyAdded((BaseDeclaration)this.connectionProviderDeclaration, this.providerNameField);
    }

    private void assertModelPropertyAdded(BaseDeclaration declaration, Field injectionField) {
        ArgumentCaptor captor = ArgumentCaptor.forClass(RequireNameField.class);
        ((BaseDeclaration)Mockito.verify((Object)declaration)).addModelProperty((ModelProperty)captor.capture());
        RequireNameField property = (RequireNameField)captor.getValue();
        Assert.assertThat((Object)property, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)property.getField(), (Matcher)CoreMatchers.equalTo((Object)injectionField));
    }

    @Test
    public void configWithoutImplementingProperty() throws Exception {
        this.mockImplementingProperty((BaseDeclaration)this.configurationDeclaration, null);
        this.enricher.enrich(this.extensionLoadingContext);
    }

    private void mockImplementingProperty(BaseDeclaration declaration, Class<?> type) {
        ImplementingTypeModelProperty property = type != null ? new ImplementingTypeModelProperty(type) : null;
        Mockito.when((Object)declaration.getModelProperty(ImplementingTypeModelProperty.class)).thenReturn(Optional.ofNullable(property));
    }

    public static class TestNameAwareConnectionProvider
    implements ConnectionProvider<Object> {
        @RefName
        private String name;

        public Object connect() throws ConnectionException {
            return new Object();
        }

        public void disconnect(Object o) {
        }

        public ConnectionValidationResult validate(Object o) {
            return ConnectionValidationResult.success();
        }

        public String getName() {
            return this.name;
        }
    }

    public static class TestNameAwareConfig {
        @RefName
        private String name;

        public String getName() {
            return this.name;
        }
    }
}

