/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.lifecycle;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsSame;
import org.junit.After;
import org.junit.Test;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.util.CompositeClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.api.classloader.LookupStrategy;
import org.mule.runtime.module.artifact.api.classloader.MuleArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ParentFirstLookupStrategy;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.extension.internal.lifecycle.DefaultArtifactDisposalContext;
import org.mule.sdk.api.artifact.lifecycle.ArtifactDisposalContext;
import org.mule.tck.junit4.AbstractMuleTestCase;

@Feature(value="Java SDK")
@Story(value="Listeners for Artifact lifecycle events")
public class DefaultArtifactDisposalContextTestCase
extends AbstractMuleTestCase {
    private final ArtifactClassLoader artifactClassLoader = new TestArtifactClassLoader("artifactId");
    private final ArtifactClassLoader extensionClassLoader = new TestArtifactClassLoader("extensionId");
    private final ArtifactClassLoader unrelatedArtifactClassLoader = new TestArtifactClassLoader("someOtherArtifactId");
    private final ArtifactDisposalContext artifactDisposalContext = new DefaultArtifactDisposalContext(this.artifactClassLoader, this.extensionClassLoader);
    private final List<AwaitingThread> awaitingThreads = new ArrayList<AwaitingThread>();

    @After
    public void tearDown() throws InterruptedException {
        for (AwaitingThread awaitingThread : this.awaitingThreads) {
            awaitingThread.stopGracefully();
            awaitingThread.join();
        }
        this.artifactClassLoader.dispose();
        this.extensionClassLoader.dispose();
        this.unrelatedArtifactClassLoader.dispose();
    }

    @Test
    public void directClassLoaders() {
        MatcherAssert.assertThat((Object)this.artifactDisposalContext.getArtifactClassLoader(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.artifactClassLoader)));
        MatcherAssert.assertThat((Object)this.artifactDisposalContext.getExtensionClassLoader(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.extensionClassLoader)));
        this.assertArtifactOwnedClassLoader(this.artifactClassLoader.getClassLoader());
        this.assertExtensionOwnedClassLoader(this.extensionClassLoader.getClassLoader());
    }

    @Test
    public void childClassLoaders() throws IOException {
        this.assertArtifactChildClassLoaders(this.artifactClassLoader);
        this.assertExtensionChildClassLoaders(this.extensionClassLoader);
    }

    @Test
    public void sameArtifactIdClassLoaders() throws IOException {
        try (TestArtifactClassLoader childClassLoader = new TestArtifactClassLoader(this.artifactClassLoader.getArtifactId(), ((Object)((Object)this)).getClass().getClassLoader());){
            this.assertNotOwnedClassLoader(childClassLoader.getClassLoader());
            this.assertChildClassLoaders((ArtifactClassLoader)childClassLoader, this::assertNotOwnedClassLoader);
        }
        childClassLoader = new TestArtifactClassLoader(this.extensionClassLoader.getArtifactId(), ((Object)((Object)this)).getClass().getClassLoader());
        try {
            this.assertNotOwnedClassLoader(childClassLoader.getClassLoader());
            this.assertChildClassLoaders((ArtifactClassLoader)childClassLoader, this::assertNotOwnedClassLoader);
        }
        finally {
            childClassLoader.close();
        }
    }

    @Test
    public void compositeClassLoaders() throws IOException {
        CompositeClassLoader compositeClassLoader = CompositeClassLoader.from((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (ClassLoader)this.artifactClassLoader.getClassLoader());
        this.assertArtifactOwnedClassLoader((ClassLoader)compositeClassLoader);
        this.assertArtifactChildClassLoaders((ClassLoader)compositeClassLoader);
        compositeClassLoader = CompositeClassLoader.from((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (ClassLoader)this.extensionClassLoader.getClassLoader());
        this.assertExtensionOwnedClassLoader((ClassLoader)compositeClassLoader);
        this.assertExtensionChildClassLoaders((ClassLoader)compositeClassLoader);
    }

    @Test
    public void unrelatedClassLoaders() {
        MatcherAssert.assertThat((Object)this.artifactDisposalContext.isArtifactOwnedClassLoader(this.unrelatedArtifactClassLoader.getClassLoader()), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)this.artifactDisposalContext.isExtensionOwnedClassLoader(this.unrelatedArtifactClassLoader.getClassLoader()), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)this.artifactDisposalContext.isArtifactOwnedClassLoader(((Object)((Object)this)).getClass().getClassLoader()), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)this.artifactDisposalContext.isExtensionOwnedClassLoader(((Object)((Object)this)).getClass().getClassLoader()), (Matcher)Is.is((Object)false));
        CompositeClassLoader compositeClassLoader = CompositeClassLoader.from((ClassLoader[])new ClassLoader[]{((Object)((Object)this)).getClass().getClassLoader()});
        MatcherAssert.assertThat((Object)this.artifactDisposalContext.isArtifactOwnedClassLoader((ClassLoader)compositeClassLoader), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)this.artifactDisposalContext.isExtensionOwnedClassLoader((ClassLoader)compositeClassLoader), (Matcher)Is.is((Object)false));
    }

    @Test
    public void whenNoOwnedThreadsThenReturnsEmptyStream() {
        MatcherAssert.assertThat((Object)Thread.activeCount(), (Matcher)Is.is((Matcher)IsNot.not((Object)0)));
        MatcherAssert.assertThat((String)"Expected no threads owned by the artifact", (Object)this.artifactDisposalContext.getArtifactOwnedThreads().count(), (Matcher)Is.is((Object)0L));
        MatcherAssert.assertThat((String)"Expected no threads owned by the extension", (Object)this.artifactDisposalContext.getExtensionOwnedThreads().count(), (Matcher)Is.is((Object)0L));
    }

    @Test
    public void whenOwnedThreadsByDifferentArtifactThenReturnsEmptyStream() {
        this.startThreadWithClassLoader(this.unrelatedArtifactClassLoader);
        MatcherAssert.assertThat((Object)Thread.activeCount(), (Matcher)Is.is((Matcher)IsNot.not((Object)0)));
        MatcherAssert.assertThat((String)"Expected no threads owned by the artifact", (Object)this.artifactDisposalContext.getArtifactOwnedThreads().count(), (Matcher)Is.is((Object)0L));
        MatcherAssert.assertThat((String)"Expected no threads owned by the extension", (Object)this.artifactDisposalContext.getExtensionOwnedThreads().count(), (Matcher)Is.is((Object)0L));
    }

    @Test
    public void whenArtifactHasActiveThreadThenItIsReturned() {
        Thread thread = this.startThreadWithClassLoader(this.artifactClassLoader);
        this.assertArtifactOwnedThreads(thread);
        MatcherAssert.assertThat((String)"Expected no threads owned by the extension", (Object)this.artifactDisposalContext.getExtensionOwnedThreads().count(), (Matcher)Is.is((Object)0L));
    }

    @Test
    public void whenExtensionHasActiveThreadThenItIsReturned() {
        Thread thread = this.startThreadWithClassLoader(this.extensionClassLoader);
        this.assertExtensionOwnedThreads(thread);
        MatcherAssert.assertThat((String)"Expected no threads owned by the artifact", (Object)this.artifactDisposalContext.getArtifactOwnedThreads().count(), (Matcher)Is.is((Object)0L));
    }

    @Test
    public void whenArtifactAndExtensionHaveActiveThreadsThenTheyAreReturned() {
        Thread artifactThread = this.startThreadWithClassLoader(this.artifactClassLoader);
        Thread extensionThread = this.startThreadWithClassLoader(this.extensionClassLoader);
        this.assertArtifactOwnedThreads(artifactThread);
        this.assertExtensionOwnedThreads(extensionThread);
    }

    @Test
    public void whenOwnedThreadsAreInChildThreadGroupThenTheyAreReturned() {
        ThreadGroup threadGroup = new ThreadGroup("Test Thread Group");
        Thread artifactThread = this.startThreadWithClassLoader(this.artifactClassLoader, threadGroup);
        Thread extensionThread = this.startThreadWithClassLoader(this.extensionClassLoader, threadGroup);
        this.assertArtifactOwnedThreads(artifactThread);
        this.assertExtensionOwnedThreads(extensionThread);
    }

    @Test
    public void whenOwnedThreadsAreInSiblingThreadGroupThenTheyAreReturned() {
        ThreadGroup threadGroup = new ThreadGroup(Thread.currentThread().getThreadGroup().getParent(), "Test Thread Group");
        Thread artifactThread = this.startThreadWithClassLoader(this.artifactClassLoader, threadGroup);
        Thread extensionThread = this.startThreadWithClassLoader(this.extensionClassLoader, threadGroup);
        this.assertArtifactOwnedThreads(artifactThread);
        this.assertExtensionOwnedThreads(extensionThread);
    }

    private void assertArtifactChildClassLoaders(ArtifactClassLoader someArtifactClassLoader) throws IOException {
        this.assertChildClassLoaders(someArtifactClassLoader, this::assertArtifactOwnedClassLoader);
    }

    private void assertExtensionChildClassLoaders(ArtifactClassLoader someArtifactClassLoader) throws IOException {
        this.assertChildClassLoaders(someArtifactClassLoader, this::assertExtensionOwnedClassLoader);
    }

    private void assertArtifactChildClassLoaders(ClassLoader someClassLoader) throws IOException {
        this.assertChildClassLoaders(someClassLoader, this::assertArtifactOwnedClassLoader);
    }

    private void assertExtensionChildClassLoaders(ClassLoader someClassLoader) throws IOException {
        this.assertChildClassLoaders(someClassLoader, this::assertExtensionOwnedClassLoader);
    }

    private void assertChildClassLoaders(ArtifactClassLoader someArtifactClassLoader, Consumer<ClassLoader> classLoaderAsserter) throws IOException {
        try (TestArtifactClassLoader childClassLoader = new TestArtifactClassLoader(someArtifactClassLoader.getArtifactId(), someArtifactClassLoader.getClassLoader());){
            classLoaderAsserter.accept((ClassLoader)((Object)childClassLoader));
        }
        this.assertChildClassLoaders(someArtifactClassLoader.getClassLoader(), classLoaderAsserter);
    }

    private void assertChildClassLoaders(ClassLoader someClassLoader, Consumer<ClassLoader> classLoaderAsserter) throws IOException {
        try (Object childClassLoader = new URLClassLoader(new URL[0], someClassLoader);){
            classLoaderAsserter.accept((ClassLoader)childClassLoader);
        }
        childClassLoader = new TestArtifactClassLoader("Child Artifact", someClassLoader);
        try {
            classLoaderAsserter.accept((ClassLoader)childClassLoader);
        }
        finally {
            childClassLoader.close();
        }
    }

    private void assertArtifactOwnedClassLoader(ClassLoader classLoader) {
        MatcherAssert.assertThat((Object)this.artifactDisposalContext.isArtifactOwnedClassLoader(classLoader), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)this.artifactDisposalContext.isExtensionOwnedClassLoader(classLoader), (Matcher)Is.is((Object)false));
    }

    private void assertExtensionOwnedClassLoader(ClassLoader classLoader) {
        MatcherAssert.assertThat((Object)this.artifactDisposalContext.isArtifactOwnedClassLoader(classLoader), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)this.artifactDisposalContext.isExtensionOwnedClassLoader(classLoader), (Matcher)Is.is((Object)true));
    }

    private void assertNotOwnedClassLoader(ClassLoader classLoader) {
        MatcherAssert.assertThat((Object)this.artifactDisposalContext.isArtifactOwnedClassLoader(classLoader), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)this.artifactDisposalContext.isExtensionOwnedClassLoader(classLoader), (Matcher)Is.is((Object)false));
    }

    private Thread startThreadWithClassLoader(ArtifactClassLoader artifactClassLoader) {
        Thread thread = (Thread)ClassUtils.withContextClassLoader((ClassLoader)artifactClassLoader.getClassLoader(), () -> new AwaitingThread());
        thread.start();
        return thread;
    }

    private Thread startThreadWithClassLoader(ArtifactClassLoader artifactClassLoader, ThreadGroup threadGroup) {
        Thread thread = (Thread)ClassUtils.withContextClassLoader((ClassLoader)artifactClassLoader.getClassLoader(), () -> new AwaitingThread(threadGroup));
        thread.start();
        return thread;
    }

    private void assertArtifactOwnedThreads(Thread ... threads) {
        List artifactOwnedThreads = this.artifactDisposalContext.getArtifactOwnedThreads().collect(Collectors.toList());
        MatcherAssert.assertThat(artifactOwnedThreads, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])threads));
        for (Thread thread : threads) {
            MatcherAssert.assertThat((Object)this.artifactDisposalContext.isArtifactOwnedThread(thread), (Matcher)Is.is((Object)true));
            MatcherAssert.assertThat((Object)this.artifactDisposalContext.isExtensionOwnedThread(thread), (Matcher)Is.is((Object)false));
        }
        MatcherAssert.assertThat(artifactOwnedThreads, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])this.getArtifactOwnedThreadsFromStackTraces()));
    }

    private void assertExtensionOwnedThreads(Thread ... threads) {
        List extensionOwnedThreads = this.artifactDisposalContext.getExtensionOwnedThreads().collect(Collectors.toList());
        MatcherAssert.assertThat(extensionOwnedThreads, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])threads));
        for (Thread thread : threads) {
            MatcherAssert.assertThat((Object)this.artifactDisposalContext.isArtifactOwnedThread(thread), (Matcher)Is.is((Object)false));
            MatcherAssert.assertThat((Object)this.artifactDisposalContext.isExtensionOwnedThread(thread), (Matcher)Is.is((Object)true));
        }
        MatcherAssert.assertThat(extensionOwnedThreads, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])this.getExtensionOwnedThreadsFromStackTraces()));
    }

    private Thread[] getArtifactOwnedThreadsFromStackTraces() {
        return (Thread[])Thread.getAllStackTraces().keySet().stream().filter(arg_0 -> ((ArtifactDisposalContext)this.artifactDisposalContext).isArtifactOwnedThread(arg_0)).toArray(Thread[]::new);
    }

    private Thread[] getExtensionOwnedThreadsFromStackTraces() {
        return (Thread[])Thread.getAllStackTraces().keySet().stream().filter(arg_0 -> ((ArtifactDisposalContext)this.artifactDisposalContext).isExtensionOwnedThread(arg_0)).toArray(Thread[]::new);
    }

    private class AwaitingThread
    extends Thread {
        private boolean stopRequested;

        public AwaitingThread() {
            this(null);
        }

        public AwaitingThread(ThreadGroup threadGroup) {
            super(threadGroup, "OwnedThread");
            this.stopRequested = false;
            DefaultArtifactDisposalContextTestCase.this.awaitingThreads.add(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AwaitingThread awaitingThread = this;
            synchronized (awaitingThread) {
                while (!this.stopRequested) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        public synchronized void stopGracefully() {
            this.stopRequested = true;
            this.notify();
        }
    }

    private static class ParentFirstLookupPolicy
    implements ClassLoaderLookupPolicy {
        private ParentFirstLookupPolicy() {
        }

        public LookupStrategy getClassLookupStrategy(String className) {
            return ParentFirstLookupStrategy.PARENT_FIRST;
        }

        public LookupStrategy getPackageLookupStrategy(String packageName) {
            return ParentFirstLookupStrategy.PARENT_FIRST;
        }

        public ClassLoaderLookupPolicy extend(Map<String, LookupStrategy> lookupStrategies) {
            return null;
        }

        public ClassLoaderLookupPolicy extend(Stream<String> packages, LookupStrategy lookupStrategy) {
            return null;
        }

        public ClassLoaderLookupPolicy extend(Map<String, LookupStrategy> lookupStrategies, boolean overwrite) {
            return null;
        }

        public ClassLoaderLookupPolicy extend(Stream<String> packages, LookupStrategy lookupStrategy, boolean overwrite) {
            return null;
        }
    }

    private static class TestArtifactClassLoader
    extends MuleArtifactClassLoader {
        public TestArtifactClassLoader(String artifactId) {
            this(artifactId, DefaultArtifactDisposalContextTestCase.class.getClassLoader());
        }

        public TestArtifactClassLoader(String artifactId, ClassLoader parent) {
            super(artifactId, new ArtifactDescriptor(artifactId), new URL[0], parent, (ClassLoaderLookupPolicy)new ParentFirstLookupPolicy());
        }
    }
}

