/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.core.api.retry.policy.NoRetryPolicyTemplate;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.internal.connection.ConnectionManagerAdapter;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.module.extension.internal.runtime.operation.retry.ComponentRetryPolicyTemplateResolver;
import org.mule.tck.junit4.AbstractMuleTestCase;

@Feature(value="Reconnection Policies")
@Story(value="Blocking")
public class ComponentRetryPolicyTemplateResolverTestCase
extends AbstractMuleTestCase {
    @Rule
    public MockitoRule rule = MockitoJUnit.rule();
    @Mock
    RetryPolicyTemplate retryPolicyTemplate;
    @Mock
    ConnectionManagerAdapter connectionManager;
    @Mock
    ConfigurationInstance configWithConnection;
    @Mock
    ConfigurationInstance configWithoutConnection;
    @Mock
    ConnectionProvider connectionProvider;
    @Mock
    RetryPolicyTemplate configRetryTemplate;

    @Before
    public void before() {
        Mockito.when((Object)this.configWithConnection.getConnectionProvider()).thenReturn(Optional.of(this.connectionProvider));
        Mockito.when((Object)this.configWithoutConnection.getConnectionProvider()).thenReturn(Optional.empty());
        Mockito.when((Object)this.connectionManager.getRetryTemplateFor(this.connectionProvider)).thenReturn((Object)this.configRetryTemplate);
    }

    @Test
    @Description(value="The retry policy template set for a component is fetched if available.")
    public void whenRetryPolicyTemplateAvailableForComponentRetryPolicyTemplateIsFetched() {
        ComponentRetryPolicyTemplateResolver resolver = new ComponentRetryPolicyTemplateResolver(this.retryPolicyTemplate, this.connectionManager);
        Assert.assertThat((Object)resolver.fetchRetryPolicyTemplate(Optional.of(this.configWithConnection)), (Matcher)CoreMatchers.sameInstance((Object)this.retryPolicyTemplate));
    }

    @Test
    @Description(value="If the retry policy template is not available, retry policy template from connection provider is fetched.")
    public void whenRetryPolicyTemplateNotAvaialbleForComponentTheOneFromConnectionIsFetched() {
        ComponentRetryPolicyTemplateResolver resolver = new ComponentRetryPolicyTemplateResolver(null, this.connectionManager);
        Assert.assertThat((Object)resolver.fetchRetryPolicyTemplate(Optional.of(this.configWithConnection)), (Matcher)CoreMatchers.sameInstance((Object)this.configRetryTemplate));
    }

    @Test
    @Description(value="If retry policy template not available, and no connection provider in config, return fallback retry policy template.")
    public void whenRetryPolicyTemplateNotAvaialbleForComponentAndNoConnectionConfigThenFallback() {
        ComponentRetryPolicyTemplateResolver resolver = new ComponentRetryPolicyTemplateResolver(null, this.connectionManager);
        Assert.assertThat((Object)resolver.fetchRetryPolicyTemplate(Optional.of(this.configWithoutConnection)), (Matcher)CoreMatchers.instanceOf(NoRetryPolicyTemplate.class));
    }
}

