/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import io.qameta.allure.Issue;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.model.nested.NestableElementModel;
import org.mule.runtime.api.meta.model.nested.NestedChainModel;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.internal.message.EventInternalContext;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.module.extension.internal.loader.java.property.SdkApiDefinedModelProperty;
import org.mule.runtime.module.extension.internal.runtime.execution.SdkInternalContext;
import org.mule.runtime.module.extension.internal.runtime.operation.InputEventAware;
import org.mule.runtime.module.extension.internal.runtime.resolver.ProcessorChainValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.sdk.api.runtime.route.Chain;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class NestedProcessorValueResolverTestCase
extends AbstractMuleContextTestCase {
    @Rule
    public MockitoRule mockitorule = MockitoJUnit.rule();
    @Mock(lenient=true)
    private MessageProcessorChain messageProcessor;
    @Mock
    private ExpressionManager expressionManager;
    @Mock
    private NestedChainModel chainModel;
    @Mock
    private StreamingManager streamingManager;

    @Before
    public void before() throws Exception {
        CoreEvent testEvent = this.testEvent();
        ((InternalEvent)testEvent).setSdkInternalContext((EventInternalContext)new SdkInternalContext());
        Mockito.when((Object)this.messageProcessor.process((CoreEvent)ArgumentMatchers.any(CoreEvent.class))).thenReturn((Object)testEvent);
        Mockito.when((Object)this.messageProcessor.apply((Publisher)ArgumentMatchers.any(Publisher.class))).thenReturn((Object)Mono.just((Object)testEvent));
    }

    @Test
    public void yieldsNestedProcessor() throws Exception {
        ProcessorChainValueResolver resolver = new ProcessorChainValueResolver((NestableElementModel)this.chainModel, this.messageProcessor, this.streamingManager);
        CoreEvent event = this.testEvent();
        org.mule.runtime.extension.api.runtime.route.Chain nestedProcessor = (org.mule.runtime.extension.api.runtime.route.Chain)resolver.resolve(ValueResolvingContext.builder((CoreEvent)event).withExpressionManager(this.expressionManager).build());
        nestedProcessor.process(result -> {
            Assert.assertThat((Object)result.getOutput(), (Matcher)CoreMatchers.is((Object)"test"));
            ArgumentCaptor captor = ArgumentCaptor.forClass(CoreEvent.class);
            try {
                ((MessageProcessorChain)Mockito.verify((Object)this.messageProcessor)).process((CoreEvent)captor.capture());
            }
            catch (MuleException e) {
                throw new RuntimeException(e);
            }
            CoreEvent capturedEvent = (CoreEvent)captor.getValue();
            Assert.assertThat((Object)capturedEvent, (Matcher)CoreMatchers.is((Object)event));
        }, (e, r) -> Assert.fail((String)e.getMessage()));
    }

    @Test
    public void alwaysGivesDifferentInstances() throws Exception {
        ProcessorChainValueResolver resolver = new ProcessorChainValueResolver((NestableElementModel)this.chainModel, this.messageProcessor, this.streamingManager);
        ValueResolvingContext ctx = ValueResolvingContext.builder((CoreEvent)this.testEvent()).withExpressionManager(this.expressionManager).build();
        org.mule.runtime.extension.api.runtime.route.Chain resolved1 = (org.mule.runtime.extension.api.runtime.route.Chain)resolver.resolve(ctx);
        org.mule.runtime.extension.api.runtime.route.Chain resolved2 = (org.mule.runtime.extension.api.runtime.route.Chain)resolver.resolve(ctx);
        Assert.assertThat((Object)resolved1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)resolved2))));
    }

    @Test
    public void chainIsCalledAsNonBlocking() throws Exception {
        ProcessorChainValueResolver resolver = new ProcessorChainValueResolver((NestableElementModel)this.chainModel, this.messageProcessor, this.streamingManager);
        org.mule.runtime.extension.api.runtime.route.Chain resolve = (org.mule.runtime.extension.api.runtime.route.Chain)resolver.resolve(ValueResolvingContext.builder((CoreEvent)this.testEvent()).withExpressionManager(this.expressionManager).build());
        resolve.process(result -> {}, (t, r) -> {});
        ((MessageProcessorChain)Mockito.verify((Object)this.messageProcessor, (VerificationMode)Mockito.times((int)1))).apply((Publisher)ArgumentMatchers.any());
        ((MessageProcessorChain)Mockito.verify((Object)this.messageProcessor, (VerificationMode)Mockito.times((int)0))).process((CoreEvent)ArgumentMatchers.any());
    }

    @Test
    @Issue(value="W-16420215")
    public void sdkApiChain() throws Exception {
        Mockito.when((Object)this.chainModel.getModelProperty(SdkApiDefinedModelProperty.class)).thenReturn(Optional.of(SdkApiDefinedModelProperty.INSTANCE));
        ProcessorChainValueResolver resolver = new ProcessorChainValueResolver((NestableElementModel)this.chainModel, this.messageProcessor, this.streamingManager);
        CoreEvent event = this.testEvent();
        ValueResolvingContext ctx = ValueResolvingContext.builder((CoreEvent)event).withExpressionManager(this.expressionManager).build();
        Chain chain = (Chain)resolver.resolve(ctx);
        Assert.assertThat((Object)((InputEventAware)chain).getOriginalEvent(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)event)));
        chain.process(result -> {
            Assert.assertThat((Object)result.getOutput(), (Matcher)CoreMatchers.is((Object)"test"));
            ArgumentCaptor captor = ArgumentCaptor.forClass(CoreEvent.class);
            try {
                ((MessageProcessorChain)Mockito.verify((Object)this.messageProcessor)).process((CoreEvent)captor.capture());
            }
            catch (MuleException e) {
                throw new RuntimeException(e);
            }
            CoreEvent capturedEvent = (CoreEvent)captor.getValue();
            Assert.assertThat((Object)capturedEvent, (Matcher)CoreMatchers.is((Object)event));
        }, (e, r) -> Assert.fail((String)e.getMessage()));
    }
}

