/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.notification;

import io.qameta.allure.Description;
import io.qameta.allure.Issue;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.notification.Notification;
import org.mule.runtime.module.extension.internal.runtime.client.NullComponent;
import org.mule.runtime.module.extension.internal.runtime.notification.DefaultExtensionNotification;
import org.mule.sdk.api.notification.NotificationActionDefinition;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class DefaultExtensionNotificationTestCase
extends AbstractMuleTestCase {
    @Test
    @Issue(value="W-16288302")
    @Description(value="When DefaultExtensionNotification calls getAction() with a NullComponent, component.getLocation().getComponentIdentifier() does not throw a NullPointerException and the action is created.")
    public void getActionWhenTheComponentIsANullComponent() {
        TypedValue mockData = (TypedValue)Mockito.mock(TypedValue.class);
        Mockito.when((Object)mockData.getDataType()).thenReturn((Object)TestNotificationActionDefinition.REQUEST_START.getDataType());
        DefaultExtensionNotification notification = new DefaultExtensionNotification(null, (Component)NullComponent.NULL_COMPONENT, (NotificationActionDefinition)TestNotificationActionDefinition.REQUEST_START, mockData);
        Notification.Action action = notification.getAction();
        MatcherAssert.assertThat((Object)action.getNamespace(), (Matcher)Matchers.is((Object)"NULL"));
        MatcherAssert.assertThat((Object)action.getIdentifier(), (Matcher)Matchers.is((Object)"REQUEST_START"));
    }

    public static enum TestNotificationActionDefinition implements NotificationActionDefinition
    {
        REQUEST_START(DataType.fromType(TypedValue.class));

        private final DataType dataType;

        private TestNotificationActionDefinition(DataType dataType) {
            this.dataType = dataType;
        }

        public DataType getDataType() {
            return this.dataType;
        }
    }
}

