/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source;

import java.util.Collections;
import java.util.Map;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.runtime.api.component.execution.CompletableCallback;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.module.extension.internal.runtime.source.ComposedSourceCallbackExecutor;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCallbackExecutor;
import org.mule.sdk.api.runtime.source.SourceCallbackContext;
import org.mule.tck.junit4.AbstractMuleTestCase;

@RunWith(value=MockitoJUnitRunner.class)
public class ComposedSourceCallbackExecutorTestCase
extends AbstractMuleTestCase {
    @Mock
    private SourceCallbackExecutor first;
    @Mock
    private SourceCallbackExecutor then;
    @Mock
    private CoreEvent event;
    @Mock
    private SourceCallbackContext context;
    @Mock
    private CompletableCallback<Void> callback;
    private Map parameters = Collections.emptyMap();
    private ComposedSourceCallbackExecutor executor;

    @Before
    public void before() {
        this.executor = new ComposedSourceCallbackExecutor(this.first, this.then);
    }

    @Test
    public void bothSuccessful() {
        this.mockSuccessful(this.first);
        this.mockSuccessful(this.then);
        this.executor.execute(this.event, this.parameters, this.context, this.callback);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.first, this.then, this.callback});
        ((SourceCallbackExecutor)inOrder.verify((Object)this.first)).execute((CoreEvent)ArgumentMatchers.same((Object)this.event), (Map)ArgumentMatchers.same((Object)this.parameters), (SourceCallbackContext)ArgumentMatchers.same((Object)this.context), (CompletableCallback)ArgumentMatchers.any());
        ((SourceCallbackExecutor)inOrder.verify((Object)this.then)).execute((CoreEvent)ArgumentMatchers.same((Object)this.event), (Map)ArgumentMatchers.same((Object)this.parameters), (SourceCallbackContext)ArgumentMatchers.same((Object)this.context), (CompletableCallback)ArgumentMatchers.any());
        ((CompletableCallback)inOrder.verify(this.callback)).complete(null);
    }

    @Test
    public void firstExecutorFails() {
        Exception e = new Exception();
        this.mockError(this.first, e);
        this.mockSuccessful(this.then);
        this.executor.execute(this.event, this.parameters, this.context, this.callback);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.first, this.then, this.callback});
        ((SourceCallbackExecutor)inOrder.verify((Object)this.first)).execute((CoreEvent)ArgumentMatchers.same((Object)this.event), (Map)ArgumentMatchers.same((Object)this.parameters), (SourceCallbackContext)ArgumentMatchers.same((Object)this.context), (CompletableCallback)ArgumentMatchers.any());
        ((SourceCallbackExecutor)inOrder.verify((Object)this.then)).execute((CoreEvent)ArgumentMatchers.same((Object)this.event), (Map)ArgumentMatchers.same((Object)this.parameters), (SourceCallbackContext)ArgumentMatchers.same((Object)this.context), (CompletableCallback)ArgumentMatchers.any());
        ((CompletableCallback)inOrder.verify(this.callback)).error((Throwable)e);
    }

    @Test
    public void secondExecutorFails() {
        Exception e = new Exception();
        this.mockSuccessful(this.first);
        this.mockError(this.then, e);
        this.executor.execute(this.event, this.parameters, this.context, this.callback);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.first, this.then, this.callback});
        ((SourceCallbackExecutor)inOrder.verify((Object)this.first)).execute((CoreEvent)ArgumentMatchers.same((Object)this.event), (Map)ArgumentMatchers.same((Object)this.parameters), (SourceCallbackContext)ArgumentMatchers.same((Object)this.context), (CompletableCallback)ArgumentMatchers.any());
        ((SourceCallbackExecutor)inOrder.verify((Object)this.then)).execute((CoreEvent)ArgumentMatchers.same((Object)this.event), (Map)ArgumentMatchers.same((Object)this.parameters), (SourceCallbackContext)ArgumentMatchers.same((Object)this.context), (CompletableCallback)ArgumentMatchers.any());
        ((CompletableCallback)inOrder.verify(this.callback)).error((Throwable)e);
    }

    @Test
    public void bothExecutorsFail() {
        Exception e = new Exception();
        Exception e2 = new Exception();
        this.mockError(this.first, e);
        this.mockError(this.then, e2);
        this.executor.execute(this.event, this.parameters, this.context, this.callback);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.first, this.then, this.callback});
        ((SourceCallbackExecutor)inOrder.verify((Object)this.first)).execute((CoreEvent)ArgumentMatchers.same((Object)this.event), (Map)ArgumentMatchers.same((Object)this.parameters), (SourceCallbackContext)ArgumentMatchers.same((Object)this.context), (CompletableCallback)ArgumentMatchers.any());
        ((SourceCallbackExecutor)inOrder.verify((Object)this.then)).execute((CoreEvent)ArgumentMatchers.same((Object)this.event), (Map)ArgumentMatchers.same((Object)this.parameters), (SourceCallbackContext)ArgumentMatchers.same((Object)this.context), (CompletableCallback)ArgumentMatchers.any());
        ((CompletableCallback)inOrder.verify(this.callback)).error((Throwable)e);
    }

    private void mockSuccessful(SourceCallbackExecutor executor) {
        ((SourceCallbackExecutor)Mockito.doAnswer(invocationOnMock -> {
            CompletableCallback completableCallback = (CompletableCallback)invocationOnMock.getArgument(3);
            completableCallback.complete(null);
            return null;
        }).when((Object)executor)).execute((CoreEvent)ArgumentMatchers.same((Object)this.event), (Map)ArgumentMatchers.same((Object)this.parameters), (SourceCallbackContext)ArgumentMatchers.same((Object)this.context), (CompletableCallback)ArgumentMatchers.any());
    }

    private void mockError(SourceCallbackExecutor executor, Throwable t) {
        ((SourceCallbackExecutor)Mockito.doAnswer(invocationOnMock -> {
            CompletableCallback completableCallback = (CompletableCallback)invocationOnMock.getArgument(3);
            completableCallback.error(t);
            return null;
        }).when((Object)executor)).execute((CoreEvent)ArgumentMatchers.same((Object)this.event), (Map)ArgumentMatchers.same((Object)this.parameters), (SourceCallbackContext)ArgumentMatchers.same((Object)this.context), (CompletableCallback)ArgumentMatchers.any());
    }
}

