/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.BaseDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.NamedDeclaration;
import org.mule.runtime.api.meta.model.display.LayoutModel;

class EnricherTestUtils {
    private EnricherTestUtils() {
    }

    public static <T extends NamedDeclaration> T getDeclaration(List<T> operationList, String name) {
        return (T)((NamedDeclaration)operationList.stream().filter(operation -> operation.getName().equals(name)).collect(Collectors.toList()).get(0));
    }

    static <T extends ModelProperty> T checkIsPresent(BaseDeclaration declaration, Class<T> modelProperty) {
        Optional property = declaration.getModelProperty(modelProperty);
        Assert.assertThat((Object)property.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        return (T)((ModelProperty)property.get());
    }

    static void assertLayoutModel(String parameterName, int expectedOrder, Optional<LayoutModel> layoutModel) {
        Assert.assertThat((Object)layoutModel.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        LayoutModel layoutModel1 = layoutModel.get();
        Integer order = layoutModel1.getOrder().orElse(null);
        Assert.assertThat((String)("expecting parameter [" + parameterName + "] at position [" + expectedOrder + "] but was at [" + order + "]"), (Object)order, (Matcher)CoreMatchers.is((Object)expectedOrder));
    }
}

