/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.api.loader.java.type;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.module.extension.api.loader.java.type.AnnotationValueFetcher;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.api.loader.java.type.WithAlias;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.ClassBasedAnnotationValueFetcher;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.TypeWrapper;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

public class WithAliasTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void getAliasFromClassAnnotatedWithSdkAliasAnnotation() {
        WithSdkAliasImpl withAlias = new WithSdkAliasImpl();
        MatcherAssert.assertThat((Object)withAlias.getAlias(), (Matcher)CoreMatchers.is((Object)"SdkAliasAnnotation"));
    }

    @Test
    public void getAliasFromClassAnnotatedWithLegacyAliasAnnotation() {
        WithLegacyAliasImpl withAlias = new WithLegacyAliasImpl();
        MatcherAssert.assertThat((Object)withAlias.getAlias(), (Matcher)CoreMatchers.is((Object)"legacyAliasAnnotation"));
    }

    @Test
    public void getAliasAnnotationFromClassWithLegacyAndSdkAnnotationShouldThrowError() {
        this.expectedException.expect(CoreMatchers.instanceOf(IllegalModelDefinitionException.class));
        this.expectedException.expectMessage("Both org.mule.runtime.extension.api.annotation.Alias and org.mule.sdk.api.annotation.Alias annotations are present on element 'elementTest'");
        WithBothAliasImpl withAlias = new WithBothAliasImpl();
        withAlias.getAlias();
    }

    @org.mule.sdk.api.annotation.Alias(value="SdkAliasAnnotation")
    @Alias(value="legacyAliasAnnotation")
    private static class WithBothAliasImpl
    implements WithAlias {
        private WithBothAliasImpl() {
        }

        public <A extends Annotation> Optional<A> getAnnotation(Class<A> annotationClass) {
            return Optional.ofNullable(this.getClass().getAnnotation(annotationClass));
        }

        public <A extends Annotation> Optional<AnnotationValueFetcher<A>> getValueFromAnnotation(Class<A> annotationClass) {
            return this.isAnnotatedWith(annotationClass) ? Optional.of(new ClassBasedAnnotationValueFetcher(annotationClass, WithBothAliasImpl.class, ExtensionsTestUtils.TYPE_LOADER)) : Optional.empty();
        }

        public boolean isAnnotatedWith(Class<? extends Annotation> annotationClass) {
            return this.getClass().getAnnotation(annotationClass) != null;
        }

        public Stream<Type> getAnnotations() {
            return Arrays.stream(this.getClass().getAnnotations()).map(ann -> new TypeWrapper(ann.annotationType(), ExtensionsTestUtils.TYPE_LOADER));
        }

        public String getName() {
            return "elementTest";
        }
    }

    @Alias(value="legacyAliasAnnotation")
    private static class WithLegacyAliasImpl
    implements WithAlias {
        private WithLegacyAliasImpl() {
        }

        public <A extends Annotation> Optional<A> getAnnotation(Class<A> annotationClass) {
            return Optional.ofNullable(this.getClass().getAnnotation(annotationClass));
        }

        public boolean isAnnotatedWith(Class<? extends Annotation> annotationClass) {
            return this.getClass().getAnnotation(annotationClass) != null;
        }

        public <A extends Annotation> Optional<AnnotationValueFetcher<A>> getValueFromAnnotation(Class<A> annotationClass) {
            return this.isAnnotatedWith(annotationClass) ? Optional.of(new ClassBasedAnnotationValueFetcher(annotationClass, WithLegacyAliasImpl.class, ExtensionsTestUtils.TYPE_LOADER)) : Optional.empty();
        }

        public Stream<Type> getAnnotations() {
            return Arrays.stream(this.getClass().getAnnotations()).map(ann -> new TypeWrapper(ann.annotationType(), ExtensionsTestUtils.TYPE_LOADER));
        }

        public String getName() {
            return "elementTest";
        }
    }

    @org.mule.sdk.api.annotation.Alias(value="SdkAliasAnnotation")
    private static class WithSdkAliasImpl
    implements WithAlias {
        private WithSdkAliasImpl() {
        }

        public <A extends Annotation> Optional<A> getAnnotation(Class<A> annotationClass) {
            return Optional.ofNullable(this.getClass().getAnnotation(annotationClass));
        }

        public boolean isAnnotatedWith(Class<? extends Annotation> annotationClass) {
            return this.getClass().getAnnotation(annotationClass) != null;
        }

        public <A extends Annotation> Optional<AnnotationValueFetcher<A>> getValueFromAnnotation(Class<A> annotationClass) {
            return this.isAnnotatedWith(annotationClass) ? Optional.of(new ClassBasedAnnotationValueFetcher(annotationClass, WithSdkAliasImpl.class, ExtensionsTestUtils.TYPE_LOADER)) : Optional.empty();
        }

        public Stream<Type> getAnnotations() {
            return Arrays.stream(this.getClass().getAnnotations()).map(ann -> new TypeWrapper(ann.annotationType(), ExtensionsTestUtils.TYPE_LOADER));
        }

        public String getName() {
            return "elementTest";
        }
    }
}

