/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.delegate;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.runtime.api.meta.model.declaration.fluent.BaseDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.NamedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OutputDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceCallbackDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.core.api.config.MuleManifest;
import org.mule.runtime.extension.api.property.ResolverInformation;
import org.mule.runtime.extension.api.property.TypeResolversInformationModelProperty;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.message.StringAttributes;
import org.mule.test.metadata.extension.MetadataExtension;
import org.mule.test.metadata.extension.resolver.TestInputResolver;
import org.mule.test.metadata.extension.resolver.TestMetadataInputCarResolver;
import org.mule.test.metadata.extension.resolver.TestMetadataInputHouseResolver;
import org.mule.test.metadata.extension.resolver.TestMetadataInputPersonResolver;
import org.mule.test.module.extension.internal.util.ExtensionDeclarationTestUtils;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

public class SourceModelLoaderDelegateTestCase
extends AbstractMuleTestCase {
    private ExtensionDeclaration declaration;

    @Before
    public void setUp() {
        ExtensionDeclarer declarer = ExtensionDeclarationTestUtils.declarerFor(MetadataExtension.class, MuleManifest.getProductVersion());
        this.declaration = (ExtensionDeclaration)declarer.getDeclaration();
    }

    @Test
    public void declareStaticAndDynamicTypesInSource() {
        List messageSources = ((ConfigurationDeclaration)this.declaration.getConfigurations().get(0)).getMessageSources();
        SourceDeclaration sourceDynamicAttributes = (SourceDeclaration)SourceModelLoaderDelegateTestCase.getDeclaration(messageSources, "MetadataSource");
        this.assertOutputType(sourceDynamicAttributes.getOutput(), (MetadataType)ExtensionsTestUtils.TYPE_BUILDER.objectType().with((TypeAnnotation)new ClassInformationAnnotation(Map.class, Arrays.asList(String.class, Object.class))).openWith(ExtensionsTestUtils.TYPE_LOADER.load(Object.class)).build(), true);
        this.assertOutputType(sourceDynamicAttributes.getOutputAttributes(), ExtensionsTestUtils.toMetadataType(StringAttributes.class), false);
        this.assertParameterType((ParameterDeclaration)SourceModelLoaderDelegateTestCase.getDeclaration(sourceDynamicAttributes.getAllParameters(), "type"), ExtensionsTestUtils.toMetadataType(String.class));
        messageSources = this.declaration.getMessageSources();
        SourceDeclaration sourceStaticAttributes = (SourceDeclaration)SourceModelLoaderDelegateTestCase.getDeclaration(messageSources, "MetadataSourceWithMultilevel");
        this.assertOutputType(sourceStaticAttributes.getOutput(), (MetadataType)ExtensionsTestUtils.TYPE_BUILDER.objectType().with((TypeAnnotation)new ClassInformationAnnotation(Map.class, Arrays.asList(String.class, Object.class))).openWith(ExtensionsTestUtils.TYPE_LOADER.load(Object.class)).build(), true);
        this.assertOutputType(sourceStaticAttributes.getOutputAttributes(), ExtensionsTestUtils.toMetadataType(StringAttributes.class), false);
        List locationKey = sourceStaticAttributes.getAllParameters();
        this.assertParameterType((ParameterDeclaration)SourceModelLoaderDelegateTestCase.getDeclaration(locationKey, "continent"), ExtensionsTestUtils.toMetadataType(String.class));
        this.assertParameterType((ParameterDeclaration)SourceModelLoaderDelegateTestCase.getDeclaration(locationKey, "country"), ExtensionsTestUtils.toMetadataType(String.class));
        this.assertParameterType((ParameterDeclaration)SourceModelLoaderDelegateTestCase.getDeclaration(locationKey, "city"), ExtensionsTestUtils.toMetadataType(String.class));
    }

    @Test
    public void declareDynamicInputTypesInSource() {
        List messageSources = ((ConfigurationDeclaration)this.declaration.getConfigurations().get(0)).getMessageSources();
        SourceDeclaration sourceDeclaration = (SourceDeclaration)SourceModelLoaderDelegateTestCase.getDeclaration(messageSources, "MetadataSourceWithCallbackParameters");
        SourceCallbackDeclaration successSourceCallback = (SourceCallbackDeclaration)sourceDeclaration.getSuccessCallback().get();
        this.assertParamResolverInfo((BaseDeclaration)successSourceCallback, "response", Optional.of(TestMetadataInputPersonResolver.TEST_INPUT_PERSON_RESOLVER));
        this.assertParamResolverInfo((BaseDeclaration)successSourceCallback, "successObject", Optional.of(TestMetadataInputCarResolver.TEST_INPUT_CAR_RESOLVER));
        SourceCallbackDeclaration errorSourceCallback = (SourceCallbackDeclaration)sourceDeclaration.getErrorCallback().get();
        this.assertParamResolverInfo((BaseDeclaration)errorSourceCallback, "response", Optional.of(TestMetadataInputHouseResolver.TEST_INPUT_HOUSE_RESOLVER));
        this.assertParamResolverInfo((BaseDeclaration)errorSourceCallback, "errorObject", Optional.of(TestInputResolver.INPUT_RESOLVER_NAME));
    }

    @Test
    public void declaresTypeResolverInformationForDynamicResolver() throws Exception {
        List messageSources = ((ConfigurationDeclaration)this.declaration.getConfigurations().get(0)).getMessageSources();
        SourceDeclaration sourceDynamicAttributes = (SourceDeclaration)SourceModelLoaderDelegateTestCase.getDeclaration(messageSources, "MetadataSource");
        this.assertCategoryInfo((BaseDeclaration)sourceDynamicAttributes, "MetadataExtensionResolver");
        this.assertOutputResolverInfo((BaseDeclaration)sourceDynamicAttributes, Optional.of("TestInputAndOutputWithAttributesResolverWithKeyResolver"));
        this.assertAttributesResolverInfo((BaseDeclaration)sourceDynamicAttributes, Optional.empty());
        this.assertKeysResolverInfo((BaseDeclaration)sourceDynamicAttributes, Optional.of("TestInputOutputSourceResolverWithKeyResolver"));
    }

    private void assertOutputType(OutputDeclaration output, MetadataType type, boolean isDynamic) {
        MatcherAssert.assertThat((Object)output.getType(), (Matcher)CoreMatchers.equalTo((Object)type));
        MatcherAssert.assertThat((Object)output.hasDynamicType(), (Matcher)CoreMatchers.is((Object)isDynamic));
    }

    private void assertParameterType(ParameterDeclaration param, MetadataType type) {
        MatcherAssert.assertThat((Object)param.getType(), (Matcher)CoreMatchers.equalTo((Object)type));
    }

    private void assertParamResolverInfo(BaseDeclaration declaration, String param, Optional<String> expectedName) {
        this.assertResolverInfo(declaration, info -> info.getParameterResolver(param), "ParameterResolver", expectedName);
    }

    private void assertKeysResolverInfo(BaseDeclaration declaration, Optional<String> expectedName) {
        this.assertResolverInfo(declaration, info -> info.getKeysResolver(), "KeysResolver", expectedName);
    }

    private void assertResolverInfo(BaseDeclaration declaration, Function<TypeResolversInformationModelProperty, Optional<ResolverInformation>> resolverSupplier, String kind, Optional<String> expectedName) {
        TypeResolversInformationModelProperty info = this.getResolversInfo(declaration);
        Optional<ResolverInformation> resolverName = resolverSupplier.apply(info);
        if (expectedName.isPresent() && !resolverName.isPresent()) {
            Assert.fail((String)String.format("Expected %s name to be '%s' but it was not declared in the model. Information was: %s", kind, expectedName, info.toString()));
        } else if (!expectedName.isPresent() && resolverName.isPresent()) {
            Assert.fail((String)String.format("Expected %s name to be empty, but a declaration was found in the model. Information was: %s", kind, info.toString()));
        }
        MatcherAssert.assertThat((String)("Name miss match for the " + kind), resolverName.map(ResolverInformation::getResolverName), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(expectedName)));
    }

    private void assertCategoryInfo(BaseDeclaration declaration, String expectedName) {
        TypeResolversInformationModelProperty info = this.getResolversInfo(declaration);
        MatcherAssert.assertThat((String)"Name miss match for the resolvers category: ", (Object)info.getCategoryName(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)expectedName)));
    }

    private void assertOutputResolverInfo(BaseDeclaration declaration, Optional<String> expectedName) {
        this.assertResolverInfo(declaration, info -> info.getOutputResolver(), "OutputResolver", expectedName);
    }

    private void assertAttributesResolverInfo(BaseDeclaration declaration, Optional<String> expectedName) {
        this.assertResolverInfo(declaration, info -> info.getAttributesResolver(), "AttributesResolver", expectedName);
    }

    private TypeResolversInformationModelProperty getResolversInfo(BaseDeclaration declaration) {
        Optional info = declaration.getModelProperty(TypeResolversInformationModelProperty.class);
        if (!info.isPresent()) {
            Assert.fail((String)("Expected to have information of TypeResolvers but found no model property of class: " + TypeResolversInformationModelProperty.class.getName()));
        }
        return (TypeResolversInformationModelProperty)info.get();
    }

    private static <T extends NamedDeclaration> T getDeclaration(List<T> operationList, String name) {
        return (T)((NamedDeclaration)operationList.stream().filter(operation -> operation.getName().equals(name)).collect(Collectors.toList()).get(0));
    }
}

