/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.util;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.SubTypesModel;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

@RunWith(value=MockitoJUnitRunner.class)
public class IntrospectionUtilsSubtypesTestCase {
    @Mock
    ExtensionModel extensionModel;
    private ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();

    @Test
    public void getClassesFromSubTypeImplementations() {
        ImmutableSet subTypes = ImmutableSet.of((Object)this.typeLoader.load(AA.class), (Object)this.typeLoader.load(AB.class));
        SubTypesModel subTypesModel = new SubTypesModel(this.typeLoader.load(A.class), (Set)subTypes);
        Mockito.when((Object)this.extensionModel.getSubTypes()).thenReturn((Object)ImmutableSet.of((Object)subTypesModel));
        Set subtypeClasses = IntrospectionUtils.getSubtypeClasses((ExtensionModel)this.extensionModel, (ClassLoader)Thread.currentThread().getContextClassLoader());
        MatcherAssert.assertThat((Object)subtypeClasses, (Matcher)IsCollectionContaining.hasItems((Object[])new Class[]{A.class, AA.class, AB.class, SomeEnum.class}));
    }

    public static enum SomeEnum {
        A,
        B,
        C;

    }

    public class AB
    implements A {
        @Parameter
        SomeEnum param;
    }

    public class AA
    implements A {
    }

    public static interface A {
    }
}

