/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.connector.ConnectionManager;
import org.mule.runtime.core.internal.connection.DefaultConnectionManager;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.module.extension.internal.runtime.source.SourceConnectionManager;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class SourceConnectionManagerTestCase
extends AbstractMuleTestCase {
    @Rule
    public MockitoRule rule = MockitoJUnit.rule();
    @Mock
    private ConnectionProvider connectionProvider;
    @Mock
    private ConfigurationInstance configurationInstance;
    @Mock
    private Object configurationObject;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MuleContext muleContext;
    private ConnectionManager connectionManager;
    private SourceConnectionManager sourceConnectionManager;
    private Object connectionA;

    @Before
    public void before() throws ConnectionException {
        Mockito.when((Object)this.configurationInstance.getValue()).thenReturn(this.configurationObject);
        this.connectionManager = new DefaultConnectionManager(this.muleContext);
        this.connectionManager.bind(this.configurationObject, this.connectionProvider);
        this.sourceConnectionManager = new SourceConnectionManager(this.connectionManager);
        this.sourceConnectionManager.getConnection(this.configurationInstance);
        this.connectionA = this.sourceConnectionManager.getConnection(this.configurationInstance);
    }

    @Test
    public void reusedConnectionOnReleaseNotDeletedUntilAllReferencesLost() throws ConnectionException {
        this.sourceConnectionManager.release(this.connectionA);
        MatcherAssert.assertThat((Object)this.sourceConnectionManager.getConnectionHandler(this.connectionA).isPresent(), (Matcher)CoreMatchers.is((Object)true));
        this.sourceConnectionManager.release(this.connectionA);
        MatcherAssert.assertThat((Object)this.sourceConnectionManager.getConnectionHandler(this.connectionA).isPresent(), (Matcher)CoreMatchers.is((Object)false));
        this.sourceConnectionManager.release(this.connectionA);
    }

    @Test
    public void reusedConnectionOnInvalidateNotDeletedUntilAllReferencesLost() throws ConnectionException {
        this.sourceConnectionManager.invalidate(this.connectionA);
        MatcherAssert.assertThat((Object)this.sourceConnectionManager.getConnectionHandler(this.connectionA).isPresent(), (Matcher)CoreMatchers.is((Object)true));
        this.sourceConnectionManager.invalidate(this.connectionA);
        MatcherAssert.assertThat((Object)this.sourceConnectionManager.getConnectionHandler(this.connectionA).isPresent(), (Matcher)CoreMatchers.is((Object)false));
        this.sourceConnectionManager.invalidate(this.connectionA);
    }
}

