/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java;

import java.lang.annotation.Annotation;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.extension.api.annotation.license.RequiresEnterpriseLicense;
import org.mule.runtime.extension.api.annotation.license.RequiresEntitlement;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.exception.IllegalParameterModelDefinitionException;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionElement;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.ClassBasedAnnotationValueFetcher;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaExtensionModelParserUtils;
import org.mule.runtime.module.extension.internal.loader.parser.java.info.RequiresEnterpriseLicenseInfo;
import org.mule.runtime.module.extension.internal.loader.parser.java.info.RequiresEntitlementInfo;

public class ExtensionLicenseJavaUtilsTestCase {
    private static final String ENTITLEMENT_NAME = "Entitlement name";
    private static final String ENTITLEMENT_DESCRIPTION = "Entitlement description";
    private static final boolean ENTREPRISE_LICENSE_ALLOWS_EVALUATION = true;
    private ExtensionElement extensionElementMock = (ExtensionElement)Mockito.mock(ExtensionElement.class);
    private ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setUp() {
        Mockito.reset((Object[])new ExtensionElement[]{this.extensionElementMock});
    }

    @Test
    public void getRequireEnterpriseLicenseInfoFromLegacyAnnotation() {
        this.mockRequiresEnterpriseLicenseSdkAnnotationAbsent();
        this.mockRequiresEnterpriseLicenseAnnotationPresent();
        this.assertRequiresEnterpriseLicenseInfo(JavaExtensionModelParserUtils.getRequiresEnterpriseLicenseInfo((ExtensionElement)this.extensionElementMock));
    }

    @Test
    public void getRequireEnterpriseLicenseInfoFromSdkAnnotation() {
        this.mockRequiresEnterpriseLicenseSdkAnnotationPresent();
        this.mockRequiresEnterpriseLicenseAnnotationAbsent();
        this.assertRequiresEnterpriseLicenseInfo(JavaExtensionModelParserUtils.getRequiresEnterpriseLicenseInfo((ExtensionElement)this.extensionElementMock));
    }

    @Test
    public void getRequireEnterpriseLicenseInfoWhenBothAnnotationsArePresent() {
        this.mockRequiresEnterpriseLicenseAnnotationPresent();
        this.mockRequiresEnterpriseLicenseSdkAnnotationPresent();
        this.expectedException.expect(IllegalParameterModelDefinitionException.class);
        JavaExtensionModelParserUtils.getRequiresEnterpriseLicenseInfo((ExtensionElement)this.extensionElementMock);
    }

    @Test
    public void getRequireEnterpriseLicenseInfoWhenNotPresent() {
        this.mockRequiresEnterpriseLicenseAnnotationAbsent();
        this.mockRequiresEnterpriseLicenseSdkAnnotationAbsent();
        MatcherAssert.assertThat((Object)JavaExtensionModelParserUtils.getRequiresEnterpriseLicenseInfo((ExtensionElement)this.extensionElementMock).isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void getRequiresEntitlementInfoFromLegacyAnnotation() {
        this.mockRequiresEntitlementAnnotationPresent();
        this.mockRequiresEntitlementSdkAnnotationAbsent();
        this.assertRequiresEntitlementInfo(JavaExtensionModelParserUtils.getRequiresEntitlementInfo((ExtensionElement)this.extensionElementMock));
    }

    @Test
    public void getRequiresEntitlementLicenseInfoFromSdkAnnotation() {
        this.mockRequiresEntitlementSdkAnnotationPresent();
        this.mockRequiresEntitlementAnnotationAbsent();
        this.assertRequiresEntitlementInfo(JavaExtensionModelParserUtils.getRequiresEntitlementInfo((ExtensionElement)this.extensionElementMock));
    }

    @Test
    public void getRequiresEntitlementInfoWhenBothAnnotationsArePesent() {
        this.mockRequiresEntitlementAnnotationPresent();
        this.mockRequiresEntitlementSdkAnnotationPresent();
        this.expectedException.expect(IllegalParameterModelDefinitionException.class);
        JavaExtensionModelParserUtils.getRequiresEntitlementInfo((ExtensionElement)this.extensionElementMock);
    }

    @Test
    public void getRequiresEntitlementInfoWhenNotPresent() {
        this.mockRequiresEntitlementSdkAnnotationAbsent();
        this.mockRequiresEntitlementAnnotationAbsent();
        MatcherAssert.assertThat((Object)JavaExtensionModelParserUtils.getRequiresEntitlementInfo((ExtensionElement)this.extensionElementMock).isPresent(), (Matcher)Matchers.is((Object)false));
    }

    private void assertRequiresEnterpriseLicenseInfo(Optional<RequiresEnterpriseLicenseInfo> requiresEnterpriseLicenseInfo) {
        MatcherAssert.assertThat((Object)requiresEnterpriseLicenseInfo.isPresent(), (Matcher)Matchers.is((Object)true));
        RequiresEnterpriseLicenseInfo requiresEnterpriseLicenseInfoObject = requiresEnterpriseLicenseInfo.get();
        MatcherAssert.assertThat((Object)requiresEnterpriseLicenseInfoObject.isAllowEvaluationLicense(), (Matcher)Matchers.is((Object)true));
    }

    private void assertRequiresEntitlementInfo(Optional<RequiresEntitlementInfo> requiresEntitlementInfo) {
        MatcherAssert.assertThat((Object)requiresEntitlementInfo.isPresent(), (Matcher)Matchers.is((Object)true));
        RequiresEntitlementInfo requiresEntitlementInfoObject = requiresEntitlementInfo.get();
        MatcherAssert.assertThat((Object)requiresEntitlementInfoObject.getName(), (Matcher)Matchers.is((Object)ENTITLEMENT_NAME));
        MatcherAssert.assertThat((Object)requiresEntitlementInfoObject.getDescription(), (Matcher)Matchers.is((Object)ENTITLEMENT_DESCRIPTION));
    }

    private void mockRequiresEntitlementAnnotationPresent() {
        Mockito.when((Object)this.extensionElementMock.getValueFromAnnotation(RequiresEntitlement.class)).thenReturn(Optional.of(new ClassBasedAnnotationValueFetcher((Annotation)new RequiresEntitlement(){

            public String name() {
                return ExtensionLicenseJavaUtilsTestCase.ENTITLEMENT_NAME;
            }

            public String description() {
                return ExtensionLicenseJavaUtilsTestCase.ENTITLEMENT_DESCRIPTION;
            }

            public Class<? extends Annotation> annotationType() {
                return RequiresEntitlement.class;
            }
        }, this.typeLoader)));
    }

    private void mockRequiresEntitlementAnnotationAbsent() {
        Mockito.when((Object)this.extensionElementMock.getValueFromAnnotation(RequiresEntitlement.class)).thenReturn(Optional.empty());
    }

    private void mockRequiresEnterpriseLicenseAnnotationPresent() {
        Mockito.when((Object)this.extensionElementMock.getValueFromAnnotation(RequiresEnterpriseLicense.class)).thenReturn(Optional.of(new ClassBasedAnnotationValueFetcher((Annotation)new RequiresEnterpriseLicense(){

            public boolean allowEvaluationLicense() {
                return true;
            }

            public Class<? extends Annotation> annotationType() {
                return RequiresEnterpriseLicense.class;
            }
        }, this.typeLoader)));
    }

    private void mockRequiresEnterpriseLicenseAnnotationAbsent() {
        Mockito.when((Object)this.extensionElementMock.getAnnotation(RequiresEnterpriseLicense.class)).thenReturn(Optional.empty());
    }

    private void mockRequiresEntitlementSdkAnnotationPresent() {
        Mockito.when((Object)this.extensionElementMock.getValueFromAnnotation(org.mule.sdk.api.annotation.license.RequiresEntitlement.class)).thenReturn(Optional.of(new ClassBasedAnnotationValueFetcher((Annotation)new org.mule.sdk.api.annotation.license.RequiresEntitlement(){

            public String name() {
                return ExtensionLicenseJavaUtilsTestCase.ENTITLEMENT_NAME;
            }

            public String description() {
                return ExtensionLicenseJavaUtilsTestCase.ENTITLEMENT_DESCRIPTION;
            }

            public Class<? extends Annotation> annotationType() {
                return org.mule.sdk.api.annotation.license.RequiresEntitlement.class;
            }
        }, this.typeLoader)));
    }

    private void mockRequiresEntitlementSdkAnnotationAbsent() {
        Mockito.when((Object)this.extensionElementMock.getAnnotation(org.mule.sdk.api.annotation.license.RequiresEntitlement.class)).thenReturn(Optional.empty());
    }

    private void mockRequiresEnterpriseLicenseSdkAnnotationPresent() {
        Mockito.when((Object)this.extensionElementMock.getValueFromAnnotation(org.mule.sdk.api.annotation.license.RequiresEnterpriseLicense.class)).thenReturn(Optional.of(new ClassBasedAnnotationValueFetcher((Annotation)new org.mule.sdk.api.annotation.license.RequiresEnterpriseLicense(){

            public boolean allowEvaluationLicense() {
                return true;
            }

            public Class<? extends Annotation> annotationType() {
                return org.mule.sdk.api.annotation.license.RequiresEnterpriseLicense.class;
            }
        }, this.typeLoader)));
    }

    private void mockRequiresEnterpriseLicenseSdkAnnotationAbsent() {
        Mockito.when((Object)this.extensionElementMock.getValueFromAnnotation(org.mule.sdk.api.annotation.license.RequiresEnterpriseLicense.class)).thenReturn(Optional.empty());
    }
}

