/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.Configurations;
import org.mule.runtime.extension.api.annotation.Extension;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.connectivity.ConnectionProviders;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.module.extension.internal.loader.java.validation.PojosModelValidator;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

@SmallTest
public class PojosModelValidatorTestCase
extends AbstractMuleTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private ExtensionModelValidator validator = new PojosModelValidator();

    @Test
    public void pojoConfigurationMustOverrideEqualsAndHashCode() {
        this.expectedException.expect(IllegalModelDefinitionException.class);
        this.expectedException.expectMessage("Type 'InvalidPojoMustOverrideEqualsAndHashCode' must override equals and hashCode");
        this.validate(InvalidTestConnector.class);
    }

    @Test
    public void pojoConnectionProviderMustOverrideEqualsAndHashCode() {
        this.expectedException.expect(IllegalModelDefinitionException.class);
        this.expectedException.expectMessage("Type 'InvalidPojoMustOverrideEqualsAndHashCode' must override equals and hashCode");
        this.validate(InvalidConnectionProviderTestConnector.class);
    }

    @Test
    public void pojoImplementsEqualsAndHashCode() {
        this.validate(ValidTestConnector.class);
    }

    @Test
    public void pojoConfigurationMustHaveDefaultConstructor() {
        this.expectedException.expect(IllegalModelDefinitionException.class);
        this.expectedException.expectMessage("Type 'InvalidPojoRequiresDefaultConstructor' does not have a default constructor");
        this.validate(InvalidConfigParameterTestConnector.class);
    }

    private void validate(Class<?> connectorClass) {
        ExtensionsTestUtils.validate(connectorClass, this.validator, new HashMap(){
            {
                this.put("COMPILATION_MODE", true);
            }
        });
    }

    @Extension(name="validatorTest")
    @Configurations(value={InvalidTestConfigPojoWithoutDefaultConstructor.class})
    @ConnectionProviders(value={TestConnectionProvider.class})
    public static class InvalidConfigParameterTestConnector {
    }

    @Configuration(name="config3")
    @Operations(value={ValidTestOperations.class})
    public static class InvalidTestConfigPojoWithoutDefaultConstructor
    implements Config {
        @Parameter
        private InvalidPojoRequiresDefaultConstructor pojo;
    }

    public static class InvalidPojoRequiresDefaultConstructor {
        @Parameter
        private String bar;
        @Parameter
        private String id;

        public InvalidPojoRequiresDefaultConstructor(String bar, String id) {
            this.bar = bar;
            this.id = id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InvalidPojoRequiresDefaultConstructor that = (InvalidPojoRequiresDefaultConstructor)o;
            return Objects.equals(this.bar, that.bar) && Objects.equals(this.id, that.id);
        }

        public int hashCode() {
            return Objects.hash(this.bar, this.id);
        }
    }

    @Extension(name="validatorTest")
    @Configurations(value={ValidTestConfig.class})
    @ConnectionProviders(value={InvalidTestConnectionProvider.class})
    public static class InvalidConnectionProviderTestConnector {
    }

    @Configuration(name="config2")
    @Operations(value={ValidTestOperations.class})
    public static class ValidTestConfig2
    implements Config {
        @Parameter
        private Dog pojo;
    }

    @Configuration(name="config")
    @Operations(value={ValidTestOperations.class})
    public static class ValidTestConfig
    implements Config {
        @Parameter
        private PojoImplementsEqualsAndHashCode pojo;
        @Parameter
        private Map map;
    }

    @Extension(name="validatorTest")
    @Configurations(value={ValidTestConfig.class, ValidTestConfig2.class})
    @ConnectionProviders(value={TestConnectionProvider.class})
    public static class ValidTestConnector {
    }

    public static class ValidatorTestConnection {
    }

    @Alias(value="provider1")
    public static class InvalidTestConnectionProvider
    implements ConnectionProvider<ValidatorTestConnection> {
        @Parameter
        private InvalidPojoMustOverrideEqualsAndHashCode pojo;

        public ValidatorTestConnection connect() throws ConnectionException {
            return new ValidatorTestConnection();
        }

        public void disconnect(ValidatorTestConnection connection) {
        }

        public ConnectionValidationResult validate(ValidatorTestConnection validatorTestConnection) {
            return ConnectionValidationResult.success();
        }
    }

    @Alias(value="provider1")
    public static class TestConnectionProvider
    implements ConnectionProvider<ValidatorTestConnection> {
        @Parameter
        private Dog pojo;
        @Parameter
        private Map map;

        public ValidatorTestConnection connect() throws ConnectionException {
            return new ValidatorTestConnection();
        }

        public void disconnect(ValidatorTestConnection connection) {
        }

        public ConnectionValidationResult validate(ValidatorTestConnection validatorTestConnection) {
            return ConnectionValidationResult.success();
        }
    }

    public static class ValidTestOperations {
        public void foo(@Connection ValidatorTestConnection connection) {
        }

        public void bar(@Connection ValidatorTestConnection connection) {
        }
    }

    @Configuration(name="config")
    @Operations(value={ValidTestOperations.class})
    public static class InvalidTestConfig
    implements Config {
        @Parameter
        private InvalidPojoMustOverrideEqualsAndHashCode pojo;
    }

    @Extension(name="validatorTest")
    @Configurations(value={InvalidTestConfig.class})
    @ConnectionProviders(value={TestConnectionProvider.class})
    public static class InvalidTestConnector {
    }

    static interface Config {
    }

    public static class Dog
    extends Animal {
    }

    private static class Animal {
        private String name;

        private Animal() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Animal animal = (Animal)o;
            return Objects.equals(this.name, animal.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }
    }

    public static class PojoImplementsEqualsAndHashCode {
        private String id;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PojoImplementsEqualsAndHashCode that = (PojoImplementsEqualsAndHashCode)o;
            return Objects.equals(this.id, that.id);
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }
    }

    private static class InvalidPojoMustOverrideEqualsAndHashCode {
        private String id;

        private InvalidPojoMustOverrideEqualsAndHashCode() {
        }
    }
}

