/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.manager.jdk;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.core.internal.util.JdkVersionUtils;
import org.mule.runtime.module.extension.internal.manager.jdk.BaseExtensionJdkValidatorTestCase;
import org.mule.runtime.module.extension.internal.manager.jdk.ExtensionJdkValidator;
import org.mule.runtime.module.extension.internal.manager.jdk.LooseExtensionJdkValidator;
import org.mule.tck.size.SmallTest;
import org.slf4j.Logger;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
@Feature(value="SDK")
@Story(value="Validate that all registered extensions support the Java version Mule is running on")
public class LooseExtensionJdkValidatorTestCase
extends BaseExtensionJdkValidatorTestCase {
    @Mock
    private Logger logger;

    @Override
    public void before() {
        super.before();
        Mockito.when((Object)this.logger.isWarnEnabled()).thenReturn((Object)true);
    }

    @Override
    protected ExtensionJdkValidator validatorFor(JdkVersionUtils.JdkVersion jdkVersion) {
        return new LooseExtensionJdkValidator(jdkVersion, this.logger);
    }

    @Override
    @Test
    public void supportedJdks() {
        super.supportedJdks();
        ((Logger)Mockito.verify((Object)this.logger, (VerificationMode)Mockito.never())).warn(ArgumentMatchers.anyString());
    }

    @Override
    protected void assertFailure(Runnable task) {
        task.run();
        ArgumentCaptor captor = ArgumentCaptor.forClass(String.class);
        ((Logger)Mockito.verify((Object)this.logger)).warn((String)captor.capture());
        Assert.assertThat((Object)((String)captor.getValue()), (Matcher)Matchers.equalTo((Object)"Extension 'Test Extension' does not support Java 21. Supported versions are: [1.8, 11, 17]"));
    }
}

