/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.resources.manifest;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.OutputModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.test.util.tck.ExtensionModelTestUtils;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.property.ClassLoaderModelProperty;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.module.extension.api.loader.java.type.OperationElement;
import org.mule.runtime.module.extension.internal.loader.java.property.ExportedClassNamesModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingMethodModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionOperationDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.OperationWrapper;
import org.mule.runtime.module.extension.internal.resources.manifest.ExportedPackagesCollector;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.enumeration.FruitConsistency;
import org.mule.test.heisenberg.extension.HeisenbergOperations;
import org.mule.test.metadata.extension.model.shapes.Shape;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;
import org.mule.test.vegan.extension.VeganAttributes;

@RunWith(value=MockitoJUnitRunner.class)
public class ExportedPackagesCollectorTestCase
extends AbstractMuleTestCase {
    private final ClassTypeLoader loader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
    private static final String APPLE_PACKAGE = "org.mule.tck.testmodels.fruit";
    private static final String PEEL_PACKAGE = "org.mule.tck.testmodels.fruit.peel";
    private static final String SEED_PACKAGE = "org.mule.tck.testmodels.fruit.seed";
    private static final String VEGAN_PACKAGE = "org.mule.test.vegan.extension";
    private static final String SHAPE_PACKAGE = "org.mule.test.metadata.extension.model.shapes";
    private static final String EXCEPTION_PACKAGE = "org.mule.test.heisenberg.extension.exception";
    @Mock(lenient=true)
    private ExtensionModel extensionModel;
    private ExportedPackagesCollector collector;

    @Before
    public void setup() {
        ClassLoaderModelProperty classLoaderModelProperty = new ClassLoaderModelProperty(((Object)((Object)this)).getClass().getClassLoader());
        Mockito.when((Object)this.extensionModel.getModelProperty(ClassLoaderModelProperty.class)).thenReturn(Optional.of(classLoaderModelProperty));
        OutputModel appleList = this.mockOutputModel(new TypeToken<List<Apple>>(){}.getType());
        OperationModel firstOperation = this.mockOperationModel(appleList, this.mockOutputModel((Type)((Object)List.class)), new ParameterModel[0]);
        this.withMethod(firstOperation, IntrospectionUtils.getApiMethods(HeisenbergOperations.class).stream().filter(m -> m.getName().equals("callGusFring")).findFirst());
        ParameterModel parameter = this.mockParameterModel((Type)((Object)Shape.class));
        OutputModel resultList = this.mockOutputModel(new TypeToken<List<Result<Apple, VeganAttributes>>>(){}.getType());
        OperationModel secondOperation = this.mockOperationModel(resultList, this.mockOutputModel((Type)((Object)List.class)), parameter);
        this.withMethod(secondOperation, Optional.empty());
        Mockito.when((Object)this.extensionModel.getOperationModels()).thenReturn(Arrays.asList(firstOperation, secondOperation));
        ExtensionModelTestUtils.visitableMock((ComponentModel[])new ComponentModel[]{firstOperation, secondOperation});
        this.collector = new ExportedPackagesCollector(this.extensionModel);
    }

    private void withMethod(OperationModel operationModel, Optional<Method> optionalMethod) {
        Mockito.when((Object)operationModel.getModelProperty(ImplementingMethodModelProperty.class)).thenReturn(optionalMethod.map(ImplementingMethodModelProperty::new));
        Mockito.when((Object)operationModel.getModelProperty(ExtensionOperationDescriptorModelProperty.class)).thenReturn(optionalMethod.map(method -> new ExtensionOperationDescriptorModelProperty((OperationElement)new OperationWrapper(method, this.loader))));
    }

    @Test
    public void collect() {
        Set exportedPackages = this.collector.getExportedPackages();
        MatcherAssert.assertThat((Object)exportedPackages, (Matcher)IsCollectionWithSize.hasSize((int)6));
        MatcherAssert.assertThat((Object)exportedPackages, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{SHAPE_PACKAGE, APPLE_PACKAGE, VEGAN_PACKAGE, PEEL_PACKAGE, SEED_PACKAGE, EXCEPTION_PACKAGE}));
    }

    @Test
    public void collectFromModelProperty() {
        Mockito.when((Object)this.extensionModel.getModelProperty(ExportedClassNamesModelProperty.class)).thenReturn(Optional.of(new ExportedClassNamesModelProperty(Collections.singleton(FruitConsistency.class.getName()))));
        Set exportedPackages = this.collector.getExportedPackages();
        MatcherAssert.assertThat((Object)exportedPackages, (Matcher)IsCollectionWithSize.hasSize((int)7));
        MatcherAssert.assertThat((Object)exportedPackages, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{SHAPE_PACKAGE, APPLE_PACKAGE, VEGAN_PACKAGE, PEEL_PACKAGE, SEED_PACKAGE, EXCEPTION_PACKAGE, FruitConsistency.class.getPackage().getName()}));
    }

    private OutputModel mockOutputModel(Type type) {
        OutputModel om = (OutputModel)Mockito.mock(OutputModel.class, (MockSettings)Mockito.withSettings().lenient());
        Mockito.when((Object)om.getType()).thenReturn((Object)this.loader.load(type));
        return om;
    }

    private ParameterModel mockParameterModel(Type type) {
        ParameterModel pm = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)pm.getType()).thenReturn((Object)this.loader.load(type));
        return pm;
    }

    private OperationModel mockOperationModel(OutputModel output, OutputModel attributes, ParameterModel ... params) {
        OperationModel op = (OperationModel)Mockito.mock(OperationModel.class, (MockSettings)Mockito.withSettings().lenient());
        Mockito.when((Object)op.getOutput()).thenReturn((Object)output);
        Mockito.when((Object)op.getOutputAttributes()).thenReturn((Object)attributes);
        if (params != null) {
            ExtensionsTestUtils.mockParameters((ParameterizedModel)op, params);
        }
        return op;
    }
}

