/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.type.catalog;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.metadata.api.annotation.TypeAliasAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.message.api.el.ModuleDefinition;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.module.extension.internal.type.catalog.ExtensionModelToModuleDefinitionTransformer;
import org.mule.tck.junit4.AbstractMuleTestCase;

@Feature(value="Reuse")
@Story(value="Types Catalog")
@Issue(value="W-11706194")
public class ExtensionModelToModuleDefinitionTransformerTestCase
extends AbstractMuleTestCase {
    private static final String MOCK_EXTENSION_PREFIX = "mock";
    private static final String MOCK_TYPE_ALIAS = "MockType";
    private static final String MOCK_TYPE_ID = "MockTypeId";
    private static final String MOCK_EXTENSION_NAME = "Mock Extension";
    private ObjectType mockType;
    private ExtensionModel extensionModel;
    private ExtensionModelToModuleDefinitionTransformer extensionModelToModuleDefinitionTransformer;

    @Before
    public void setUp() {
        this.mockType = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType().id(MOCK_TYPE_ID).with((TypeAnnotation)new TypeAliasAnnotation(MOCK_TYPE_ALIAS)).build();
        this.extensionModel = ExtensionModelToModuleDefinitionTransformerTestCase.extensionWithTypes(ExtensionModelToModuleDefinitionTransformerTestCase.asSet(this.mockType));
        this.extensionModelToModuleDefinitionTransformer = new ExtensionModelToModuleDefinitionTransformer();
    }

    private static ExtensionModel extensionWithTypes(Set<ObjectType> metadataTypes) {
        ExtensionModel mockExtensionModel = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        XmlDslModel dslModel = XmlDslModel.builder().setPrefix(MOCK_EXTENSION_PREFIX).build();
        Mockito.when((Object)mockExtensionModel.getXmlDslModel()).thenReturn((Object)dslModel);
        Mockito.when((Object)mockExtensionModel.getName()).thenReturn((Object)MOCK_EXTENSION_NAME);
        Mockito.when((Object)mockExtensionModel.getTypes()).thenReturn(metadataTypes);
        return mockExtensionModel;
    }

    @Test
    public void resultingModuleDefinitionHasExpectedType() {
        ModuleDefinition moduleDefinition = this.extensionModelToModuleDefinitionTransformer.apply(this.extensionModel);
        Assert.assertThat((Object)moduleDefinition.declaredTypes(), (Matcher)Matchers.contains((Object[])new MetadataType[]{this.mockType}));
    }

    private static <T> Set<T> asSet(T ... a) {
        return Arrays.stream(a).collect(Collectors.toSet());
    }
}

