/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import junit.framework.TestCase;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.api.model.deprecated.ImmutableDeprecationModel;
import org.mule.runtime.module.extension.internal.loader.java.property.CompileTimeModelProperty;
import org.mule.runtime.module.extension.internal.loader.validator.DeprecationModelValidator;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class DeprecationModelValidatorTestCase
extends AbstractMuleTestCase {
    private DeprecationModelValidator validator = new DeprecationModelValidator();
    @Mock(lenient=true)
    private ParameterModel parameterModel;
    @Mock(lenient=true)
    private OperationModel operationModel;
    @Mock(lenient=true)
    private ParameterGroupModel parameterGroupModel;
    @Mock(lenient=true)
    private ExtensionModel extensionModel;

    @Before
    public void doSetup() {
        Mockito.when((Object)this.extensionModel.getOperationModels()).thenReturn(Arrays.asList(this.operationModel));
        Mockito.when((Object)this.extensionModel.getConfigurationModels()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.extensionModel.getConstructModels()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.extensionModel.getFunctionModels()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.extensionModel.getConnectionProviders()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.extensionModel.getSourceModels()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.extensionModel.getDeprecationModel()).thenReturn(Optional.empty());
        Mockito.when((Object)this.extensionModel.getName()).thenReturn((Object)"extensionName");
        Mockito.when((Object)this.operationModel.getParameterGroupModels()).thenReturn(Arrays.asList(this.parameterGroupModel));
        Mockito.when((Object)this.operationModel.getDeprecationModel()).thenReturn(Optional.empty());
        Mockito.when((Object)this.operationModel.getName()).thenReturn((Object)"extensionOperation");
        Mockito.when((Object)this.parameterGroupModel.getParameterModels()).thenReturn(Arrays.asList(this.parameterModel));
        Mockito.when((Object)this.parameterModel.isDeprecated()).thenReturn((Object)false);
        Mockito.when((Object)this.parameterModel.getDeprecationModel()).thenReturn(Optional.empty());
        Mockito.when((Object)this.parameterModel.getName()).thenReturn((Object)"parameterName");
        Mockito.when((Object)this.extensionModel.getModelProperty(CompileTimeModelProperty.class)).thenReturn(Optional.ofNullable(new CompileTimeModelProperty()));
    }

    @Test
    public void deprecatedExtensionWithInvalidVersion() {
        Mockito.when((Object)this.extensionModel.isDeprecated()).thenReturn((Object)true);
        Mockito.when((Object)this.extensionModel.getDeprecationModel()).thenReturn(Optional.of(new ImmutableDeprecationModel("This extension is deprecated.", "hola", null)));
        ProblemsReporter problemsReporter = new ProblemsReporter(this.extensionModel);
        this.validator.validate(this.extensionModel, problemsReporter);
        TestCase.assertTrue((boolean)problemsReporter.hasErrors());
        MatcherAssert.assertThat((Object)((Problem)problemsReporter.getErrors().get(0)).getMessage(), (Matcher)Matchers.is((Object)"The extension named extensionName was deprecated with an invalid 'since' version : 'hola' . This version must follow the semver convention"));
    }

    @Test
    public void optionalDeprecatedParameter() {
        Mockito.when((Object)this.parameterModel.isDeprecated()).thenReturn((Object)true);
        ProblemsReporter problemsReporter = new ProblemsReporter(this.extensionModel);
        Mockito.when((Object)this.parameterModel.isRequired()).thenReturn((Object)false);
        this.validator.validate(this.extensionModel, problemsReporter);
        TestCase.assertFalse((boolean)problemsReporter.hasErrors());
    }

    @Test
    public void requiredDeprecatedParameter() {
        Mockito.when((Object)this.parameterModel.isDeprecated()).thenReturn((Object)true);
        ProblemsReporter problemsReporter = new ProblemsReporter(this.extensionModel);
        Mockito.when((Object)this.parameterModel.isRequired()).thenReturn((Object)true);
        this.validator.validate(this.extensionModel, problemsReporter);
        TestCase.assertTrue((boolean)problemsReporter.hasErrors());
    }

    @Test
    public void deprecatedParameterWithInvalidVersion() {
        Mockito.when((Object)this.parameterModel.isDeprecated()).thenReturn((Object)true);
        Mockito.when((Object)this.parameterModel.isRequired()).thenReturn((Object)false);
        Mockito.when((Object)this.parameterModel.getDeprecationModel()).thenReturn(Optional.of(new ImmutableDeprecationModel("This parameter is deprecated", "2.hola", null)));
        ProblemsReporter problemsReporter = new ProblemsReporter(this.extensionModel);
        this.validator.validate(this.extensionModel, problemsReporter);
        TestCase.assertTrue((boolean)problemsReporter.hasErrors());
        MatcherAssert.assertThat((Object)((Problem)problemsReporter.getErrors().get(0)).getMessage(), (Matcher)Matchers.is((Object)"The parameter named parameterName was deprecated with an invalid 'since' version : '2.hola' . This version must follow the semver convention"));
    }

    @Test
    public void deprecatedOperationWithInvalidVersion() {
        Mockito.when((Object)this.operationModel.isDeprecated()).thenReturn((Object)true);
        Mockito.when((Object)this.operationModel.getDeprecationModel()).thenReturn(Optional.of(new ImmutableDeprecationModel("This operation is deprecated", "2.hola", null)));
        ProblemsReporter problemsReporter = new ProblemsReporter(this.extensionModel);
        this.validator.validate(this.extensionModel, problemsReporter);
        TestCase.assertTrue((boolean)problemsReporter.hasErrors());
        MatcherAssert.assertThat((Object)((Problem)problemsReporter.getErrors().get(0)).getMessage(), (Matcher)Matchers.is((Object)"The operation named extensionOperation was deprecated with an invalid 'since' version : '2.hola' . This version must follow the semver convention"));
    }

    @Test
    public void deprecatedOperationWithValidVersions() {
        Mockito.when((Object)this.operationModel.isDeprecated()).thenReturn((Object)true);
        Mockito.when((Object)this.operationModel.getDeprecationModel()).thenReturn(Optional.of(new ImmutableDeprecationModel("This operation is deprecated", "2.2.3", "3.0.0")));
        ProblemsReporter problemsReporter = new ProblemsReporter(this.extensionModel);
        this.validator.validate(this.extensionModel, problemsReporter);
        TestCase.assertFalse((boolean)problemsReporter.hasErrors());
    }

    @Test
    public void deprecatedOperationWithToRemoveInPriorToSinceVersion() {
        Mockito.when((Object)this.operationModel.isDeprecated()).thenReturn((Object)true);
        Mockito.when((Object)this.operationModel.getDeprecationModel()).thenReturn(Optional.of(new ImmutableDeprecationModel("This operation is deprecated", "2.2.0", "2.0.0")));
        ProblemsReporter problemsReporter = new ProblemsReporter(this.extensionModel);
        this.validator.validate(this.extensionModel, problemsReporter);
        TestCase.assertTrue((boolean)problemsReporter.hasErrors());
        MatcherAssert.assertThat((Object)((Problem)problemsReporter.getErrors().get(0)).getMessage(), (Matcher)Matchers.is((Object)"The versions chosen for the deprecation of the operation named extensionOperation are invalid, `since`(2.2.0) version must be prior to the `removeTo`(2.0.0) version."));
    }
}

