/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.parser.java;

import java.util.Collections;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.Configurations;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.internal.loader.DefaultExtensionLoadingContext;
import org.mule.runtime.module.extension.api.loader.java.type.ComponentElement;
import org.mule.runtime.module.extension.api.loader.java.type.ConfigurationElement;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionElement;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.ExtensionTypeWrapper;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaConfigurationModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaExtensionModelParser;
import org.mule.sdk.api.annotation.Extension;
import org.mule.sdk.api.annotation.NoImplicit;
import org.mule.sdk.api.annotation.Operations;
import org.mule.sdk.api.annotation.Sources;
import org.mule.sdk.api.annotation.connectivity.ConnectionProviders;
import org.mule.sdk.api.annotation.param.Parameter;
import org.mule.sdk.api.connectivity.ConnectionProvider;
import org.mule.sdk.api.connectivity.ConnectionValidationResult;
import org.mule.sdk.api.runtime.source.Source;
import org.mule.sdk.api.runtime.source.SourceCallback;

public class JavaConfigurationModelParserTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void getConfigurationNameFromConfigurationUsingSdkApi() {
        JavaConfigurationModelParser javaConfigurationModelParser = this.getParser(SimpleSdkExtension.class, SimpleSdkConfiguration.class);
        MatcherAssert.assertThat((Object)javaConfigurationModelParser.getName(), (Matcher)CoreMatchers.is((Object)"newSdkConfiguration"));
    }

    @Test
    public void getConfigurationNameFromConfigurationUsingLegacyApi() {
        JavaConfigurationModelParser javaConfigurationModelParser = this.getParser(SimpleLegacyExtension.class, SimpleLegacyConfiguration.class);
        MatcherAssert.assertThat((Object)javaConfigurationModelParser.getName(), (Matcher)CoreMatchers.is((Object)"oldLegacyConfiguration"));
    }

    @Test
    public void getConfigurationNameFromConfigurationUsingSdkAndLegacyApi() {
        this.expectedException.expect(CoreMatchers.instanceOf(IllegalModelDefinitionException.class));
        this.expectedException.expectMessage("Annotations org.mule.runtime.extension.api.annotation.Configuration and org.mule.sdk.api.annotation.Configuration are both present at the same time on Configuration SimpleWronglyAnnotatedConfiguration");
        JavaConfigurationModelParser javaConfigurationModelParser = this.getParser(SimpleSdkExtensionWithWronglyAnnotatedConfiguration.class, SimpleWronglyAnnotatedConfiguration.class);
        javaConfigurationModelParser.getName();
    }

    @Test
    public void isForceNoImplicitOnConfigurationUsingTheSdkApi() {
        JavaConfigurationModelParser javaConfigurationModelParser = this.getParser(SimpleSdkExtension.class, SimpleSdkConfiguration.class);
        MatcherAssert.assertThat((Object)javaConfigurationModelParser.isForceNoImplicit(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void isForceNoImplicitOnConfigurationUsingTheLegacyApi() {
        JavaConfigurationModelParser javaConfigurationModelParser = this.getParser(SimpleLegacyExtension.class, SimpleLegacyConfiguration.class);
        MatcherAssert.assertThat((Object)javaConfigurationModelParser.isForceNoImplicit(), (Matcher)CoreMatchers.is((Object)true));
    }

    protected JavaConfigurationModelParser getParser(Class<?> extension, Class<?> configuration) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        DefaultExtensionLoadingContext ctx = new DefaultExtensionLoadingContext(contextClassLoader, DslResolvingContext.getDefault(Collections.emptySet()));
        ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader(contextClassLoader);
        ExtensionTypeWrapper extensionElement = new ExtensionTypeWrapper(extension, typeLoader);
        ConfigurationElement configurationElement = extensionElement.getConfigurations().stream().filter(conf -> conf.getTypeName().equals(configuration.getName())).findFirst().orElseThrow(() -> new IllegalStateException(String.format("Configuration %s was not found among the declared configuration in the extension", configuration.getName(), extension.getName())));
        JavaExtensionModelParser javaExtensionModelParser = new JavaExtensionModelParser((ExtensionElement)extensionElement, (ExtensionLoadingContext)ctx);
        return new JavaConfigurationModelParser(javaExtensionModelParser, (ExtensionElement)extensionElement, (ComponentElement)configurationElement, (ExtensionLoadingContext)ctx);
    }

    @org.mule.sdk.api.annotation.Configuration(name="wronglySdkConfiguration")
    @Configuration(name="wronglyLegacyConfiguration")
    private static class SimpleWronglyAnnotatedConfiguration {
        private SimpleWronglyAnnotatedConfiguration() {
        }
    }

    @Extension(name="SimpleSdkExtension")
    @org.mule.sdk.api.annotation.Configurations(value={SimpleWronglyAnnotatedConfiguration.class})
    private static class SimpleSdkExtensionWithWronglyAnnotatedConfiguration {
        private SimpleSdkExtensionWithWronglyAnnotatedConfiguration() {
        }
    }

    private static class SdkSource
    extends Source<String, String> {
        private SdkSource() {
        }

        public void onStart(SourceCallback<String, String> sourceCallback) throws MuleException {
        }

        public void onStop() {
        }
    }

    private static class SdkConnectionProvider
    implements ConnectionProvider<String> {
        private SdkConnectionProvider() {
        }

        public String connect() throws ConnectionException {
            return null;
        }

        public void disconnect(String connection) {
        }

        public ConnectionValidationResult validate(String connection) {
            return null;
        }
    }

    private static class SimpleOperations {
        private SimpleOperations() {
        }
    }

    @Configuration(name="ParameterizedConfiguration")
    @Operations(value={SimpleOperations.class})
    @Sources(value={SdkSource.class})
    @ConnectionProviders(value={SdkConnectionProvider.class})
    private static class AnnotatedConfiguration {
        private AnnotatedConfiguration() {
        }
    }

    @Configuration(name="ExtendsParameterizedConfiguration")
    private static class ExtendsParameterizedConfiguration
    extends ParameterizedConfiguration {
        private ExtendsParameterizedConfiguration() {
        }
    }

    @Configuration(name="ParameterizedConfiguration")
    private static class ParameterizedConfiguration {
        @Parameter
        String configField;

        private ParameterizedConfiguration() {
        }
    }

    @org.mule.sdk.api.annotation.Configuration(name="SdkAnnotationConfiguration")
    private static class SdkAnnotationConfiguration {
        private SdkAnnotationConfiguration() {
        }
    }

    @Configuration(name="LegacyAnnotationConfiguration")
    private static class LegacyAnnotationConfiguration {
        private LegacyAnnotationConfiguration() {
        }
    }

    @Configuration(name="NoImplicitSdkConfiguration")
    @NoImplicit
    private static class NoImplicitSdkConfiguration {
        private NoImplicitSdkConfiguration() {
        }
    }

    @Configuration(name="NoImplicitLegacyConfiguration")
    @org.mule.runtime.extension.api.annotation.NoImplicit
    private static class NoImplicitLegacyConfiguration {
        private NoImplicitLegacyConfiguration() {
        }
    }

    @org.mule.runtime.extension.api.annotation.Extension(name="SimpleLegacyExtensionWithOperations")
    @Configurations(value={NoImplicitLegacyConfiguration.class, NoImplicitSdkConfiguration.class, LegacyAnnotationConfiguration.class, SdkAnnotationConfiguration.class, ParameterizedConfiguration.class, AnnotatedConfiguration.class, ExtendsParameterizedConfiguration.class})
    private static class LegacyAnnotationsExtension {
        private LegacyAnnotationsExtension() {
        }
    }

    @Configuration(name="oldLegacyConfiguration")
    @org.mule.runtime.extension.api.annotation.NoImplicit
    private static class SimpleLegacyConfiguration {
        private SimpleLegacyConfiguration() {
        }
    }

    @Extension(name="SimpleLegacyExtension")
    @org.mule.sdk.api.annotation.Configurations(value={SimpleLegacyConfiguration.class})
    private static class SimpleLegacyExtension {
        private SimpleLegacyExtension() {
        }
    }

    @org.mule.sdk.api.annotation.Configuration(name="newSdkConfiguration")
    @NoImplicit
    private static class SimpleSdkConfiguration {
        private SimpleSdkConfiguration() {
        }
    }

    @Extension(name="SimpleSdkExtension")
    @org.mule.sdk.api.annotation.Configurations(value={SimpleSdkConfiguration.class})
    private static class SimpleSdkExtension {
        private SimpleSdkExtension() {
        }
    }
}

