/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.SubTypesModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthParameterModelProperty;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.property.InfrastructureParameterModelProperty;
import org.mule.runtime.extension.api.property.QNameModelProperty;
import org.mule.runtime.extension.internal.loader.validator.ParameterModelValidator;
import org.mule.runtime.module.extension.internal.loader.java.property.ParameterGroupModelProperty;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.test.heisenberg.extension.model.HealthStatus;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class ParameterModelValidatorTestCase
extends AbstractMuleTestCase {
    private static final String COMPONENT_ID_ERROR_PREFIX = "Parameter 'url' in the operation 'dummyOperation' is declared as a Component ID, but ";
    @Mock(answer=Answers.RETURNS_DEEP_STUBS, lenient=true)
    private ExtensionModel extensionModel;
    @Mock(lenient=true)
    private OperationModel operationModel;
    @Mock(lenient=true)
    private ParameterModel validParameterModel;
    @Mock(lenient=true)
    private ParameterModel invalidParameterModel;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private ParameterModelValidator validator = new ParameterModelValidator();

    @Before
    public void before() {
        Mockito.when((Object)this.extensionModel.getOperationModels()).thenReturn(Arrays.asList(this.operationModel));
        ExtensionsTestUtils.mockSubTypes(this.extensionModel, new SubTypesModel[0]);
        Mockito.when((Object)this.extensionModel.getName()).thenReturn((Object)"extensionModel");
        Mockito.when((Object)this.extensionModel.getImportedTypes()).thenReturn(Collections.emptySet());
        Mockito.when((Object)this.extensionModel.getXmlDslModel()).thenReturn((Object)XmlDslModel.builder().setPrefix("ns").setNamespace("http://www.mulesoft.org/schema/mule/ns").setSchemaLocation("http://www.mulesoft.org/schema/mule/heisenberg/current/mule-ns.xsd").build());
        Mockito.when((Object)this.operationModel.getName()).thenReturn((Object)"dummyOperation");
        Mockito.when((Object)this.validParameterModel.getName()).thenReturn((Object)"url");
        Mockito.when((Object)this.validParameterModel.getModelProperty(ParameterGroupModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.validParameterModel.getModelProperty(QNameModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.validParameterModel.getModelProperty(InfrastructureParameterModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.validParameterModel.getModelProperty(OAuthParameterModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.validParameterModel.getDslConfiguration()).thenReturn((Object)ParameterDslConfiguration.getDefaultInstance());
        Mockito.when((Object)this.validParameterModel.getRole()).thenReturn((Object)ParameterRole.BEHAVIOUR);
        Mockito.when((Object)this.validParameterModel.getLayoutModel()).thenReturn(Optional.empty());
        Mockito.when((Object)this.validParameterModel.getType()).thenReturn((Object)ExtensionsTestUtils.toMetadataType(String.class));
        Mockito.when((Object)this.validParameterModel.getExpressionSupport()).thenReturn((Object)ExpressionSupport.SUPPORTED);
        Mockito.when((Object)this.invalidParameterModel.getName()).thenReturn((Object)"url");
        Mockito.when((Object)this.invalidParameterModel.getModelProperty(ParameterGroupModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.invalidParameterModel.getModelProperty(QNameModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.invalidParameterModel.getModelProperty(InfrastructureParameterModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.invalidParameterModel.getModelProperty(OAuthParameterModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.invalidParameterModel.getDslConfiguration()).thenReturn((Object)ParameterDslConfiguration.getDefaultInstance());
        Mockito.when((Object)this.invalidParameterModel.getRole()).thenReturn((Object)ParameterRole.BEHAVIOUR);
        Mockito.when((Object)this.invalidParameterModel.getLayoutModel()).thenReturn(Optional.empty());
        Mockito.when((Object)this.invalidParameterModel.getType()).thenReturn((Object)ExtensionsTestUtils.toMetadataType(String.class));
        Mockito.when((Object)this.invalidParameterModel.getExpressionSupport()).thenReturn((Object)ExpressionSupport.SUPPORTED);
        Mockito.when((Object)this.invalidParameterModel.isRequired()).thenReturn((Object)true);
    }

    @Test
    public void validModel() {
        ExtensionsTestUtils.mockParameters((ParameterizedModel)this.operationModel, this.validParameterModel);
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void invalidModelDueToDefaultValueWhenRequired() {
        Mockito.when((Object)this.invalidParameterModel.isRequired()).thenReturn((Object)true);
        Mockito.when((Object)this.invalidParameterModel.getDefaultValue()).thenReturn((Object)"default");
        ExtensionsTestUtils.mockParameters((ParameterizedModel)this.operationModel, this.invalidParameterModel);
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void invalidType() {
        this.expectedException.expect(IllegalModelDefinitionException.class);
        this.expectedException.expectMessage("Parameter 'url' in the operation 'dummyOperation' must provide a type");
        Mockito.when((Object)this.invalidParameterModel.getType()).thenReturn(null);
        ExtensionsTestUtils.mockParameters((ParameterizedModel)this.operationModel, this.invalidParameterModel);
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void invalidConfigOverrideWithDefault() {
        this.expectedException.expect(IllegalModelDefinitionException.class);
        this.expectedException.expectMessage("Parameter 'url' in the operation 'dummyOperation' is declared as a config override");
        Mockito.when((Object)this.invalidParameterModel.getDefaultValue()).thenReturn((Object)"default");
        Mockito.when((Object)this.invalidParameterModel.isOverrideFromConfig()).thenReturn((Object)true);
        ExtensionsTestUtils.mockParameters((ParameterizedModel)this.operationModel, this.invalidParameterModel);
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void invalidEnumDefaultValue() {
        this.expectedException.expect(IllegalModelDefinitionException.class);
        this.expectedException.expectMessage("Parameter 'url' in the operation 'dummyOperation' has 'default' as default value which is not listed as an available option (i.e.: HEALTHY, CANCER, DEAD)");
        Mockito.when((Object)this.invalidParameterModel.isRequired()).thenReturn((Object)false);
        Mockito.when((Object)this.invalidParameterModel.getDefaultValue()).thenReturn((Object)"default");
        Mockito.when((Object)this.invalidParameterModel.getType()).thenReturn((Object)ExtensionsTestUtils.toMetadataType(HealthStatus.class));
        ExtensionsTestUtils.mockParameters((ParameterizedModel)this.operationModel, this.invalidParameterModel);
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void validExpressionEnumDefaultValue() {
        Mockito.when((Object)this.invalidParameterModel.isRequired()).thenReturn((Object)false);
        Mockito.when((Object)this.invalidParameterModel.getDefaultValue()).thenReturn((Object)"#[payload]");
        Mockito.when((Object)this.invalidParameterModel.getType()).thenReturn((Object)ExtensionsTestUtils.toMetadataType(HealthStatus.class));
        ExtensionsTestUtils.mockParameters((ParameterizedModel)this.operationModel, this.invalidParameterModel);
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void invalidOptionalComponentId() {
        this.expectedException.expect(IllegalModelDefinitionException.class);
        this.expectedException.expectMessage("Parameter 'url' in the operation 'dummyOperation' is declared as a Component ID, but is also marked as Optional.");
        Mockito.when((Object)this.invalidParameterModel.isRequired()).thenReturn((Object)false);
        Mockito.when((Object)this.invalidParameterModel.isComponentId()).thenReturn((Object)true);
        ExtensionsTestUtils.mockParameters((ParameterizedModel)this.operationModel, this.invalidParameterModel);
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void invalidTypeForComponentId() {
        this.expectedException.expect(IllegalModelDefinitionException.class);
        this.expectedException.expectMessage("Parameter 'url' in the operation 'dummyOperation' is declared as a Component ID, but is of type 'java.lang.Integer'");
        Mockito.when((Object)this.invalidParameterModel.isComponentId()).thenReturn((Object)true);
        Mockito.when((Object)this.invalidParameterModel.getType()).thenReturn((Object)ExtensionsTestUtils.toMetadataType(Integer.class));
        ExtensionsTestUtils.mockParameters((ParameterizedModel)this.operationModel, this.invalidParameterModel);
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void invalidComponentIdAsOverride() {
        this.expectedException.expect(IllegalModelDefinitionException.class);
        this.expectedException.expectMessage("Parameter 'url' in the operation 'dummyOperation' is declared as a Component ID, but is also declared as a ConfigOverride.");
        Mockito.when((Object)this.invalidParameterModel.isComponentId()).thenReturn((Object)true);
        Mockito.when((Object)this.invalidParameterModel.isOverrideFromConfig()).thenReturn((Object)true);
        ExtensionsTestUtils.mockParameters((ParameterizedModel)this.operationModel, this.invalidParameterModel);
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void invalidExpressionSupportForComponentIdA() {
        this.expectedException.expect(IllegalModelDefinitionException.class);
        this.expectedException.expectMessage("Parameter 'url' in the operation 'dummyOperation' is declared as a Component ID, but declares its expression support as 'SUPPORTED'");
        Mockito.when((Object)this.invalidParameterModel.isComponentId()).thenReturn((Object)true);
        ExtensionsTestUtils.mockParameters((ParameterizedModel)this.operationModel, this.invalidParameterModel);
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void invalidLayoutTextForComponentId() {
        this.expectedException.expect(IllegalModelDefinitionException.class);
        this.expectedException.expectMessage("Parameter 'url' in the operation 'dummyOperation' is declared as a Component ID, but is also declared as 'Text'");
        Mockito.when((Object)this.invalidParameterModel.isComponentId()).thenReturn((Object)true);
        Mockito.when((Object)this.invalidParameterModel.getLayoutModel()).thenReturn(Optional.of(LayoutModel.builder().asText().build()));
        ExtensionsTestUtils.mockParameters((ParameterizedModel)this.operationModel, this.invalidParameterModel);
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void invalidLayoutQueryForComponentId() {
        this.expectedException.expect(IllegalModelDefinitionException.class);
        this.expectedException.expectMessage("Parameter 'url' in the operation 'dummyOperation' is declared as a Component ID, but is also declared as 'Query'");
        Mockito.when((Object)this.invalidParameterModel.isComponentId()).thenReturn((Object)true);
        Mockito.when((Object)this.invalidParameterModel.getLayoutModel()).thenReturn(Optional.of(LayoutModel.builder().asQuery().build()));
        ExtensionsTestUtils.mockParameters((ParameterizedModel)this.operationModel, this.invalidParameterModel);
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void invalidLayoutPasswordForComponentId() {
        this.expectedException.expect(IllegalModelDefinitionException.class);
        this.expectedException.expectMessage("Parameter 'url' in the operation 'dummyOperation' is declared as a Component ID, but is also declared as 'Password'");
        Mockito.when((Object)this.invalidParameterModel.isComponentId()).thenReturn((Object)true);
        Mockito.when((Object)this.invalidParameterModel.getLayoutModel()).thenReturn(Optional.of(LayoutModel.builder().asPassword().build()));
        ExtensionsTestUtils.mockParameters((ParameterizedModel)this.operationModel, this.invalidParameterModel);
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }
}

