/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.manager;

import io.qameta.allure.Issue;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.api.meta.model.error.ErrorModelBuilder;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.test.util.tck.ExtensionModelTestUtils;
import org.mule.runtime.api.util.NameUtils;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.internal.exception.ErrorTypeLocatorFactory;
import org.mule.runtime.core.internal.message.ErrorTypeBuilder;
import org.mule.runtime.core.privileged.PrivilegedMuleContext;
import org.mule.runtime.core.privileged.exception.ErrorTypeLocator;
import org.mule.runtime.module.extension.internal.manager.ExtensionErrorsRegistrant;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.tck.util.MuleContextUtils;

@SmallTest
public class ExtensionErrorsRegistrantTestCase
extends AbstractMuleTestCase {
    private static final String TEST_EXTENSION_NAME = "Test Extension";
    private static final String EXTENSION_PREFIX = "test-namespace";
    private static final String ERROR_PREFIX = "test-namespace".toUpperCase();
    private static final String OPERATION_NAME = "operationName";
    private static final String TEST_CONNECTIVITY_ERROR_TYPE = "TEST_CONNECTIVITY";
    private static final String MULE = "MULE";
    private static final String ANY = "ANY";
    private static final ComponentIdentifier OPERATION_IDENTIFIER = ComponentIdentifier.builder().name(NameUtils.hyphenize((String)"operationName")).namespace("test-namespace").build();
    private static final ErrorModel MULE_CONNECTIVITY_ERROR = ErrorModelBuilder.newError((String)"CONNECTIVITY", (String)"MULE").build();
    private static final ErrorModel extensionConnectivityError = ErrorModelBuilder.newError((String)"TEST_CONNECTIVITY", (String)ERROR_PREFIX).withParent(MULE_CONNECTIVITY_ERROR).build();
    @Rule
    public MockitoRule rule = MockitoJUnit.rule().silent();
    @Mock(lenient=true)
    private ExtensionModel extensionModel;
    @Mock(lenient=true)
    private OperationModel operationWithError;
    @Mock(lenient=true)
    private OperationModel operationWithoutErrors;
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private final MuleContext muleContext = MuleContextUtils.mockContextWithServices();
    private ErrorTypeRepository typeRepository;
    private ErrorTypeLocator typeLocator;

    @Before
    public void setUp() {
        XmlDslModel.XmlDslModelBuilder builder = XmlDslModel.builder();
        builder.setPrefix(EXTENSION_PREFIX);
        XmlDslModel xmlDslModel = builder.build();
        ErrorType anyErrorType = ErrorTypeBuilder.builder().namespace(MULE).identifier(ANY).build();
        this.typeRepository = (ErrorTypeRepository)Mockito.mock(ErrorTypeRepository.class);
        Mockito.when((Object)this.typeRepository.getErrorType((ComponentIdentifier)ArgumentMatchers.any())).thenReturn(Optional.of((ErrorType)Mockito.mock(ErrorType.class)));
        Mockito.when((Object)this.typeRepository.lookupErrorType((ComponentIdentifier)ArgumentMatchers.any())).thenReturn(Optional.of((ErrorType)Mockito.mock(ErrorType.class)));
        Mockito.when((Object)this.typeRepository.getCriticalErrorType()).thenReturn((Object)((ErrorType)Mockito.mock(ErrorType.class)));
        Mockito.when((Object)this.typeRepository.getAnyErrorType()).thenReturn((Object)anyErrorType);
        this.typeLocator = ErrorTypeLocatorFactory.createDefaultErrorTypeLocator((ErrorTypeRepository)this.typeRepository);
        Mockito.when((Object)this.muleContext.getErrorTypeRepository()).thenReturn((Object)this.typeRepository);
        Mockito.when((Object)((PrivilegedMuleContext)this.muleContext).getErrorTypeLocator()).thenReturn((Object)this.typeLocator);
        Mockito.when((Object)this.extensionModel.getXmlDslModel()).thenReturn((Object)xmlDslModel);
        Mockito.when((Object)this.extensionModel.getName()).thenReturn((Object)TEST_EXTENSION_NAME);
        Mockito.when((Object)this.operationWithError.getErrorModels()).thenReturn(Collections.singleton(extensionConnectivityError));
        Mockito.when((Object)this.operationWithError.getName()).thenReturn((Object)OPERATION_NAME);
        Mockito.when((Object)this.operationWithError.getModelProperty((Class)ArgumentMatchers.any())).thenReturn(Optional.empty());
        Mockito.when((Object)this.operationWithoutErrors.getName()).thenReturn((Object)"operationWithoutError");
        Mockito.when((Object)this.operationWithoutErrors.getErrorModels()).thenReturn(Collections.emptySet());
        Mockito.when((Object)this.operationWithoutErrors.getModelProperty((Class)ArgumentMatchers.any())).thenReturn(Optional.empty());
        ExtensionModelTestUtils.visitableMock((ComponentModel[])new ComponentModel[]{this.operationWithError, this.operationWithoutErrors});
    }

    @Test
    public void lookupErrorsForOperation() {
        Mockito.when((Object)this.extensionModel.getOperationModels()).thenReturn(Arrays.asList(this.operationWithError, this.operationWithoutErrors));
        this.doTest();
    }

    @Test
    @Issue(value="MULE-19293")
    public void lookupErrorsForOperationFromConfig() {
        ConfigurationModel configModel = (ConfigurationModel)Mockito.mock(ConfigurationModel.class);
        Mockito.when((Object)configModel.getOperationModels()).thenReturn(Arrays.asList(this.operationWithError, this.operationWithoutErrors));
        Mockito.when((Object)this.extensionModel.getConfigurationModels()).thenReturn(Collections.singletonList(configModel));
        this.doTest();
    }

    protected void doTest() {
        Mockito.when((Object)this.extensionModel.getErrorModels()).thenReturn(Collections.singleton(extensionConnectivityError));
        ErrorType extConnectivityErrorType = ErrorTypeBuilder.builder().namespace(ERROR_PREFIX).identifier("CONNECTIVITY").parentErrorType(ErrorTypeBuilder.builder().namespace(MULE).identifier("CONNECTIVITY").parentErrorType(this.typeRepository.getAnyErrorType()).build()).build();
        Mockito.when((Object)this.typeRepository.lookupErrorType(ComponentIdentifier.builder().namespace(ERROR_PREFIX).name("CONNECTIVITY").build())).thenReturn(Optional.of(extConnectivityErrorType));
        Mockito.when((Object)this.typeRepository.lookupErrorType(ComponentIdentifier.builder().namespace(ERROR_PREFIX).name("RETRY_EXHAUSTED").build())).thenReturn(Optional.empty());
        ExtensionErrorsRegistrant.registerErrorMappings((ErrorTypeRepository)this.typeRepository, (ErrorTypeLocator)this.typeLocator, Collections.singleton(this.extensionModel));
        ErrorType errorType = this.typeLocator.lookupComponentErrorType(OPERATION_IDENTIFIER, ConnectionException.class);
        MatcherAssert.assertThat((Object)errorType.getIdentifier(), (Matcher)CoreMatchers.is((Object)"CONNECTIVITY"));
        MatcherAssert.assertThat((Object)errorType.getNamespace(), (Matcher)CoreMatchers.is((Object)EXTENSION_PREFIX.toUpperCase()));
        ErrorType muleConnectivityError = errorType.getParentErrorType();
        MatcherAssert.assertThat((Object)muleConnectivityError.getNamespace(), (Matcher)CoreMatchers.is((Object)MULE_CONNECTIVITY_ERROR.getNamespace()));
        MatcherAssert.assertThat((Object)muleConnectivityError.getIdentifier(), (Matcher)CoreMatchers.is((Object)MULE_CONNECTIVITY_ERROR.getType()));
        ErrorType anyErrorType = muleConnectivityError.getParentErrorType();
        MatcherAssert.assertThat((Object)anyErrorType.getNamespace(), (Matcher)CoreMatchers.is((Object)MULE));
        MatcherAssert.assertThat((Object)anyErrorType.getIdentifier(), (Matcher)CoreMatchers.is((Object)ANY));
        MatcherAssert.assertThat((Object)anyErrorType.getParentErrorType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }
}

