/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader;

import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.visitor.BasicTypeMetadataVisitor;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.java.api.JavaTypeLoader;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=Parameterized.class)
public class BasicTypeMetadataVisitorTestCase
extends AbstractMuleTestCase {
    private static final BaseTypeBuilder BUILDER = BaseTypeBuilder.create((MetadataFormat)JavaTypeLoader.JAVA);
    @Parameterized.Parameter(value=0)
    public MetadataType metadataType;
    @Parameterized.Parameter(value=1)
    public boolean expectedSimple;
    private BasicTypeMetadataVisitor visitor = new BasicTypeMetadataVisitor(){

        protected void visitBasicType(MetadataType metadataType) {
            BasicTypeMetadataVisitorTestCase.this.simpleType = true;
        }

        protected void defaultVisit(MetadataType metadataType) {
            BasicTypeMetadataVisitorTestCase.this.complexType = true;
        }
    };
    private boolean simpleType;
    private boolean complexType;

    @Parameterized.Parameters(name="isSimpleType({0})")
    public static Collection<Object[]> data() {
        return Arrays.asList({BUILDER.stringType().build(), true}, {BUILDER.numberType().build(), true}, {BUILDER.booleanType().build(), true}, {BUILDER.objectType().build(), false}, {BUILDER.arrayType().of((TypeBuilder)BUILDER.stringType()).build(), false}, {BUILDER.dateTimeType().build(), false});
    }

    @Before
    public void before() {
        this.simpleType = false;
        this.complexType = false;
    }

    @Test
    public void assertSimpleOrNot() {
        this.metadataType.accept((MetadataTypeVisitor)this.visitor);
        Assert.assertThat((Object)this.simpleType, (Matcher)CoreMatchers.is((Object)this.expectedSimple));
        Assert.assertThat((Object)this.complexType, (Matcher)CoreMatchers.is((Object)(!this.expectedSimple ? 1 : 0)));
    }
}

