/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java;

import java.util.TreeSet;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.runtime.api.meta.model.ImportedTypeModel;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.test.module.extension.internal.util.ExtensionDeclarationTestUtils;
import org.mule.test.module.extension.internal.util.extension.SimpleExtensionUsingSdkApi;

public class AbstractExtensionModelLoaderDelegateTestCase {
    @Test
    public void verifyExportedTypesAndResourcesFromExtensionUsingSdkApi() {
        ExtensionDeclarer extensionDeclarer = ExtensionDeclarationTestUtils.declarerFor(SimpleExtensionUsingSdkApi.class, Thread.currentThread().getContextClassLoader(), "1.0.0-dev");
        MatcherAssert.assertThat((Object)((ExtensionDeclaration)extensionDeclarer.getDeclaration()).getResources().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((String)((ExtensionDeclaration)extensionDeclarer.getDeclaration()).getResources().iterator().next()), (Matcher)Matchers.equalTo((Object)"simpleResource.json"));
        MatcherAssert.assertThat((Object)((ExtensionDeclaration)extensionDeclarer.getDeclaration()).getTypes().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((ClassInformationAnnotation)((ObjectType)((ExtensionDeclaration)extensionDeclarer.getDeclaration()).getTypes().iterator().next()).getAnnotation(ClassInformationAnnotation.class).get()).getClassname(), (Matcher)Matchers.equalTo((Object)"org.mule.test.module.extension.internal.util.extension.SimpleExportedType"));
    }

    @Test
    public void verifyExportedTypesAndResourcesFromExtensionUsingLegacyApi() {
        ExtensionDeclarer extensionDeclarer = ExtensionDeclarationTestUtils.declarerFor(SimpleExtensionUsingSdkApi.class, Thread.currentThread().getContextClassLoader(), "1.0.0-dev");
        MatcherAssert.assertThat((Object)((ExtensionDeclaration)extensionDeclarer.getDeclaration()).getResources().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((String)((ExtensionDeclaration)extensionDeclarer.getDeclaration()).getResources().iterator().next()), (Matcher)Matchers.equalTo((Object)"simpleResource.json"));
        MatcherAssert.assertThat((Object)((ExtensionDeclaration)extensionDeclarer.getDeclaration()).getTypes().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((ClassInformationAnnotation)((ObjectType)((ExtensionDeclaration)extensionDeclarer.getDeclaration()).getTypes().iterator().next()).getAnnotation(ClassInformationAnnotation.class).get()).getClassname(), (Matcher)Matchers.equalTo((Object)"org.mule.test.module.extension.internal.util.extension.SimpleExportedType"));
    }

    @Test
    public void verifyImportedTypesFromExtensionUsingTheSdkApi() {
        ExtensionDeclarer extensionDeclarer = ExtensionDeclarationTestUtils.declarerFor(SimpleExtensionUsingSdkApi.class, Thread.currentThread().getContextClassLoader(), "1.0.0-dev");
        ExtensionDeclaration extensionDeclaration = (ExtensionDeclaration)extensionDeclarer.getDeclaration();
        ObjectType importedType = ((ImportedTypeModel)((TreeSet)extensionDeclaration.getImportedTypes()).first()).getImportedType();
        MatcherAssert.assertThat((Object)extensionDeclaration.getImportedTypes().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((ClassInformationAnnotation)importedType.getAnnotation(ClassInformationAnnotation.class).get()).getClassname(), (Matcher)Matchers.is((Object)"org.mule.test.heisenberg.extension.model.KnockeableDoor"));
    }

    @Test
    public void verifyImportedTypesFromExtensionUsingTheLegacyApi() {
        ExtensionDeclarer extensionDeclarer = ExtensionDeclarationTestUtils.declarerFor(SimpleExtensionUsingSdkApi.class, Thread.currentThread().getContextClassLoader(), "1.0.0-dev");
        ExtensionDeclaration extensionDeclaration = (ExtensionDeclaration)extensionDeclarer.getDeclaration();
        ObjectType importedType = ((ImportedTypeModel)((TreeSet)extensionDeclaration.getImportedTypes()).first()).getImportedType();
        MatcherAssert.assertThat((Object)extensionDeclaration.getImportedTypes().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((ClassInformationAnnotation)importedType.getAnnotation(ClassInformationAnnotation.class).get()).getClassname(), (Matcher)Matchers.is((Object)"org.mule.test.heisenberg.extension.model.KnockeableDoor"));
    }
}

