/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import java.util.Arrays;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.test.util.tck.ExtensionModelTestUtils;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.module.extension.internal.loader.java.validation.OperationParametersTypeModelValidator;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class OperationParametersTypeModelValidatorTestCase
extends AbstractMuleTestCase {
    public static final String EXTENSION_NAME = "extension";
    public static final String OPERATION_NAME = "operation";
    @Mock
    private ExtensionModel extensionModel;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private OperationModel operationModel;
    @Mock
    private ParameterModel parameterModel;
    private ExtensionModelValidator validator = new OperationParametersTypeModelValidator();

    @Before
    public void before() {
        Mockito.when((Object)this.operationModel.getName()).thenReturn((Object)OPERATION_NAME);
        Mockito.when((Object)this.parameterModel.getName()).thenReturn((Object)"parameterName");
        Mockito.when((Object)this.extensionModel.getOperationModels()).thenReturn(Arrays.asList(this.operationModel));
        ExtensionsTestUtils.mockParameters((ParameterizedModel)this.operationModel, this.parameterModel);
        ExtensionModelTestUtils.visitableMock((ComponentModel[])new ComponentModel[]{this.operationModel});
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void eventType() {
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)ExtensionsTestUtils.toMetadataType(CoreEvent.class));
        ExtensionsTestUtils.validate(this.extensionModel, this.validator);
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void messageType() {
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)ExtensionsTestUtils.toMetadataType(Message.class));
        ExtensionsTestUtils.validate(this.extensionModel, this.validator);
    }

    @Test
    public void validType() {
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)ExtensionsTestUtils.toMetadataType(Object.class));
        ExtensionsTestUtils.validate(this.extensionModel, this.validator);
    }
}

