/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime;

import com.google.common.collect.ImmutableList;
import io.qameta.allure.Description;
import io.qameta.allure.Issue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.verification.VerificationMode;
import org.mule.functional.junit4.matchers.ThrowableRootCauseMatcher;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.exception.TypedException;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.error.ImmutableErrorModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.api.profiling.ProfilingDataProducer;
import org.mule.runtime.api.profiling.type.context.ComponentThreadingProfilingEventContext;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.ast.internal.error.ErrorTypeBuilder;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.retry.ReconnectionConfig;
import org.mule.runtime.core.api.retry.policy.NoRetryPolicyTemplate;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.api.retry.policy.SimpleRetryPolicyTemplate;
import org.mule.runtime.core.internal.connection.ConnectionManagerAdapter;
import org.mule.runtime.core.internal.connection.ReconnectableConnectionProviderWrapper;
import org.mule.runtime.core.internal.util.rx.ImmediateScheduler;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.error.MuleErrors;
import org.mule.runtime.extension.api.property.ClassLoaderModelProperty;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.config.ConfigurationState;
import org.mule.runtime.extension.api.runtime.operation.CompletableComponentExecutor;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.runtime.operation.Interceptor;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.config.LifecycleAwareConfigurationInstance;
import org.mule.runtime.module.extension.internal.runtime.config.MutableConfigurationStats;
import org.mule.runtime.module.extension.internal.runtime.execution.interceptor.InterceptorChain;
import org.mule.runtime.module.extension.internal.runtime.operation.DefaultExecutionMediator;
import org.mule.runtime.module.extension.internal.runtime.operation.ExecutionMediator;
import org.mule.runtime.module.extension.internal.runtime.operation.ResultTransformer;
import org.mule.runtime.tracer.api.component.ComponentTracer;
import org.mule.sdk.api.exception.ModuleException;
import org.mule.sdk.api.runtime.exception.ExceptionHandler;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.test.heisenberg.extension.HeisenbergErrors;
import org.mule.test.heisenberg.extension.exception.HeisenbergException;
import org.mule.test.heisenberg.extension.exception.NullExceptionEnricher;
import org.mule.test.marvel.drstrange.DrStrangeErrorTypeDefinition;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;
import reactor.core.Exceptions;

@SmallTest
@RunWith(value=Parameterized.class)
public class DefaultExecutionMediatorTestCase
extends AbstractMuleContextTestCase {
    public static final int RETRY_COUNT = 10;
    private static final String DUMMY_NAME = "dummyName";
    private static final String ERROR = "Error";
    @Rule
    public MockitoRule mockito = MockitoJUnit.rule().silent();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExecutionContextAdapter operationContext;
    @Mock(lenient=true)
    private ConfigurationInstance configurationInstance;
    @Mock
    private MutableConfigurationStats configurationStats;
    @Mock(lenient=true)
    private CompletableComponentExecutor operationExecutor;
    @Mock(lenient=true)
    private CompletableComponentExecutor.ExecutorCallback executorCallback;
    @Mock
    private CompletableComponentExecutor operationExceptionExecutor;
    @Mock
    private Interceptor interceptor1;
    @Mock
    private Interceptor interceptor2;
    @Mock
    private ExceptionHandler exceptionEnricher;
    @Mock
    private ConfigurationModel configurationModel;
    @Mock(lenient=true)
    private ExtensionModel extensionModel;
    @Mock
    private OperationModel operationModel;
    @Mock
    private NotificationDispatcher notificationDispatcher;
    @Mock
    private ConnectionManagerAdapter connectionManagerAdapter;
    @Mock
    private ProfilingDataProducer<ComponentThreadingProfilingEventContext, CoreEvent> threadReleaseDataProducer;
    @Mock
    private ComponentTracer<CoreEvent> operationExecutionTracer;
    private final String name;
    private final Object result = new Object();
    private final RetryPolicyTemplate retryPolicy;
    private final ConnectionException connectionException = new ConnectionException("Connection failure");
    private final Exception exception = new Exception();
    private final Exception exceptionWithMessage = new Exception("Error");
    private InOrder inOrder;
    private List<Interceptor> orderedInterceptors;
    private ExecutionMediator mediator;
    private InterceptorChain interceptorChain;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"With simple retry", new SimpleRetryPolicyTemplate(10L, 10)}, {"With no retry", new NoRetryPolicyTemplate()});
    }

    public DefaultExecutionMediatorTestCase(String name, RetryPolicyTemplate retryPolicy) {
        this.name = name;
        this.retryPolicy = retryPolicy;
    }

    @Before
    public void before() throws Exception {
        Mockito.when((Object)this.configurationInstance.getStatistics()).thenReturn((Object)this.configurationStats);
        Mockito.when((Object)this.configurationInstance.getName()).thenReturn((Object)DUMMY_NAME);
        Mockito.when((Object)this.configurationInstance.getModel()).thenReturn((Object)this.configurationModel);
        Mockito.when((Object)this.extensionModel.getName()).thenReturn((Object)DUMMY_NAME);
        Mockito.when((Object)this.extensionModel.getModelProperty(ClassLoaderModelProperty.class)).thenReturn(Optional.empty());
        ExtensionsTestUtils.mockExceptionEnricher((EnrichableModel)this.extensionModel, null);
        ExtensionsTestUtils.mockExceptionEnricher((EnrichableModel)this.operationModel, null);
        MuleTestUtils.stubComponentExecutor((CompletableComponentExecutor)this.operationExecutor, (Object)this.result);
        MuleTestUtils.stubFailingComponentExecutor((CompletableComponentExecutor)this.operationExceptionExecutor, (Throwable)this.exception);
        Mockito.when((Object)this.operationContext.getConfiguration()).thenReturn(Optional.of(this.configurationInstance));
        Mockito.when((Object)this.operationContext.getExtensionModel()).thenReturn((Object)this.extensionModel);
        Mockito.when((Object)this.operationContext.getTransactionConfig()).thenReturn(Optional.empty());
        Mockito.when((Object)this.operationContext.getRetryPolicyTemplate()).thenReturn(Optional.ofNullable(this.retryPolicy));
        Mockito.when((Object)this.operationContext.getCurrentScheduler()).thenReturn((Object)ImmediateScheduler.IMMEDIATE_SCHEDULER);
        Mockito.when((Object)this.operationContext.getMuleContext()).thenReturn((Object)muleContext);
        Mockito.when((Object)this.extensionModel.getXmlDslModel()).thenReturn((Object)XmlDslModel.builder().setPrefix("test-extension").build());
        this.interceptorChain = InterceptorChain.builder().addInterceptor(this.interceptor1).addInterceptor(this.interceptor2).build();
        Mockito.when((Object)this.interceptor1.onError((ExecutionContext)ArgumentMatchers.any(), (Throwable)ArgumentMatchers.any())).thenAnswer(inv -> inv.getArgument(1));
        Mockito.when((Object)this.interceptor2.onError((ExecutionContext)ArgumentMatchers.any(), (Throwable)ArgumentMatchers.any())).thenAnswer(inv -> inv.getArgument(1));
        this.mediator = new DefaultExecutionMediator(this.extensionModel, (ComponentModel)this.operationModel, this.interceptorChain, muleContext.getErrorTypeRepository(), muleContext.getExecutionClassLoader(), muleContext.getConfiguration(), this.notificationDispatcher, muleContext.getTransactionManager(), null, this.threadReleaseDataProducer, this.operationExecutionTracer, true);
        ReconnectableConnectionProviderWrapper connectionProviderWrapper = new ReconnectableConnectionProviderWrapper(null, ReconnectionConfig.defaultReconnectionConfig((boolean)true, (RetryPolicyTemplate)this.retryPolicy));
        LifecycleUtils.initialiseIfNeeded((Object)connectionProviderWrapper, (boolean)true, (MuleContext)muleContext);
        Optional<ReconnectableConnectionProviderWrapper> connectionProvider = Optional.of(connectionProviderWrapper);
        Mockito.when((Object)this.configurationInstance.getConnectionProvider()).thenReturn(connectionProvider);
        Mockito.when((Object)this.exceptionEnricher.enrichException((Exception)ArgumentMatchers.any())).thenAnswer(inv -> {
            Throwable toEnrich = (Throwable)inv.getArgument(0);
            if (toEnrich == this.exception || toEnrich.getCause() == this.exception) {
                return new HeisenbergException(ERROR, toEnrich);
            }
            return toEnrich;
        });
        this.defineOrder(this.interceptor1, this.interceptor2);
    }

    @Test
    public void interceptorsInvokedOnSuccess() throws Throwable {
        Object result = this.execute();
        this.assertBefore();
        this.assertOnSuccess(Mockito.times((int)1));
        this.assertOnError(Mockito.never());
        this.assertResult(result);
    }

    @Test
    public void interceptorsInvokedOnError() throws Throwable {
        this.stubException();
        this.assertException(e -> {
            Assert.assertThat((Object)e, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ConnectionException.class)));
            try {
                this.assertBefore();
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
            this.assertOnSuccess(Mockito.never());
            this.assertOnError(Mockito.times((int)1));
        });
    }

    @Test
    public void decoratedException() throws Throwable {
        this.stubException();
        this.assertException(e -> {
            Assert.assertThat((Object)e, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.connectionException)));
            this.assertAfter(null);
        });
    }

    @Test
    public void exceptionOnBefore() throws Throwable {
        this.stubExceptionOnBeforeInterceptor();
        this.assertException(e -> {
            try {
                Assert.assertThat((Object)e, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.exception)));
                this.assertBefore();
                this.assertOnError(Mockito.never());
                ((CompletableComponentExecutor)Mockito.verify((Object)this.operationExecutor, (VerificationMode)Mockito.never())).execute((ExecutionContext)ArgumentMatchers.same((Object)this.operationContext), (CompletableComponentExecutor.ExecutorCallback)ArgumentMatchers.any());
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        });
    }

    @Test
    public void configurationStatsOnSuccessfulOperation() throws Throwable {
        this.execute();
        this.assertStatistics();
    }

    @Test
    public void configurationStatsOnFailedOperation() throws Throwable {
        this.stubException();
        this.assertException(e -> this.assertStatistics());
    }

    @Test
    public void configurationStatsOnFailedBeforeInterceptor() throws Throwable {
        this.stubExceptionOnBeforeInterceptor();
        this.assertException(e -> this.assertStatistics());
    }

    @Test
    public void enrichThrownException() throws Throwable {
        this.expectedException.expect(CoreMatchers.instanceOf(HeisenbergException.class));
        this.expectedException.expect(ThrowableRootCauseMatcher.hasRootCause((Matcher)CoreMatchers.sameInstance((Object)this.exception)));
        this.expectedException.expectMessage(ERROR);
        ExtensionsTestUtils.mockExceptionEnricher((EnrichableModel)this.operationModel, () -> this.exceptionEnricher);
        MuleTestUtils.stubFailingComponentExecutor((CompletableComponentExecutor)this.operationExecutor, (Throwable)this.exception);
        this.mediator = new DefaultExecutionMediator(this.extensionModel, (ComponentModel)this.operationModel, this.interceptorChain, muleContext.getErrorTypeRepository(), muleContext.getExecutionClassLoader(), muleContext.getConfiguration(), this.notificationDispatcher, muleContext.getTransactionManager(), null, this.threadReleaseDataProducer, this.operationExecutionTracer, true);
        this.execute();
    }

    @Test
    public void notEnrichThrownException() throws Throwable {
        this.expectedException.expect(CoreMatchers.sameInstance((Object)this.exception));
        ExtensionsTestUtils.mockExceptionEnricher((EnrichableModel)this.operationModel, () -> new NullExceptionEnricher());
        MuleTestUtils.stubFailingComponentExecutor((CompletableComponentExecutor)this.operationExecutor, (Throwable)this.exception);
        this.mediator = new DefaultExecutionMediator(this.extensionModel, (ComponentModel)this.operationModel, this.interceptorChain, muleContext.getErrorTypeRepository(), muleContext.getExecutionClassLoader(), muleContext.getConfiguration(), this.notificationDispatcher, muleContext.getTransactionManager(), null, this.threadReleaseDataProducer, this.operationExecutionTracer, true);
        this.execute();
    }

    @Test
    public void enrichThrownExceptionInValueTransformer() throws Throwable {
        RuntimeException exceptionToThrow = new RuntimeException(ERROR, this.exception);
        this.expectedException.expectCause(ThrowableRootCauseMatcher.hasRootCause((Matcher)CoreMatchers.sameInstance((Object)this.exception)));
        this.expectedException.expect(CoreMatchers.instanceOf(HeisenbergException.class));
        this.expectedException.expectMessage(ERROR);
        ExtensionsTestUtils.mockExceptionEnricher((EnrichableModel)this.operationModel, () -> this.exceptionEnricher);
        ResultTransformer failingTransformer = (ResultTransformer)Mockito.mock(ResultTransformer.class);
        Mockito.when((Object)failingTransformer.apply((Object)((ExecutionContextAdapter)ArgumentMatchers.any()), ArgumentMatchers.any())).thenThrow(new Throwable[]{exceptionToThrow});
        this.mediator = new DefaultExecutionMediator(this.extensionModel, (ComponentModel)this.operationModel, this.interceptorChain, muleContext.getErrorTypeRepository(), muleContext.getExecutionClassLoader(), muleContext.getConfiguration(), this.notificationDispatcher, muleContext.getTransactionManager(), failingTransformer, this.threadReleaseDataProducer, this.operationExecutionTracer, true);
        this.execute();
    }

    @Test
    public void enrichThrownSdkModuleExceptionInValueTransformer() throws Throwable {
        ModuleException moduleExceptionToThrow = new ModuleException(ERROR, (org.mule.sdk.api.error.ErrorTypeDefinition)HeisenbergErrors.HEALTH, (Throwable)this.exception);
        this.expectedException.expect(CoreMatchers.instanceOf(HeisenbergException.class));
        this.expectedException.expectCause(CoreMatchers.sameInstance((Object)moduleExceptionToThrow));
        ExtensionsTestUtils.mockExceptionEnricher((EnrichableModel)this.operationModel, () -> this.exceptionEnricher);
        ResultTransformer failingTransformer = (ResultTransformer)Mockito.mock(ResultTransformer.class);
        Mockito.when((Object)failingTransformer.apply((Object)((ExecutionContextAdapter)ArgumentMatchers.any()), ArgumentMatchers.any())).thenThrow(new Throwable[]{moduleExceptionToThrow});
        ErrorTypeRepository errorTypeRepository = this.mockErrorModel();
        this.mediator = new DefaultExecutionMediator(this.extensionModel, (ComponentModel)this.operationModel, this.interceptorChain, errorTypeRepository, muleContext.getExecutionClassLoader(), muleContext.getConfiguration(), this.notificationDispatcher, muleContext.getTransactionManager(), failingTransformer, this.threadReleaseDataProducer, this.operationExecutionTracer, true);
        this.execute();
    }

    @Test
    public void enrichThrownLegacyModuleExceptionInValueTransformer() throws Throwable {
        org.mule.runtime.extension.api.exception.ModuleException moduleExceptionToThrow = new org.mule.runtime.extension.api.exception.ModuleException(ERROR, (ErrorTypeDefinition)DrStrangeErrorTypeDefinition.CUSTOM_ERROR, (Throwable)this.exception);
        this.expectedException.expect(CoreMatchers.instanceOf(HeisenbergException.class));
        this.expectedException.expectCause(CoreMatchers.sameInstance((Object)moduleExceptionToThrow));
        ExtensionsTestUtils.mockExceptionEnricher((EnrichableModel)this.operationModel, () -> this.exceptionEnricher);
        ResultTransformer failingTransformer = (ResultTransformer)Mockito.mock(ResultTransformer.class);
        Mockito.when((Object)failingTransformer.apply((Object)((ExecutionContextAdapter)ArgumentMatchers.any()), ArgumentMatchers.any())).thenThrow(new Throwable[]{moduleExceptionToThrow});
        ErrorTypeRepository errorTypeRepository = this.mockErrorModel();
        this.mediator = new DefaultExecutionMediator(this.extensionModel, (ComponentModel)this.operationModel, this.interceptorChain, errorTypeRepository, muleContext.getExecutionClassLoader(), muleContext.getConfiguration(), this.notificationDispatcher, muleContext.getTransactionManager(), failingTransformer, this.threadReleaseDataProducer, this.operationExecutionTracer, true);
        this.execute();
    }

    @Test
    public void notEnrichThrownExceptionInValueTransformer() throws Throwable {
        RuntimeException exceptionToThrow = new RuntimeException(ERROR, this.exception);
        this.expectedException.expectCause(CoreMatchers.sameInstance((Object)this.exception));
        this.expectedException.expectMessage(ERROR);
        ExtensionsTestUtils.mockExceptionEnricher((EnrichableModel)this.operationModel, () -> new NullExceptionEnricher());
        ResultTransformer failingTransformer = (ResultTransformer)Mockito.mock(ResultTransformer.class);
        Mockito.when((Object)failingTransformer.apply((Object)((ExecutionContextAdapter)ArgumentMatchers.any()), ArgumentMatchers.any())).thenThrow(new Throwable[]{exceptionToThrow});
        this.mediator = new DefaultExecutionMediator(this.extensionModel, (ComponentModel)this.operationModel, this.interceptorChain, muleContext.getErrorTypeRepository(), muleContext.getExecutionClassLoader(), muleContext.getConfiguration(), this.notificationDispatcher, muleContext.getTransactionManager(), failingTransformer, this.threadReleaseDataProducer, this.operationExecutionTracer, true);
        this.execute();
    }

    @Test
    public void notEnrichThrownSdkModuleExceptionInValueTransformer() throws Throwable {
        ModuleException moduleExceptionToThrow = new ModuleException(ERROR, (org.mule.sdk.api.error.ErrorTypeDefinition)HeisenbergErrors.HEALTH, (Throwable)this.exception);
        this.expectedException.expect(CoreMatchers.instanceOf(TypedException.class));
        this.expectedException.expect(ThrowableRootCauseMatcher.hasRootCause((Matcher)CoreMatchers.sameInstance((Object)this.exception)));
        ExtensionsTestUtils.mockExceptionEnricher((EnrichableModel)this.operationModel, NullExceptionEnricher::new);
        ResultTransformer failingTransformer = (ResultTransformer)Mockito.mock(ResultTransformer.class);
        Mockito.when((Object)failingTransformer.apply((Object)((ExecutionContextAdapter)ArgumentMatchers.any()), ArgumentMatchers.any())).thenThrow(new Throwable[]{moduleExceptionToThrow});
        ErrorTypeRepository errorTypeRepository = this.mockErrorModel();
        this.mediator = new DefaultExecutionMediator(this.extensionModel, (ComponentModel)this.operationModel, this.interceptorChain, errorTypeRepository, muleContext.getExecutionClassLoader(), muleContext.getConfiguration(), this.notificationDispatcher, muleContext.getTransactionManager(), failingTransformer, this.threadReleaseDataProducer, this.operationExecutionTracer, true);
        this.execute();
    }

    @Test
    public void notEnrichThrownSdkModuleExceptionWithMessageInValueTransformer() throws Throwable {
        ModuleException moduleExceptionToThrow = new ModuleException(ERROR, (org.mule.sdk.api.error.ErrorTypeDefinition)HeisenbergErrors.HEALTH, (Throwable)this.exceptionWithMessage);
        this.expectedException.expect(CoreMatchers.instanceOf(TypedException.class));
        this.expectedException.expectCause(CoreMatchers.sameInstance((Object)this.exceptionWithMessage));
        ExtensionsTestUtils.mockExceptionEnricher((EnrichableModel)this.operationModel, NullExceptionEnricher::new);
        ResultTransformer failingTransformer = (ResultTransformer)Mockito.mock(ResultTransformer.class);
        Mockito.when((Object)failingTransformer.apply((Object)((ExecutionContextAdapter)ArgumentMatchers.any()), ArgumentMatchers.any())).thenThrow(new Throwable[]{moduleExceptionToThrow});
        ErrorTypeRepository errorTypeRepository = this.mockErrorModel();
        this.mediator = new DefaultExecutionMediator(this.extensionModel, (ComponentModel)this.operationModel, this.interceptorChain, errorTypeRepository, muleContext.getExecutionClassLoader(), muleContext.getConfiguration(), this.notificationDispatcher, muleContext.getTransactionManager(), failingTransformer, this.threadReleaseDataProducer, this.operationExecutionTracer, true);
        this.execute();
    }

    @Test
    public void notEnrichThrownLegacyModuleExceptionInValueTransformer() throws Throwable {
        org.mule.runtime.extension.api.exception.ModuleException moduleExceptionToThrow = new org.mule.runtime.extension.api.exception.ModuleException(ERROR, (ErrorTypeDefinition)DrStrangeErrorTypeDefinition.CUSTOM_ERROR, (Throwable)this.exception);
        this.expectedException.expect(CoreMatchers.instanceOf(TypedException.class));
        this.expectedException.expect(ThrowableRootCauseMatcher.hasRootCause((Matcher)CoreMatchers.sameInstance((Object)this.exception)));
        ExtensionsTestUtils.mockExceptionEnricher((EnrichableModel)this.operationModel, NullExceptionEnricher::new);
        ResultTransformer failingTransformer = (ResultTransformer)Mockito.mock(ResultTransformer.class);
        Mockito.when((Object)failingTransformer.apply((Object)((ExecutionContextAdapter)ArgumentMatchers.any()), ArgumentMatchers.any())).thenThrow(new Throwable[]{moduleExceptionToThrow});
        ErrorTypeRepository errorTypeRepository = this.mockErrorModel();
        this.mediator = new DefaultExecutionMediator(this.extensionModel, (ComponentModel)this.operationModel, this.interceptorChain, errorTypeRepository, muleContext.getExecutionClassLoader(), muleContext.getConfiguration(), this.notificationDispatcher, muleContext.getTransactionManager(), failingTransformer, this.threadReleaseDataProducer, this.operationExecutionTracer, true);
        this.execute();
    }

    @Test
    @Issue(value="MULE-19707")
    public void invalidEnrichment() throws Throwable {
        ResultTransformer failingTransformer = (ResultTransformer)Mockito.mock(ResultTransformer.class);
        org.mule.runtime.extension.api.exception.ModuleException moduleException = new org.mule.runtime.extension.api.exception.ModuleException(ERROR, (ErrorTypeDefinition)TestErrorTypes.UNREGISTERED_ERROR_TYPE);
        this.expectedException.expect(org.mule.runtime.extension.api.exception.ModuleException.class);
        ExtensionsTestUtils.mockExceptionEnricher((EnrichableModel)this.operationModel, () -> this.exceptionEnricher);
        MuleTestUtils.stubFailingComponentExecutor((CompletableComponentExecutor)this.operationExecutor, (Throwable)moduleException);
        this.mediator = new DefaultExecutionMediator(this.extensionModel, (ComponentModel)this.operationModel, this.interceptorChain, muleContext.getErrorTypeRepository(), muleContext.getExecutionClassLoader(), muleContext.getConfiguration(), this.notificationDispatcher, muleContext.getTransactionManager(), failingTransformer, this.threadReleaseDataProducer, this.operationExecutionTracer, true);
        this.execute();
        ((CompletableComponentExecutor.ExecutorCallback)Mockito.verify((Object)this.executorCallback, (VerificationMode)Mockito.times((int)1))).error((Throwable)moduleException);
    }

    @Test
    public void notReconnectInValueTransformerWhenVariableIsSet() {
        int expectedRetries = this.retryPolicy.isEnabled() ? 1 : 0;
        ModuleException moduleExceptionToThrow = new ModuleException(ERROR, (org.mule.sdk.api.error.ErrorTypeDefinition)HeisenbergErrors.CONNECTIVITY, (Throwable)this.connectionException);
        Mockito.when((Object)this.operationContext.getVariable("MULE_DO_NOT_RETRY")).thenReturn((Object)"true");
        Mockito.clearInvocations((Object[])new ExecutionContextAdapter[]{this.operationContext});
        ExtensionsTestUtils.mockExceptionEnricher((EnrichableModel)this.operationModel, NullExceptionEnricher::new);
        ResultTransformer failingTransformer = (ResultTransformer)Mockito.mock(ResultTransformer.class);
        Mockito.when((Object)failingTransformer.apply((Object)((ExecutionContextAdapter)ArgumentMatchers.eq((Object)this.operationContext)), ArgumentMatchers.any())).thenThrow(new Throwable[]{moduleExceptionToThrow});
        this.mediator = new DefaultExecutionMediator(this.extensionModel, (ComponentModel)this.operationModel, this.interceptorChain, this.mockErrorModel(), muleContext.getExecutionClassLoader(), muleContext.getConfiguration(), this.notificationDispatcher, muleContext.getTransactionManager(), failingTransformer, this.threadReleaseDataProducer, this.operationExecutionTracer, true);
        try {
            this.execute();
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ConnectionException.class)));
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"Connection failure"));
            ((ResultTransformer)Mockito.verify((Object)failingTransformer, (VerificationMode)Mockito.times((int)1))).apply((Object)((ExecutionContextAdapter)ArgumentMatchers.any()), ArgumentMatchers.any());
            ((ExecutionContextAdapter)Mockito.verify((Object)this.operationContext, (VerificationMode)Mockito.times((int)expectedRetries))).getVariable("MULE_DO_NOT_RETRY");
        }
    }

    private ErrorTypeRepository mockErrorModel() {
        ErrorType parentErrorType = (ErrorType)Mockito.mock(ErrorType.class);
        ErrorTypeRepository errorTypeRepository = (ErrorTypeRepository)Mockito.mock(ErrorTypeRepository.class);
        Mockito.when((Object)errorTypeRepository.lookupErrorType((ComponentIdentifier)ArgumentMatchers.any())).thenReturn(Optional.of(ErrorTypeBuilder.builder().namespace("testNs").identifier("test").parentErrorType(parentErrorType).build()));
        Mockito.when((Object)this.operationModel.getErrorModels()).thenReturn(Collections.singleton(new ImmutableErrorModel("test", "testNs", true, null)));
        return errorTypeRepository;
    }

    @Test
    public void retry() throws Throwable {
        this.stubException();
        int expectedRetries = this.retryPolicy instanceof SimpleRetryPolicyTemplate ? 11 : 1;
        this.assertException(exception -> {
            Assert.assertThat((Object)exception, (Matcher)CoreMatchers.instanceOf(ConnectionException.class));
            try {
                ((Interceptor)Mockito.verify((Object)this.interceptor1, (VerificationMode)Mockito.times((int)expectedRetries))).before((ExecutionContext)this.operationContext);
                ((Interceptor)Mockito.verify((Object)this.interceptor2, (VerificationMode)Mockito.times((int)expectedRetries))).before((ExecutionContext)this.operationContext);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            ((Interceptor)Mockito.verify((Object)this.interceptor1, (VerificationMode)Mockito.times((int)expectedRetries))).onError((ExecutionContext)ArgumentMatchers.same((Object)this.operationContext), (Throwable)ArgumentMatchers.any());
            ((Interceptor)Mockito.verify((Object)this.interceptor1, (VerificationMode)Mockito.times((int)expectedRetries))).after((ExecutionContext)this.operationContext, null);
            ((Interceptor)Mockito.verify((Object)this.interceptor2, (VerificationMode)Mockito.times((int)expectedRetries))).onError((ExecutionContext)ArgumentMatchers.same((Object)this.operationContext), (Throwable)ArgumentMatchers.any());
            ((Interceptor)Mockito.verify((Object)this.interceptor2, (VerificationMode)Mockito.times((int)expectedRetries))).after((ExecutionContext)this.operationContext, null);
        });
    }

    @Test
    @Description(value="Tests the exception raised when trying to get the statistics from a configuration instance before initializing it is correctly propagated through the executor's error callback")
    @Issue(value="W-10742153")
    public void getStatisticsFromNotInitializedConfigurationInstance() throws Throwable {
        this.expectedException.expect(IllegalStateException.class);
        LifecycleAwareConfigurationInstance configurationInstance = new LifecycleAwareConfigurationInstance("name", (ConfigurationModel)Mockito.mock(ConfigurationModel.class), null, (ConfigurationState)Mockito.mock(ConfigurationState.class), Optional.of((ConnectionProvider)Mockito.mock(ConnectionProvider.class)));
        Mockito.when((Object)this.operationContext.getConfiguration()).thenReturn(Optional.of(configurationInstance));
        this.execute();
    }

    private void assertException(Consumer<Throwable> assertion) throws Throwable {
        try {
            this.execute();
            Assert.fail((String)"was expecting a exception");
        }
        catch (Exception e) {
            assertion.accept(Exceptions.unwrap((Throwable)e));
        }
    }

    private void stubExceptionOnBeforeInterceptor() throws Exception {
        ((Interceptor)Mockito.doThrow((Throwable[])new Throwable[]{this.exception}).when((Object)this.interceptor2)).before((ExecutionContext)this.operationContext);
    }

    private void assertStatistics() {
        ((MutableConfigurationStats)Mockito.verify((Object)this.configurationStats)).addInflightOperation();
        ((MutableConfigurationStats)Mockito.verify((Object)this.configurationStats)).discountInflightOperation();
    }

    private void assertBefore() throws Exception {
        this.verifyInOrder(interceptor -> {
            try {
                interceptor.before((ExecutionContext)this.operationContext);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void assertOnSuccess(VerificationMode verificationMode) {
        this.verifyInOrder(interceptor -> {
            interceptor.onSuccess((ExecutionContext)this.operationContext, this.result);
            interceptor.after((ExecutionContext)this.operationContext, this.result);
        }, verificationMode);
    }

    private void assertOnError(VerificationMode verificationMode) {
        this.verifyInOrder(interceptor -> {
            interceptor.onError((ExecutionContext)ArgumentMatchers.same((Object)this.operationContext), (Throwable)ArgumentMatchers.same((Object)this.connectionException));
            interceptor.after((ExecutionContext)this.operationContext, null);
        }, verificationMode);
    }

    private void assertAfter(Object expected) {
        this.verifyInOrder(interceptor -> interceptor.after((ExecutionContext)this.operationContext, expected));
    }

    private void assertResult(Object result) {
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.result)));
    }

    private void stubException() throws Exception {
        MuleTestUtils.stubFailingComponentExecutor((CompletableComponentExecutor)this.operationExecutor, (Throwable)this.connectionException);
    }

    private void defineOrder(Interceptor ... interceptors) {
        this.inOrder = Mockito.inOrder((Object[])interceptors);
        this.orderedInterceptors = ImmutableList.copyOf((Object[])interceptors);
    }

    private void verifyInOrder(Consumer<Interceptor> consumer) {
        this.verifyInOrder(consumer, Mockito.times((int)1));
    }

    private void verifyInOrder(Consumer<Interceptor> consumer, VerificationMode verificationMode) {
        for (Interceptor interceptor : this.orderedInterceptors) {
            consumer.accept((Interceptor)this.inOrder.verify((Object)interceptor, verificationMode));
        }
    }

    private Object execute() throws Exception {
        Latch latch = new Latch();
        Reference result = new Reference();
        Reference exception = new Reference();
        ((CompletableComponentExecutor.ExecutorCallback)Mockito.doAnswer(invocation -> {
            result.set(invocation.getArgument(0));
            latch.release();
            return null;
        }).when((Object)this.executorCallback)).complete(ArgumentMatchers.any());
        ((CompletableComponentExecutor.ExecutorCallback)Mockito.doAnswer(invocation -> {
            exception.set((Object)((Exception)invocation.getArgument(0)));
            latch.release();
            return null;
        }).when((Object)this.executorCallback)).error((Throwable)ArgumentMatchers.any());
        try {
            this.mediator.execute(this.operationExecutor, this.operationContext, this.executorCallback);
        }
        catch (Throwable e) {
            Assert.fail((String)"Uncaught throwable in execution mediator");
        }
        latch.await(5L, TimeUnit.SECONDS);
        if (exception.get() != null) {
            throw (Exception)exception.get();
        }
        return result.get();
    }

    private static enum TestErrorTypes implements ErrorTypeDefinition<TestErrorTypes>
    {
        UNREGISTERED_ERROR_TYPE;


        public Optional<ErrorTypeDefinition<? extends Enum<?>>> getParent() {
            return Optional.of(MuleErrors.ANY);
        }
    }
}

