/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.metadata.api.annotation.TypeAliasAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.AttributeKeyType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectKeyType;
import org.mule.metadata.api.model.impl.DefaultAnyType;
import org.mule.metadata.api.model.impl.DefaultArrayType;
import org.mule.metadata.api.model.impl.DefaultAttributeFieldType;
import org.mule.metadata.api.model.impl.DefaultAttributeKeyType;
import org.mule.metadata.api.model.impl.DefaultBinaryType;
import org.mule.metadata.api.model.impl.DefaultBooleanType;
import org.mule.metadata.api.model.impl.DefaultDateTimeType;
import org.mule.metadata.api.model.impl.DefaultDateType;
import org.mule.metadata.api.model.impl.DefaultFunctionType;
import org.mule.metadata.api.model.impl.DefaultIntersectionType;
import org.mule.metadata.api.model.impl.DefaultLocalDateTimeType;
import org.mule.metadata.api.model.impl.DefaultLocalTimeType;
import org.mule.metadata.api.model.impl.DefaultNothingType;
import org.mule.metadata.api.model.impl.DefaultNumberType;
import org.mule.metadata.api.model.impl.DefaultObjectFieldType;
import org.mule.metadata.api.model.impl.DefaultObjectKeyType;
import org.mule.metadata.api.model.impl.DefaultObjectType;
import org.mule.metadata.api.model.impl.DefaultPeriodType;
import org.mule.metadata.api.model.impl.DefaultStringType;
import org.mule.metadata.api.model.impl.DefaultTimeType;
import org.mule.metadata.api.model.impl.DefaultTimeZoneType;
import org.mule.metadata.api.model.impl.DefaultTupleType;
import org.mule.metadata.api.model.impl.DefaultTypeParameterType;
import org.mule.metadata.api.model.impl.DefaultUnionType;
import org.mule.runtime.module.extension.internal.loader.java.enricher.MetadataTypeEnricher;

public class MetadataTypeEnricherTestCase {
    MetadataTypeEnricher enricher = new MetadataTypeEnricher();
    Set<TypeAnnotation> annotations = Collections.singleton(new TypeAliasAnnotation("alias"));

    @Test
    public void enrichAnyType() {
        this.verify((MetadataType)new DefaultAnyType(MetadataFormat.JAVA, Collections.emptyMap()));
    }

    @Test
    public void enrichArrayType() {
        this.verify((MetadataType)new DefaultArrayType(() -> new DefaultAnyType(MetadataFormat.JAVA, Collections.emptyMap()), MetadataFormat.JAVA, Collections.emptyMap()));
    }

    @Test
    public void enrichBinaryType() {
        this.verify((MetadataType)new DefaultBinaryType(MetadataFormat.JAVA, Collections.emptyMap()));
    }

    @Test
    public void enrichBooleanType() {
        this.verify((MetadataType)new DefaultBooleanType(MetadataFormat.JAVA, Collections.emptyMap()));
    }

    @Test
    public void enrichDateTimeType() {
        this.verify((MetadataType)new DefaultDateTimeType(MetadataFormat.JAVA, Collections.emptyMap()));
    }

    @Test
    public void enrichDateType() {
        this.verify((MetadataType)new DefaultDateType(MetadataFormat.JAVA, Collections.emptyMap()));
    }

    @Test
    public void enrichNumberType() {
        this.verify((MetadataType)new DefaultNumberType(MetadataFormat.JAVA, Collections.emptyMap()));
    }

    @Test
    public void enrichObjectType() {
        this.verify((MetadataType)new DefaultObjectType(Collections.emptyList(), false, null, MetadataFormat.JAVA, Collections.emptyMap()));
    }

    @Test
    public void enrichStringType() {
        this.verify((MetadataType)new DefaultStringType(MetadataFormat.JAVA, Collections.emptyMap()));
    }

    @Test
    public void enrichTimeType() {
        this.verify((MetadataType)new DefaultTimeType(MetadataFormat.JAVA, Collections.emptyMap()));
    }

    @Test
    public void enrichTupleType() {
        this.verify((MetadataType)new DefaultTupleType(Collections.singletonList(new DefaultAnyType(MetadataFormat.JAVA, Collections.emptyMap())), MetadataFormat.JAVA, Collections.emptyMap()));
    }

    @Test
    public void enrichUnionType() {
        this.verify((MetadataType)new DefaultUnionType(Collections.singletonList(new DefaultAnyType(MetadataFormat.JAVA, Collections.emptyMap())), MetadataFormat.JAVA, Collections.emptyMap()));
    }

    @Test
    public void enrichObjectKeyType() {
        this.verify((MetadataType)new DefaultObjectKeyType(Optional.of(new QName("Name")), Optional.of(Pattern.compile("")), Collections.emptyList(), MetadataFormat.JAVA, Collections.emptyMap()));
    }

    @Test
    public void enrichAttributeKeyType() {
        this.verify((MetadataType)new DefaultAttributeKeyType(Optional.of(new QName("Name")), Optional.of(Pattern.compile("")), MetadataFormat.JAVA, Collections.emptyMap()));
    }

    @Test
    public void enrichAttributeFieldType() {
        this.verify((MetadataType)new DefaultAttributeFieldType((AttributeKeyType)new DefaultAttributeKeyType(Optional.of(new QName("Name")), Optional.of(Pattern.compile("")), MetadataFormat.JAVA, Collections.emptyMap()), (MetadataType)new DefaultAnyType(MetadataFormat.JAVA, Collections.emptyMap()), false, MetadataFormat.JAVA, Collections.emptyMap()));
    }

    @Test
    public void enrichObjectFieldType() {
        this.verify((MetadataType)new DefaultObjectFieldType((ObjectKeyType)new DefaultObjectKeyType(Optional.of(new QName("Name")), Optional.of(Pattern.compile("")), Collections.emptyList(), MetadataFormat.JAVA, Collections.emptyMap()), (MetadataType)new DefaultAnyType(MetadataFormat.JAVA, Collections.emptyMap()), false, false, MetadataFormat.JAVA, Collections.emptyMap()));
    }

    @Test
    public void enrichNothingType() {
        this.verify((MetadataType)new DefaultNothingType(MetadataFormat.JAVA, Collections.emptyMap()));
    }

    @Test
    public void enrichFunctionType() {
        this.verify((MetadataType)new DefaultFunctionType(MetadataFormat.JAVA, Collections.emptyMap(), Optional.empty(), Collections.emptyList()));
    }

    @Test
    public void enrichLocalDateTimeType() {
        this.verify((MetadataType)new DefaultLocalDateTimeType(MetadataFormat.JAVA, Collections.emptyMap()));
    }

    @Test
    public void enrichLocalTimeType() {
        this.verify((MetadataType)new DefaultLocalTimeType(MetadataFormat.JAVA, Collections.emptyMap()));
    }

    @Test
    public void enrichPeriodType() {
        this.verify((MetadataType)new DefaultPeriodType(MetadataFormat.JAVA, Collections.emptyMap()));
    }

    @Test
    public void enrichTimeZoneType() {
        this.verify((MetadataType)new DefaultTimeZoneType(MetadataFormat.JAVA, Collections.emptyMap()));
    }

    @Test
    public void enrichTypeParameterType() {
        this.verify((MetadataType)new DefaultTypeParameterType("Type Name", MetadataFormat.JAVA, Collections.emptyMap()));
    }

    @Test
    public void enrichIntersectionType() {
        this.verify((MetadataType)new DefaultIntersectionType(Collections.singletonList(new DefaultAnyType(MetadataFormat.JAVA, Collections.emptyMap())), MetadataFormat.JAVA, Collections.emptyMap()));
    }

    public void verify(MetadataType type) {
        MetadataType enrichedType = this.enricher.enrich(type, this.annotations);
        MatcherAssert.assertThat((Object)enrichedType.getAnnotation(TypeAliasAnnotation.class).isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((TypeAliasAnnotation)enrichedType.getAnnotation(TypeAliasAnnotation.class).get()).getValue(), (Matcher)Matchers.is((Object)"alias"));
    }
}

