/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.resources.test;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.extension.api.resources.GeneratedResource;
import org.mule.runtime.extension.api.resources.ResourcesGenerator;
import org.mule.runtime.extension.api.resources.spi.GeneratedResourceFactory;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public abstract class ResourcesGeneratorContractTestCase
extends AbstractMuleTestCase {
    protected static final String RESOURCE_PATH = "path";
    protected static final byte[] RESOURCE_CONTENT = "hello world!".getBytes();
    protected ResourcesGenerator generator;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    protected GeneratedResourceFactory resourceFactory;
    @Mock
    protected ExtensionModel extensionModel;
    protected List<GeneratedResourceFactory> resourceFactories;

    @Before
    public void before() {
        Mockito.when((Object)this.resourceFactory.generateResource(this.extensionModel)).thenReturn(Optional.of(new GeneratedResource(RESOURCE_PATH, RESOURCE_CONTENT)));
        this.resourceFactories = Arrays.asList(this.resourceFactory);
        this.generator = this.buildGenerator();
    }

    protected abstract ResourcesGenerator buildGenerator();

    @Test
    public void generate() {
        this.generator.generateFor(this.extensionModel);
        ((GeneratedResourceFactory)Mockito.verify((Object)this.resourceFactory)).generateResource(this.extensionModel);
    }
}

