/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.util;

import io.qameta.allure.Feature;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.SubTypeMapping;
import org.mule.runtime.extension.api.annotation.SubTypesMapping;
import org.mule.runtime.extension.api.annotation.connectivity.ConnectionProviders;
import org.mule.runtime.extension.api.annotation.deprecated.Deprecated;
import org.mule.runtime.extension.api.annotation.notification.NotificationActions;
import org.mule.runtime.module.extension.internal.loader.utils.AnnotationsIntrospectorUtils;
import org.mule.sdk.api.annotation.Export;
import org.mule.sdk.api.annotation.Extension;
import org.mule.sdk.api.annotation.ExternalLib;
import org.mule.sdk.api.annotation.JavaVersionSupport;
import org.mule.sdk.api.annotation.OnException;
import org.mule.sdk.api.annotation.Sources;
import org.mule.sdk.api.annotation.error.ErrorTypes;
import org.mule.sdk.api.meta.Category;
import org.mule.sdk.api.meta.ExternalLibraryType;
import org.mule.sdk.api.meta.JavaVersion;
import org.mule.tck.size.SmallTest;
import org.mule.test.heisenberg.extension.AsyncHeisenbergSource;
import org.mule.test.heisenberg.extension.DEARadioSource;
import org.mule.test.heisenberg.extension.HeisenbergClusterSource;
import org.mule.test.heisenberg.extension.HeisenbergConnectionProvider;
import org.mule.test.heisenberg.extension.HeisenbergErrors;
import org.mule.test.heisenberg.extension.HeisenbergExtension;
import org.mule.test.heisenberg.extension.HeisenbergNotificationAction;
import org.mule.test.heisenberg.extension.HeisenbergOperationLifecycleValidator;
import org.mule.test.heisenberg.extension.HeisenbergOperations;
import org.mule.test.heisenberg.extension.HeisenbergRouters;
import org.mule.test.heisenberg.extension.HeisenbergScopes;
import org.mule.test.heisenberg.extension.HeisenbergSource;
import org.mule.test.heisenberg.extension.HeisenbergSourceAllOptionalCallbacks;
import org.mule.test.heisenberg.extension.IgnoredHeisenbergSource;
import org.mule.test.heisenberg.extension.KillingOperations;
import org.mule.test.heisenberg.extension.MoneyLaunderingOperation;
import org.mule.test.heisenberg.extension.ReconnectableHeisenbergSdkSource;
import org.mule.test.heisenberg.extension.ReconnectableHeisenbergSource;
import org.mule.test.heisenberg.extension.SdkIgnoredHeisenbergSource;
import org.mule.test.heisenberg.extension.SecureHeisenbergConnectionProvider;
import org.mule.test.heisenberg.extension.exception.SdkHeisenbergConnectionExceptionEnricher;
import org.mule.test.heisenberg.extension.model.CarDealer;
import org.mule.test.heisenberg.extension.model.CarWash;
import org.mule.test.heisenberg.extension.model.DifferedKnockableDoor;
import org.mule.test.heisenberg.extension.model.Investment;
import org.mule.test.heisenberg.extension.model.Ricin;
import org.mule.test.heisenberg.extension.model.Weapon;
import org.mule.test.heisenberg.extension.model.drugs.Drug;
import org.mule.test.heisenberg.extension.model.drugs.Meta;

@SmallTest
@Feature(value="SDK")
public class AnnotationIntrospectorUtilsTestCase {
    @Test
    public void testAnnotationsIntrospection() {
        Class<HeisenbergTestAnnotationsExtension> testClass = HeisenbergTestAnnotationsExtension.class;
        Map introspectedAnnotations = AnnotationsIntrospectorUtils.extractAnnotations(testClass);
        Annotation[] expectedAnnotations = testClass.getAnnotations();
        MatcherAssert.assertThat((Object)introspectedAnnotations, (Matcher)Matchers.aMapWithSize((int)expectedAnnotations.length));
        Arrays.stream(expectedAnnotations).forEach(expectedAnnotation -> MatcherAssert.assertThat((Object)((Annotation)introspectedAnnotations.get(expectedAnnotation.annotationType())), (Matcher)Matchers.is((Object)expectedAnnotation)));
    }

    @Extension(name="Heisenberg", category=Category.SELECT)
    @JavaVersionSupport(value={JavaVersion.JAVA_8, JavaVersion.JAVA_11, JavaVersion.JAVA_17})
    @Operations(value={HeisenbergOperations.class, MoneyLaunderingOperation.class, KillingOperations.class, HeisenbergScopes.class, HeisenbergRouters.class, HeisenbergOperationLifecycleValidator.class})
    @OnException(value=SdkHeisenbergConnectionExceptionEnricher.class)
    @ConnectionProviders(value={HeisenbergConnectionProvider.class, SecureHeisenbergConnectionProvider.class})
    @org.mule.runtime.extension.api.annotation.Sources(value={HeisenbergSource.class, HeisenbergSourceAllOptionalCallbacks.class, DEARadioSource.class, AsyncHeisenbergSource.class})
    @Sources(value={ReconnectableHeisenbergSource.class, HeisenbergClusterSource.class, IgnoredHeisenbergSource.class, SdkIgnoredHeisenbergSource.class, ReconnectableHeisenbergSdkSource.class})
    @Export(classes={HeisenbergExtension.class, DifferedKnockableDoor.class, HeisenbergErrors.class}, resources={"methRecipe.json"})
    @SubTypesMapping(value={@SubTypeMapping(baseType=Weapon.class, subTypes={Ricin.class}), @SubTypeMapping(baseType=Drug.class, subTypes={Meta.class}), @SubTypeMapping(baseType=Investment.class, subTypes={CarWash.class, CarDealer.class})})
    @ExternalLib(name="Heisenberg.so", description="Native Heisenberg support", nameRegexpMatcher="heisenberg.so", requiredClassName="org.heisenberg.HeisenbergJNI", type=ExternalLibraryType.NATIVE, coordinates="org.mule.libs:this-is-a-lib:dll:1.0.0")
    @Deprecated(message="This extension has been deprecated because Breaking Bad has ended, use Better Call Saul extension.", since="1.4.0")
    @ErrorTypes(value=HeisenbergErrors.class)
    @NotificationActions(value=HeisenbergNotificationAction.class)
    private static class HeisenbergTestAnnotationsExtension {
        private HeisenbergTestAnnotationsExtension() {
        }
    }
}

