/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Answers;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.StereotypedDeclaration;
import org.mule.runtime.extension.api.annotation.metadata.RequiredForMetadata;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.property.InfrastructureParameterModelProperty;
import org.mule.runtime.extension.api.property.RequiredForMetadataModelProperty;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.internal.loader.java.enricher.RequiredForMetadataDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionParameterDescriptorModelProperty;
import org.mule.tck.junit4.AbstractMuleTestCase;

@RunWith(value=Parameterized.class)
public class RequiredForMetadataDeclarationEnricherTestCase
extends AbstractMuleTestCase {
    private static final String TESTING_CONNECTION_NAME = "CONNECTION";
    private static final String TESTING_CONFIGURATION_NAME = "CONFIGURATION";
    private static final String REQUIRED_PARAM = "RequiredParam";
    private static final String OTHER_REQUIRED_PARAM = "OtherRequiredParam";
    private static final RequiredForMetadataDeclarationEnricher ENRICHER = new RequiredForMetadataDeclarationEnricher();
    private ArgumentCaptor<RequiredForMetadataModelProperty> argumentCaptor = ArgumentCaptor.forClass(RequiredForMetadataModelProperty.class);
    @Parameterized.Parameter
    public String name;
    private StereotypedDeclaration stereotypedDeclaration;
    private ExtensionDeclaration declaration;
    private ExtensionLoadingContext loadingContext;
    private ConnectionProviderDeclaration connectionProviderDeclaration;
    private ConfigurationDeclaration configurationDeclaration;
    private ParameterDeclaration parameterDeclaration;
    private ParameterDeclaration otherParameterDeclaration;
    private ExtensionParameter extensionParameter;
    private ExtensionParameter otherExtensionParameter;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({TESTING_CONNECTION_NAME}, {TESTING_CONFIGURATION_NAME});
    }

    @Before
    public void setUp() {
        this.declaration = (ExtensionDeclaration)Mockito.mock(ExtensionDeclaration.class);
        this.loadingContext = (ExtensionLoadingContext)Mockito.mock(ExtensionLoadingContext.class, (Answer)Answers.RETURNS_DEEP_STUBS);
        this.connectionProviderDeclaration = (ConnectionProviderDeclaration)Mockito.mock(ConnectionProviderDeclaration.class);
        this.configurationDeclaration = (ConfigurationDeclaration)Mockito.mock(ConfigurationDeclaration.class);
        this.parameterDeclaration = (ParameterDeclaration)Mockito.mock(ParameterDeclaration.class);
        this.otherParameterDeclaration = (ParameterDeclaration)Mockito.mock(ParameterDeclaration.class);
        this.extensionParameter = (ExtensionParameter)Mockito.mock(ExtensionParameter.class);
        this.otherExtensionParameter = (ExtensionParameter)Mockito.mock(ExtensionParameter.class);
        Mockito.when((Object)((ExtensionDeclaration)this.loadingContext.getExtensionDeclarer().getDeclaration())).thenReturn((Object)this.declaration);
        Mockito.when((Object)this.declaration.getConnectionProviders()).thenReturn(Collections.singletonList(this.connectionProviderDeclaration));
        Mockito.when((Object)this.declaration.getConfigurations()).thenReturn(Collections.singletonList(this.configurationDeclaration));
        ExtensionParameterDescriptorModelProperty descriptorModelProperty = (ExtensionParameterDescriptorModelProperty)Mockito.mock(ExtensionParameterDescriptorModelProperty.class);
        Mockito.when((Object)this.parameterDeclaration.getModelProperty(ExtensionParameterDescriptorModelProperty.class)).thenReturn(Optional.of(descriptorModelProperty));
        Mockito.when((Object)this.parameterDeclaration.getName()).thenReturn((Object)REQUIRED_PARAM);
        Mockito.when((Object)descriptorModelProperty.getExtensionParameter()).thenReturn((Object)this.extensionParameter);
        ExtensionParameterDescriptorModelProperty otherDescriptorModelProperty = (ExtensionParameterDescriptorModelProperty)Mockito.mock(ExtensionParameterDescriptorModelProperty.class);
        Mockito.when((Object)this.otherParameterDeclaration.getModelProperty(ExtensionParameterDescriptorModelProperty.class)).thenReturn(Optional.of(otherDescriptorModelProperty));
        Mockito.when((Object)this.otherParameterDeclaration.getName()).thenReturn((Object)OTHER_REQUIRED_PARAM);
        Mockito.when((Object)otherDescriptorModelProperty.getExtensionParameter()).thenReturn((Object)this.otherExtensionParameter);
        if (TESTING_CONFIGURATION_NAME.equals(this.name)) {
            this.stereotypedDeclaration = this.configurationDeclaration;
        } else if (TESTING_CONNECTION_NAME.equals(this.name)) {
            this.stereotypedDeclaration = this.connectionProviderDeclaration;
        }
    }

    @Test
    public void infrastructureParametersAreNotIncludedWhenEnrichingWithRequiredForMetadata() {
        this.defineAsRequiredForMetadata(this.extensionParameter);
        this.defineAsInfrastructureParameter(this.otherParameterDeclaration);
        this.enrichDeclaration();
        ((StereotypedDeclaration)Mockito.verify((Object)this.stereotypedDeclaration)).addModelProperty((ModelProperty)this.argumentCaptor.capture());
        RequiredForMetadataModelProperty value = (RequiredForMetadataModelProperty)this.argumentCaptor.getValue();
        MatcherAssert.assertThat((Object)value.getRequiredParameters(), (Matcher)IsCollectionContaining.hasItem((Object)REQUIRED_PARAM));
        MatcherAssert.assertThat((Object)value.getRequiredParameters(), (Matcher)CoreMatchers.not((Matcher)IsCollectionContaining.hasItem((Object)OTHER_REQUIRED_PARAM)));
    }

    @Test
    public void ifNoParameterIsAnnotatedThenAllAreRequiredForMetadata() {
        this.enrichDeclaration();
        ((StereotypedDeclaration)Mockito.verify((Object)this.stereotypedDeclaration)).addModelProperty((ModelProperty)this.argumentCaptor.capture());
        RequiredForMetadataModelProperty value = (RequiredForMetadataModelProperty)this.argumentCaptor.getValue();
        MatcherAssert.assertThat((Object)value.getRequiredParameters(), (Matcher)IsCollectionContaining.hasItem((Object)REQUIRED_PARAM));
        MatcherAssert.assertThat((Object)value.getRequiredParameters(), (Matcher)IsCollectionContaining.hasItem((Object)OTHER_REQUIRED_PARAM));
    }

    @Test
    public void ifNoParameterIsAnnotatedThenNonInfrastructureParametersAreRequiredForMetadata() {
        this.defineAsInfrastructureParameter(this.parameterDeclaration);
        this.enrichDeclaration();
        ((StereotypedDeclaration)Mockito.verify((Object)this.stereotypedDeclaration)).addModelProperty((ModelProperty)this.argumentCaptor.capture());
        RequiredForMetadataModelProperty value = (RequiredForMetadataModelProperty)this.argumentCaptor.getValue();
        MatcherAssert.assertThat((Object)value.getRequiredParameters(), (Matcher)CoreMatchers.not((Matcher)IsCollectionContaining.hasItem((Object)REQUIRED_PARAM)));
        MatcherAssert.assertThat((Object)value.getRequiredParameters(), (Matcher)IsCollectionContaining.hasItem((Object)OTHER_REQUIRED_PARAM));
    }

    @Test
    public void requiredForMetadataParameterGetsEnriched() {
        this.defineAsRequiredForMetadata(this.extensionParameter);
        this.enrichDeclaration();
        ((StereotypedDeclaration)Mockito.verify((Object)this.stereotypedDeclaration)).addModelProperty((ModelProperty)this.argumentCaptor.capture());
        RequiredForMetadataModelProperty value = (RequiredForMetadataModelProperty)this.argumentCaptor.getValue();
        MatcherAssert.assertThat((Object)value.getRequiredParameters(), (Matcher)IsCollectionContaining.hasItem((Object)REQUIRED_PARAM));
        MatcherAssert.assertThat((Object)value.getRequiredParameters(), (Matcher)CoreMatchers.not((Matcher)IsCollectionContaining.hasItem((Object)OTHER_REQUIRED_PARAM)));
    }

    private void defineAsRequiredForMetadata(ExtensionParameter extensionParameter) {
        Mockito.when((Object)extensionParameter.isAnnotatedWith(RequiredForMetadata.class)).thenReturn((Object)true);
    }

    private void defineAsInfrastructureParameter(ParameterDeclaration parameterDeclaration) {
        InfrastructureParameterModelProperty infrastructureParameterModelProperty = (InfrastructureParameterModelProperty)Mockito.mock(InfrastructureParameterModelProperty.class);
        Mockito.when((Object)parameterDeclaration.getModelProperty(InfrastructureParameterModelProperty.class)).thenReturn(Optional.of(infrastructureParameterModelProperty));
    }

    private void enrichDeclaration() {
        ArrayList<ParameterDeclaration> params = new ArrayList<ParameterDeclaration>();
        params.add(this.parameterDeclaration);
        params.add(this.otherParameterDeclaration);
        Mockito.when((Object)this.stereotypedDeclaration.getAllParameters()).thenReturn(params);
        ENRICHER.enrich(this.loadingContext);
    }
}

