/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.manager;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.module.extension.internal.manager.CompositeArtifactExtensionManager;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class CompositeArtifactExtensionManagerTestCase
extends AbstractMuleTestCase {
    public static final String PROVIDER_NAME = "providerName";
    @Mock(lenient=true)
    private ExtensionManager parentExtensionManager;
    @Mock(extraInterfaces={Lifecycle.class})
    private ExtensionManager childExtensionManager;
    @Mock
    private OperationModel operationModel;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void providesComposedExtensions() throws Exception {
        ExtensionModel parentExtension = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        Set<ExtensionModel> parentExtensions = Collections.singleton(parentExtension);
        Mockito.when((Object)this.parentExtensionManager.getExtensions()).thenReturn(parentExtensions);
        ExtensionModel childExtension = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        Set<ExtensionModel> childExtensions = Collections.singleton(childExtension);
        Mockito.when((Object)this.childExtensionManager.getExtensions()).thenReturn(childExtensions);
        CompositeArtifactExtensionManager extensionManager = new CompositeArtifactExtensionManager(this.parentExtensionManager, this.childExtensionManager);
        Set extensions = extensionManager.getExtensions();
        MatcherAssert.assertThat((Object)extensions.size(), (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)extensions, (Matcher)Matchers.hasItem((Object)parentExtension));
        MatcherAssert.assertThat((Object)extensions, (Matcher)Matchers.hasItem((Object)childExtension));
    }

    @Test
    public void providesRegisteredExtension() throws Exception {
        ExtensionModel parentExtension = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        Mockito.when((Object)parentExtension.getName()).thenReturn((Object)"testExtension");
        Set<ExtensionModel> parentExtensions = Collections.singleton(parentExtension);
        Mockito.when((Object)this.parentExtensionManager.getExtensions()).thenReturn(parentExtensions);
        CompositeArtifactExtensionManager extensionManager = new CompositeArtifactExtensionManager(this.parentExtensionManager, this.childExtensionManager);
        Optional extension = extensionManager.getExtension("testExtension");
        MatcherAssert.assertThat((Object)((ExtensionModel)extension.get()), (Matcher)Matchers.is((Object)parentExtension));
    }

    @Test
    public void returnsEmptyExtensionWhenNonRegistered() throws Exception {
        ExtensionModel parentExtension = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        Mockito.when((Object)parentExtension.getName()).thenReturn((Object)"testExtension");
        Set<ExtensionModel> parentExtensions = Collections.singleton(parentExtension);
        Mockito.when((Object)this.parentExtensionManager.getExtensions()).thenReturn(parentExtensions);
        CompositeArtifactExtensionManager extensionManager = new CompositeArtifactExtensionManager(this.parentExtensionManager, this.childExtensionManager);
        Optional extension = extensionManager.getExtension("fooExtension");
        MatcherAssert.assertThat((Object)extension.isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void returnsChildConfigurationProviderFromModel() throws Exception {
        ExtensionModel childExtension = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        Set<ExtensionModel> childExtensions = Collections.singleton(childExtension);
        Mockito.when((Object)this.childExtensionManager.getExtensions()).thenReturn(childExtensions);
        Mockito.when((Object)this.parentExtensionManager.getExtensions()).thenReturn(Collections.emptySet());
        CompositeArtifactExtensionManager extensionManager = new CompositeArtifactExtensionManager(this.parentExtensionManager, this.childExtensionManager);
        ConfigurationProvider childConfigurationProvider = (ConfigurationProvider)Mockito.mock(ConfigurationProvider.class);
        Mockito.when((Object)this.childExtensionManager.getConfigurationProvider(childExtension, (ComponentModel)this.operationModel)).thenReturn(Optional.of(childConfigurationProvider));
        Mockito.when((Object)this.parentExtensionManager.getConfigurationProvider(childExtension, (ComponentModel)this.operationModel)).thenReturn(Optional.empty());
        Optional configurationProvider = extensionManager.getConfigurationProvider(childExtension, (ComponentModel)this.operationModel);
        MatcherAssert.assertThat((Object)((ConfigurationProvider)configurationProvider.get()), (Matcher)Matchers.is((Object)childConfigurationProvider));
    }

    @Test
    public void returnsParentConfigurationProviderFromModel() throws Exception {
        ExtensionModel parentExtension = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        Set<ExtensionModel> parentExtensions = Collections.singleton(parentExtension);
        Mockito.when((Object)this.parentExtensionManager.getExtensions()).thenReturn(parentExtensions);
        Mockito.when((Object)this.childExtensionManager.getExtensions()).thenReturn(Collections.emptySet());
        CompositeArtifactExtensionManager extensionManager = new CompositeArtifactExtensionManager(this.parentExtensionManager, this.childExtensionManager);
        ConfigurationProvider parentConfigurationProvider = (ConfigurationProvider)Mockito.mock(ConfigurationProvider.class);
        Mockito.when((Object)this.parentExtensionManager.getConfigurationProvider(parentExtension, (ComponentModel)this.operationModel)).thenReturn(Optional.of(parentConfigurationProvider));
        Mockito.when((Object)this.childExtensionManager.getConfigurationProvider(parentExtension, (ComponentModel)this.operationModel)).thenReturn(Optional.empty());
        Optional configurationProvider = extensionManager.getConfigurationProvider(parentExtension, (ComponentModel)this.operationModel);
        MatcherAssert.assertThat((Object)((ConfigurationProvider)configurationProvider.get()), (Matcher)Matchers.is((Object)parentConfigurationProvider));
    }

    @Test
    public void returnsChildConfigurationProviderFromProviderName() throws Exception {
        ExtensionModel childExtension = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        Set<ExtensionModel> childExtensions = Collections.singleton(childExtension);
        Mockito.when((Object)this.childExtensionManager.getExtensions()).thenReturn(childExtensions);
        Mockito.when((Object)this.parentExtensionManager.getExtensions()).thenReturn(Collections.emptySet());
        CompositeArtifactExtensionManager extensionManager = new CompositeArtifactExtensionManager(this.parentExtensionManager, this.childExtensionManager);
        ConfigurationProvider childConfigurationProvider = (ConfigurationProvider)Mockito.mock(ConfigurationProvider.class);
        Mockito.when((Object)this.childExtensionManager.getConfigurationProvider(PROVIDER_NAME)).thenReturn(Optional.of(childConfigurationProvider));
        Mockito.when((Object)this.parentExtensionManager.getConfigurationProvider(PROVIDER_NAME)).thenReturn(Optional.empty());
        Optional configurationProvider = extensionManager.getConfigurationProvider(PROVIDER_NAME);
        MatcherAssert.assertThat((Object)((ConfigurationProvider)configurationProvider.get()), (Matcher)Matchers.is((Object)childConfigurationProvider));
    }

    @Test
    public void returnsParentConfigurationProviderFromProviderName() throws Exception {
        ExtensionModel parentExtension = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        Set<ExtensionModel> parentExtensions = Collections.singleton(parentExtension);
        Mockito.when((Object)this.parentExtensionManager.getExtensions()).thenReturn(parentExtensions);
        Mockito.when((Object)this.childExtensionManager.getExtensions()).thenReturn(Collections.emptySet());
        CompositeArtifactExtensionManager extensionManager = new CompositeArtifactExtensionManager(this.parentExtensionManager, this.childExtensionManager);
        ConfigurationProvider parentConfigurationProvider = (ConfigurationProvider)Mockito.mock(ConfigurationProvider.class);
        Mockito.when((Object)this.parentExtensionManager.getConfigurationProvider(PROVIDER_NAME)).thenReturn(Optional.of(parentConfigurationProvider));
        Mockito.when((Object)this.childExtensionManager.getConfigurationProvider(PROVIDER_NAME)).thenReturn(Optional.empty());
        Optional configurationProvider = extensionManager.getConfigurationProvider(PROVIDER_NAME);
        MatcherAssert.assertThat((Object)((ConfigurationProvider)configurationProvider.get()), (Matcher)Matchers.is((Object)parentConfigurationProvider));
    }

    @Test
    public void returnsConfigurationFromProviderName() throws Exception {
        ExtensionModel childExtension = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        Set<ExtensionModel> childExtensions = Collections.singleton(childExtension);
        Mockito.when((Object)this.childExtensionManager.getExtensions()).thenReturn(childExtensions);
        Mockito.when((Object)this.parentExtensionManager.getExtensions()).thenReturn(Collections.emptySet());
        CompositeArtifactExtensionManager extensionManager = new CompositeArtifactExtensionManager(this.parentExtensionManager, this.childExtensionManager);
        CoreEvent event = (CoreEvent)Mockito.mock(CoreEvent.class);
        ConfigurationProvider childConfigurationProvider = (ConfigurationProvider)Mockito.mock(ConfigurationProvider.class);
        ConfigurationInstance configurationInstance = (ConfigurationInstance)Mockito.mock(ConfigurationInstance.class);
        Mockito.when((Object)childConfigurationProvider.get((Event)event)).thenReturn((Object)configurationInstance);
        Mockito.when((Object)this.childExtensionManager.getConfigurationProvider(PROVIDER_NAME)).thenReturn(Optional.of(childConfigurationProvider));
        Mockito.when((Object)this.parentExtensionManager.getConfigurationProvider(PROVIDER_NAME)).thenReturn(Optional.empty());
        ConfigurationInstance configuration = extensionManager.getConfiguration(PROVIDER_NAME, event);
        MatcherAssert.assertThat((Object)configuration, (Matcher)Matchers.is((Object)configurationInstance));
    }

    @Test
    public void failsToObtainMissingConfigurationFromProviderName() throws Exception {
        ExtensionModel childExtension = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        Set<ExtensionModel> childExtensions = Collections.singleton(childExtension);
        Mockito.when((Object)this.childExtensionManager.getExtensions()).thenReturn(childExtensions);
        Mockito.when((Object)this.parentExtensionManager.getExtensions()).thenReturn(Collections.emptySet());
        CompositeArtifactExtensionManager extensionManager = new CompositeArtifactExtensionManager(this.parentExtensionManager, this.childExtensionManager);
        CoreEvent event = (CoreEvent)Mockito.mock(CoreEvent.class);
        ConfigurationProvider childConfigurationProvider = (ConfigurationProvider)Mockito.mock(ConfigurationProvider.class);
        ConfigurationInstance configurationInstance = (ConfigurationInstance)Mockito.mock(ConfigurationInstance.class);
        Mockito.when((Object)childConfigurationProvider.get((Event)event)).thenReturn((Object)configurationInstance);
        Mockito.when((Object)this.childExtensionManager.getConfigurationProvider(PROVIDER_NAME)).thenReturn(Optional.empty());
        Mockito.when((Object)this.parentExtensionManager.getConfigurationProvider(PROVIDER_NAME)).thenReturn(Optional.empty());
        this.expectedException.expect(IllegalArgumentException.class);
        extensionManager.getConfiguration(PROVIDER_NAME, event);
    }

    @Test
    public void returnsConfigurationFromModel() throws Exception {
        ExtensionModel childExtension = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        Set<ExtensionModel> childExtensions = Collections.singleton(childExtension);
        Mockito.when((Object)this.childExtensionManager.getExtensions()).thenReturn(childExtensions);
        Mockito.when((Object)this.parentExtensionManager.getExtensions()).thenReturn(Collections.emptySet());
        CompositeArtifactExtensionManager extensionManager = new CompositeArtifactExtensionManager(this.parentExtensionManager, this.childExtensionManager);
        CoreEvent event = (CoreEvent)Mockito.mock(CoreEvent.class);
        ConfigurationProvider childConfigurationProvider = (ConfigurationProvider)Mockito.mock(ConfigurationProvider.class);
        ConfigurationInstance configurationInstance = (ConfigurationInstance)Mockito.mock(ConfigurationInstance.class);
        Mockito.when((Object)childConfigurationProvider.get((Event)event)).thenReturn((Object)configurationInstance);
        Mockito.when((Object)this.childExtensionManager.getConfigurationProvider(childExtension, (ComponentModel)this.operationModel, event)).thenReturn(Optional.of(childConfigurationProvider));
        Mockito.when((Object)this.parentExtensionManager.getConfigurationProvider(childExtension, (ComponentModel)this.operationModel)).thenReturn(Optional.empty());
        Optional configuration = extensionManager.getConfiguration(childExtension, (ComponentModel)this.operationModel, event);
        MatcherAssert.assertThat((Object)configuration.isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((ConfigurationInstance)configuration.get()), (Matcher)Matchers.is((Object)configurationInstance));
    }

    @Test
    public void failsToObtainMissingConfigurationFromModel() throws Exception {
        ExtensionModel childExtension = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        Set<ExtensionModel> childExtensions = Collections.singleton(childExtension);
        Mockito.when((Object)this.childExtensionManager.getExtensions()).thenReturn(childExtensions);
        Mockito.when((Object)this.parentExtensionManager.getExtensions()).thenReturn(Collections.emptySet());
        CompositeArtifactExtensionManager extensionManager = new CompositeArtifactExtensionManager(this.parentExtensionManager, this.childExtensionManager);
        CoreEvent event = (CoreEvent)Mockito.mock(CoreEvent.class);
        Mockito.when((Object)this.childExtensionManager.getConfiguration(childExtension, (ComponentModel)this.operationModel, event)).thenReturn(Optional.empty());
        Mockito.when((Object)this.childExtensionManager.getConfigurationProvider(childExtension, (ComponentModel)this.operationModel)).thenReturn(Optional.empty());
        Mockito.when((Object)this.parentExtensionManager.getConfigurationProvider(childExtension, (ComponentModel)this.operationModel)).thenReturn(Optional.empty());
        this.expectedException.expect(IllegalArgumentException.class);
        extensionManager.getConfiguration(childExtension, (ComponentModel)this.operationModel, event);
    }

    @Test
    public void doesNotRegisterExtension() throws Exception {
        CompositeArtifactExtensionManager extensionManager = new CompositeArtifactExtensionManager(this.parentExtensionManager, this.childExtensionManager);
        this.expectedException.expect(UnsupportedOperationException.class);
        extensionManager.registerExtension((ExtensionModel)Mockito.mock(ExtensionModel.class));
    }

    @Test
    public void doesNotRegisterConfigurationProviders() throws Exception {
        CompositeArtifactExtensionManager extensionManager = new CompositeArtifactExtensionManager(this.parentExtensionManager, this.childExtensionManager);
        this.expectedException.expect(UnsupportedOperationException.class);
        extensionManager.registerConfigurationProvider((ConfigurationProvider)Mockito.mock(ConfigurationProvider.class));
    }

    @Test
    public void initialise() throws InitialisationException {
        CompositeArtifactExtensionManager extensionManager = new CompositeArtifactExtensionManager(this.parentExtensionManager, this.childExtensionManager);
        extensionManager.initialise();
        ((Initialisable)Mockito.verify((Object)((Initialisable)this.childExtensionManager))).initialise();
    }

    @Test
    public void start() throws MuleException {
        CompositeArtifactExtensionManager extensionManager = new CompositeArtifactExtensionManager(this.parentExtensionManager, this.childExtensionManager);
        extensionManager.start();
        ((Startable)Mockito.verify((Object)((Startable)this.childExtensionManager))).start();
    }

    @Test
    public void stop() throws MuleException {
        CompositeArtifactExtensionManager extensionManager = new CompositeArtifactExtensionManager(this.parentExtensionManager, this.childExtensionManager);
        extensionManager.stop();
        ((Stoppable)Mockito.verify((Object)((Stoppable)this.childExtensionManager))).stop();
    }

    @Test
    public void dispose() throws MuleException {
        CompositeArtifactExtensionManager extensionManager = new CompositeArtifactExtensionManager(this.parentExtensionManager, this.childExtensionManager);
        extensionManager.dispose();
        ((Disposable)Mockito.verify((Object)((Disposable)this.childExtensionManager))).dispose();
    }
}

