/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.module.extension.internal.loader.java.validation.NullSafeModelValidator;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class NullSafeModelValidatorTestCase
extends AbstractMuleTestCase {
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExtensionModel extensionModel;
    @Mock(lenient=true)
    private OperationModel operationModel;
    @Mock(lenient=true)
    private ParameterModel parameterModel;
    private ExtensionModelValidator validator = new NullSafeModelValidator();

    @Before
    public void before() {
        Mockito.when((Object)this.extensionModel.getOperationModels()).thenReturn(Arrays.asList(this.operationModel));
        ExtensionsTestUtils.mockParameters((ParameterizedModel)this.operationModel, this.parameterModel);
        Mockito.when((Object)this.extensionModel.getImportedTypes()).thenReturn(Collections.emptySet());
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void collectionWithImplementingTypeUsingSdkApi() {
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)ExtensionsTestUtils.toMetadataType(CollectionWithDefaultImplementingTypeUsingSdkApi.class));
        ExtensionsTestUtils.validate(this.extensionModel, this.validator);
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void dictionaryWithImplementingTypeUsingSdkApi() {
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)ExtensionsTestUtils.toMetadataType(DictionaryWithDefaultImplementingTypeUsingSdkApi.class));
        ExtensionsTestUtils.validate(this.extensionModel, this.validator);
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void implementingTypeIsNotAssignableUsingSdkApi() {
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)ExtensionsTestUtils.toMetadataType(ImplementingTypeNotAssignableUsingSdkApi.class));
        ExtensionsTestUtils.validate(this.extensionModel, this.validator);
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void basicTypeFieldUsingSdkApi() {
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)ExtensionsTestUtils.toMetadataType(BasicTypeWithNullSafeUsingSdkApi.class));
        ExtensionsTestUtils.validate(this.extensionModel, this.validator);
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void abstractFieldTypeUsingSdkApi() {
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)ExtensionsTestUtils.toMetadataType(AbstractNullSafeTypeWithoutOverrideUsingSdkApi.class));
        ExtensionsTestUtils.validate(this.extensionModel, this.validator);
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void abstractImplementingTypeUsingSdkApi() {
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)ExtensionsTestUtils.toMetadataType(AbstractNullSafeTypeWithAbstractOverrideUsingSdkApi.class));
        ExtensionsTestUtils.validate(this.extensionModel, this.validator);
    }

    @Test
    public void validModelUsingSdkApi() {
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)ExtensionsTestUtils.toMetadataType(ValidModelUsingSdkApi.class));
        ExtensionsTestUtils.validate(this.extensionModel, this.validator);
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void collectionWithImplementingTypeUsingLegacyApi() {
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)ExtensionsTestUtils.toMetadataType(CollectionWithDefaultImplementingTypeUsingLegacyApi.class));
        ExtensionsTestUtils.validate(this.extensionModel, this.validator);
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void dictionaryWithImplementingTypeUsingLegacyApi() {
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)ExtensionsTestUtils.toMetadataType(DictionaryWithDefaultImplementingTypeUsingLegacyApi.class));
        ExtensionsTestUtils.validate(this.extensionModel, this.validator);
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void implementingTypeIsNotAssignableUsingLegacyApi() {
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)ExtensionsTestUtils.toMetadataType(ImplementingTypeNotAssignableUsingLegacyApi.class));
        ExtensionsTestUtils.validate(this.extensionModel, this.validator);
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void basicTypeFieldUsingLegacyApi() {
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)ExtensionsTestUtils.toMetadataType(BasicTypeWithNullSafeUsingLegacyApi.class));
        ExtensionsTestUtils.validate(this.extensionModel, this.validator);
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void abstractFieldTypeUsingLegacyApi() {
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)ExtensionsTestUtils.toMetadataType(AbstractNullSafeTypeWithoutOverrideUsingLegacyApi.class));
        ExtensionsTestUtils.validate(this.extensionModel, this.validator);
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void abstractImplementingTypeUsingLegacyApi() {
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)ExtensionsTestUtils.toMetadataType(AbstractNullSafeTypeWithAbstractOverrideUsingLegacyApi.class));
        ExtensionsTestUtils.validate(this.extensionModel, this.validator);
    }

    @Test
    public void validModeUsingLegacyApi() {
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)ExtensionsTestUtils.toMetadataType(ValidModelUsingLegacyApi.class));
        ExtensionsTestUtils.validate(this.extensionModel, this.validator);
    }

    private static abstract class AbstractChildPojo
    extends ParentPojo {
        private AbstractChildPojo() {
        }
    }

    private static class ChildPojo
    extends ParentPojo {
    }

    private static class UnrelatedPojo {
        private UnrelatedPojo() {
        }
    }

    private static abstract class ParentPojo {
        private ParentPojo() {
        }
    }

    private static class ValidModelUsingLegacyApi {
        @Parameter
        @NullSafe(defaultImplementingType=ChildPojo.class)
        @Optional
        private ParentPojo pojo;
        @Parameter
        @NullSafe
        @Optional
        private ChildPojo childPojo;
        @Parameter
        @NullSafe
        @Optional
        private Map<String, String> mapOfStrings;
        @Parameter
        @NullSafe
        @Optional
        private List<String> listOfStrings;

        private ValidModelUsingLegacyApi() {
        }
    }

    private static class AbstractNullSafeTypeWithAbstractOverrideUsingLegacyApi {
        @Parameter
        @NullSafe(defaultImplementingType=AbstractChildPojo.class)
        @Optional
        private ParentPojo pojo;

        private AbstractNullSafeTypeWithAbstractOverrideUsingLegacyApi() {
        }
    }

    private static class AbstractNullSafeTypeWithoutOverrideUsingLegacyApi {
        @Parameter
        @NullSafe
        @Optional
        private ParentPojo pojo;

        private AbstractNullSafeTypeWithoutOverrideUsingLegacyApi() {
        }
    }

    private static class ImplementingTypeNotAssignableUsingLegacyApi {
        @Parameter
        @NullSafe(defaultImplementingType=UnrelatedPojo.class)
        @Optional
        private ParentPojo pojo;

        private ImplementingTypeNotAssignableUsingLegacyApi() {
        }
    }

    private static class BasicTypeWithNullSafeUsingLegacyApi {
        @Parameter
        @NullSafe
        @Optional
        private String bla;

        private BasicTypeWithNullSafeUsingLegacyApi() {
        }
    }

    private static class DictionaryWithDefaultImplementingTypeUsingLegacyApi {
        @Parameter
        @NullSafe(defaultImplementingType=LinkedList.class)
        @Optional
        private Map<String, String> strings;

        private DictionaryWithDefaultImplementingTypeUsingLegacyApi() {
        }
    }

    private static class CollectionWithDefaultImplementingTypeUsingLegacyApi {
        @Parameter
        @NullSafe(defaultImplementingType=LinkedList.class)
        @Optional
        private List<String> strings;

        private CollectionWithDefaultImplementingTypeUsingLegacyApi() {
        }
    }

    private static class ValidModelUsingSdkApi {
        @Parameter
        @org.mule.sdk.api.annotation.param.NullSafe(defaultImplementingType=ChildPojo.class)
        @Optional
        private ParentPojo pojo;
        @Parameter
        @org.mule.sdk.api.annotation.param.NullSafe
        @Optional
        private ChildPojo childPojo;
        @Parameter
        @org.mule.sdk.api.annotation.param.NullSafe
        @Optional
        private Map<String, String> mapOfStrings;
        @Parameter
        @org.mule.sdk.api.annotation.param.NullSafe
        @Optional
        private List<String> listOfStrings;

        private ValidModelUsingSdkApi() {
        }
    }

    private static class AbstractNullSafeTypeWithAbstractOverrideUsingSdkApi {
        @Parameter
        @org.mule.sdk.api.annotation.param.NullSafe(defaultImplementingType=AbstractChildPojo.class)
        @Optional
        private ParentPojo pojo;

        private AbstractNullSafeTypeWithAbstractOverrideUsingSdkApi() {
        }
    }

    private static class AbstractNullSafeTypeWithoutOverrideUsingSdkApi {
        @Parameter
        @org.mule.sdk.api.annotation.param.NullSafe
        @Optional
        private ParentPojo pojo;

        private AbstractNullSafeTypeWithoutOverrideUsingSdkApi() {
        }
    }

    private static class ImplementingTypeNotAssignableUsingSdkApi {
        @Parameter
        @org.mule.sdk.api.annotation.param.NullSafe(defaultImplementingType=UnrelatedPojo.class)
        @Optional
        private ParentPojo pojo;

        private ImplementingTypeNotAssignableUsingSdkApi() {
        }
    }

    private static class BasicTypeWithNullSafeUsingSdkApi {
        @Parameter
        @org.mule.sdk.api.annotation.param.NullSafe
        @Optional
        private String bla;

        private BasicTypeWithNullSafeUsingSdkApi() {
        }
    }

    private static class DictionaryWithDefaultImplementingTypeUsingSdkApi {
        @Parameter
        @org.mule.sdk.api.annotation.param.NullSafe(defaultImplementingType=LinkedList.class)
        @Optional
        private Map<String, String> strings;

        private DictionaryWithDefaultImplementingTypeUsingSdkApi() {
        }
    }

    private static class CollectionWithDefaultImplementingTypeUsingSdkApi {
        @Parameter
        @org.mule.sdk.api.annotation.param.NullSafe(defaultImplementingType=LinkedList.class)
        @Optional
        private List<String> strings;

        private CollectionWithDefaultImplementingTypeUsingSdkApi() {
        }
    }
}

