/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import io.qameta.allure.Description;
import io.qameta.allure.Issue;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.extension.api.runtime.operation.CompletableComponentExecutor;
import org.mule.runtime.module.extension.internal.runtime.operation.DeferredExecutorCallback;

@Issue(value="MULE-19431")
public class DeferredExecutorCallbackTestCase {
    @Test
    @Description(value="During the lifetime of the deferred executor, the real complete method isn't called")
    public void completeIsNotDelegatedWhileDeferredCallbackIsNotClosed() throws Exception {
        TestExecutorCallback testExecutorCallback = new TestExecutorCallback();
        try (DeferredExecutorCallback deferredCallback = new DeferredExecutorCallback((CompletableComponentExecutor.ExecutorCallback)testExecutorCallback);){
            deferredCallback.complete((Object)53);
            Assert.assertThat((Object)testExecutorCallback.isCompleteCalled(), (Matcher)Matchers.is((Object)false));
        }
    }

    @Test
    @Description(value="During the lifetime of the deferred executor, the real error method isn't called")
    public void errorIsNotDelegatedWhileDeferredCallbackIsNotClosed() throws Exception {
        TestExecutorCallback testExecutorCallback = new TestExecutorCallback();
        try (DeferredExecutorCallback deferredCallback = new DeferredExecutorCallback((CompletableComponentExecutor.ExecutorCallback)testExecutorCallback);){
            deferredCallback.error((Throwable)new NullPointerException());
            Assert.assertThat((Object)testExecutorCallback.isErrorCalled(), (Matcher)Matchers.is((Object)false));
        }
    }

    @Test
    @Description(value="After the lifetime of the deferred executor, the real complete method is called")
    public void completeIsDelegatedWhenDeferredCallbackIsClosed() throws Exception {
        TestExecutorCallback testExecutorCallback = new TestExecutorCallback();
        try (DeferredExecutorCallback deferredCallback = new DeferredExecutorCallback((CompletableComponentExecutor.ExecutorCallback)testExecutorCallback);){
            deferredCallback.complete((Object)53);
        }
        Assert.assertThat((Object)testExecutorCallback.isCompleteCalled(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    @Description(value="After the lifetime of the deferred executor, the real error method is called")
    public void errorIsDelegatedWhenDeferredCallbackIsClosed() throws Exception {
        TestExecutorCallback testExecutorCallback = new TestExecutorCallback();
        try (DeferredExecutorCallback deferredCallback = new DeferredExecutorCallback((CompletableComponentExecutor.ExecutorCallback)testExecutorCallback);){
            deferredCallback.error((Throwable)new NullPointerException());
        }
        Assert.assertThat((Object)testExecutorCallback.isErrorCalled(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    @Description(value="After the lifetime of the deferred executor, the real complete method isn't called if the deferred method was neither called")
    public void completeIsNotDelegatedWhenDeferredCallbackIsNotCalled() throws Exception {
        TestExecutorCallback testExecutorCallback = new TestExecutorCallback();
        DeferredExecutorCallback deferredCallback = new DeferredExecutorCallback((CompletableComponentExecutor.ExecutorCallback)testExecutorCallback);
        deferredCallback.close();
        Assert.assertThat((Object)testExecutorCallback.isErrorCalled(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    @Description(value="After the lifetime of the deferred executor, the real error method isn't called if the deferred method was neither called")
    public void errorIsNotDelegatedWhenDeferredCallbackIsNotCalled() throws Exception {
        TestExecutorCallback testExecutorCallback = new TestExecutorCallback();
        DeferredExecutorCallback deferredCallback = new DeferredExecutorCallback((CompletableComponentExecutor.ExecutorCallback)testExecutorCallback);
        deferredCallback.close();
        Assert.assertThat((Object)testExecutorCallback.isErrorCalled(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    @Description(value="The completion class loader is preserved")
    public void completionClassLoaderIsPreserved() throws Exception {
        ClassLoader completionClassLoader = (ClassLoader)Mockito.mock(ClassLoader.class);
        TestExecutorCallback testExecutorCallback = new TestExecutorCallback();
        try (DeferredExecutorCallback deferredCallback = new DeferredExecutorCallback((CompletableComponentExecutor.ExecutorCallback)testExecutorCallback);){
            ClassUtils.withContextClassLoader((ClassLoader)completionClassLoader, () -> deferredCallback.complete((Object)53));
        }
        Assert.assertThat((Object)testExecutorCallback.getCompleteClassLoader(), (Matcher)Matchers.is((Object)completionClassLoader));
    }

    @Test
    public void errorClassLoaderIsPreserved() throws Exception {
        ClassLoader errorClassLoader = (ClassLoader)Mockito.mock(ClassLoader.class);
        TestExecutorCallback testExecutorCallback = new TestExecutorCallback();
        try (DeferredExecutorCallback deferredCallback = new DeferredExecutorCallback((CompletableComponentExecutor.ExecutorCallback)testExecutorCallback);){
            ClassUtils.withContextClassLoader((ClassLoader)errorClassLoader, () -> deferredCallback.error((Throwable)new NullPointerException()));
        }
        Assert.assertThat((Object)testExecutorCallback.getErrorClassLoader(), (Matcher)Matchers.is((Object)errorClassLoader));
    }

    private static class TestExecutorCallback
    implements CompletableComponentExecutor.ExecutorCallback {
        private ClassLoader completeClassLoader;
        private ClassLoader errorClassLoader;

        private TestExecutorCallback() {
        }

        public void complete(Object value) {
            this.completeClassLoader = Thread.currentThread().getContextClassLoader();
        }

        public void error(Throwable e) {
            this.errorClassLoader = Thread.currentThread().getContextClassLoader();
        }

        boolean isCompleteCalled() {
            return this.completeClassLoader != null;
        }

        boolean isErrorCalled() {
            return this.errorClassLoader != null;
        }

        ClassLoader getCompleteClassLoader() {
            return this.completeClassLoader;
        }

        ClassLoader getErrorClassLoader() {
            return this.errorClassLoader;
        }
    }
}

