/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.module.extension.internal.runtime.resolver.TypeSafeValueResolverWrapper;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class TypeSafeValueResolverWrapperTestCase
extends AbstractMuleContextTestCase {
    private final TransformationService transformationService = (TransformationService)Mockito.mock(TransformationService.class);
    private final ValueResolver<String> staticValueResolver = (ValueResolver)Mockito.mock(ValueResolver.class);
    private final ValueResolver<String> dynamicValueResolver = (ValueResolver)Mockito.mock(ValueResolver.class);
    private final ExpressionManager expressionManager = (ExpressionManager)Mockito.mock(ExpressionManager.class);
    private TypeSafeValueResolverWrapper<Integer> dynamicResolver;
    private TypeSafeValueResolverWrapper<Integer> staticResolver;

    protected void doSetUp() throws Exception {
        muleContext = (MuleContext)Mockito.spy((Object)muleContext);
        ExtendedExpressionManager expressionManager = (ExtendedExpressionManager)Mockito.spy((Object)muleContext.getExpressionManager());
        Mockito.when((Object)this.staticValueResolver.isDynamic()).thenReturn((Object)false);
        Mockito.when((Object)((String)this.staticValueResolver.resolve((ValueResolvingContext)ArgumentMatchers.any(ValueResolvingContext.class)))).thenReturn((Object)"123");
        Mockito.when((Object)this.dynamicValueResolver.isDynamic()).thenReturn((Object)true);
        Mockito.when((Object)((String)this.dynamicValueResolver.resolve((ValueResolvingContext)ArgumentMatchers.any(ValueResolvingContext.class)))).thenReturn((Object)"123");
        Mockito.when((Object)muleContext.getExpressionManager()).thenReturn((Object)expressionManager);
        this.dynamicResolver = new TypeSafeValueResolverWrapper(this.dynamicValueResolver, Integer.class);
        this.dynamicResolver.setTransformationService(this.transformationService);
        LifecycleUtils.initialiseIfNeeded(this.dynamicResolver, (MuleContext)muleContext);
        this.staticResolver = new TypeSafeValueResolverWrapper(this.staticValueResolver, Integer.class);
        this.staticResolver.setTransformationService(this.transformationService);
        LifecycleUtils.initialiseIfNeeded(this.staticResolver, (MuleContext)muleContext);
        Mockito.when((Object)this.transformationService.transform(ArgumentMatchers.eq((Object)"123"), (DataType)ArgumentMatchers.any(DataType.class), (DataType)ArgumentMatchers.any(DataType.class))).thenReturn((Object)123);
    }

    @Test
    public void staticValueIsTransformed() throws MuleException {
        Integer resolve = (Integer)this.staticResolver.resolve(ValueResolvingContext.builder((CoreEvent)this.testEvent()).withExpressionManager(this.expressionManager).build());
        MatcherAssert.assertThat((Object)resolve, (Matcher)CoreMatchers.is((Object)123));
    }

    @Test
    public void staticValueIsTransformedOnlyOnce() throws MuleException {
        this.staticResolver.resolve(ValueResolvingContext.builder((CoreEvent)this.testEvent()).withExpressionManager(this.expressionManager).build());
        this.staticResolver.resolve(ValueResolvingContext.builder((CoreEvent)this.testEvent()).withExpressionManager(this.expressionManager).build());
        this.staticResolver.resolve(ValueResolvingContext.builder((CoreEvent)this.testEvent()).withExpressionManager(this.expressionManager).build());
        this.staticResolver.resolve(ValueResolvingContext.builder((CoreEvent)this.testEvent()).withExpressionManager(this.expressionManager).build());
        this.staticResolver.resolve(ValueResolvingContext.builder((CoreEvent)this.testEvent()).withExpressionManager(this.expressionManager).build());
        ((ValueResolver)Mockito.verify(this.staticValueResolver, (VerificationMode)Mockito.times((int)1))).resolve((ValueResolvingContext)ArgumentMatchers.any(ValueResolvingContext.class));
    }

    @Test
    public void dynamicValueIsTransformed() throws MuleException {
        ValueResolvingContext ctx = ValueResolvingContext.builder((CoreEvent)this.testEvent()).withExpressionManager(this.expressionManager).build();
        Integer resolve = (Integer)this.dynamicResolver.resolve(ctx);
        MatcherAssert.assertThat((Object)resolve, (Matcher)CoreMatchers.is((Object)123));
    }

    @Test
    public void dynamicValueIsTransformedOnlyOnce() throws MuleException {
        this.dynamicResolver.resolve(ValueResolvingContext.builder((CoreEvent)this.testEvent()).withExpressionManager(this.expressionManager).build());
        this.dynamicResolver.resolve(ValueResolvingContext.builder((CoreEvent)this.testEvent()).withExpressionManager(this.expressionManager).build());
        this.dynamicResolver.resolve(ValueResolvingContext.builder((CoreEvent)this.testEvent()).withExpressionManager(this.expressionManager).build());
        this.dynamicResolver.resolve(ValueResolvingContext.builder((CoreEvent)this.testEvent()).withExpressionManager(this.expressionManager).build());
        this.dynamicResolver.resolve(ValueResolvingContext.builder((CoreEvent)this.testEvent()).withExpressionManager(this.expressionManager).build());
        ((ValueResolver)Mockito.verify(this.dynamicValueResolver, (VerificationMode)Mockito.times((int)5))).resolve((ValueResolvingContext)ArgumentMatchers.any(ValueResolvingContext.class));
    }

    @Test
    public void transformNullValue() throws MuleException {
        Mockito.when((Object)((String)this.staticValueResolver.resolve((ValueResolvingContext)ArgumentMatchers.any(ValueResolvingContext.class)))).thenReturn(null);
        Integer value = (Integer)this.staticResolver.resolve(ValueResolvingContext.builder((CoreEvent)this.testEvent()).withExpressionManager(this.expressionManager).build());
        MatcherAssert.assertThat((Object)value, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }
}

