/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java.type.runtime;

import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.extension.api.annotation.execution.OnError;
import org.mule.runtime.extension.api.annotation.execution.OnSuccess;
import org.mule.runtime.extension.api.annotation.execution.OnTerminate;
import org.mule.runtime.extension.api.exception.IllegalSourceModelDefinitionException;
import org.mule.runtime.module.extension.api.loader.java.type.MethodElement;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.SourceTypeWrapper;
import org.mule.sdk.api.annotation.source.OnBackPressure;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class SourceTypeWrapperTestCase {
    private static final String ON_SUCCESS_METHOD_NAME = "onSuccessMethod";
    private static final String ON_ERROR_METHOD_NAME = "onErrorMethod";
    private static final String ON_TERMINATE_METHOD_NAME = "onTerminateMethod";
    private static final String ON_BACK_PRESSURE_METHOD_NAME = "onBackPressureMethod";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Mock
    ClassTypeLoader classTypeLoader;
    private SourceTypeWrapper sourceTypeWrapperForLegacyApi;
    private SourceTypeWrapper sourceTypeWrapperForSdkApi;
    private SourceTypeWrapper sourceTypeWrapperWithMixedApis;
    private SourceTypeWrapper sourceTypeWrapperWithInvalidApiUsage;
    private SourceTypeWrapper sourceTypeWrapperWithInvalidOnBackPressureApiUsage;

    @Before
    public void before() {
        this.sourceTypeWrapperForLegacyApi = new SourceTypeWrapper(SourceTestWithLegacyAnnotations.class, this.classTypeLoader);
        this.sourceTypeWrapperForSdkApi = new SourceTypeWrapper(SourceTestWithSdkApiAnnotations.class, this.classTypeLoader);
        this.sourceTypeWrapperWithMixedApis = new SourceTypeWrapper(SourceTestWithMixedApiAnnotations.class, this.classTypeLoader);
        this.sourceTypeWrapperWithInvalidApiUsage = new SourceTypeWrapper(SourceTestWithInvalidAnnotationsUsage.class, this.classTypeLoader);
        this.sourceTypeWrapperWithInvalidOnBackPressureApiUsage = new SourceTypeWrapper(SourceTestWithInvalidOnBackPressureAnnotationsUsage.class, this.classTypeLoader);
    }

    @Test
    public void methodWithOnSuccessLegacyAnnotation() {
        this.verifyMethod(this.sourceTypeWrapperForLegacyApi.getOnResponseMethod(), ON_SUCCESS_METHOD_NAME);
    }

    @Test
    public void methodWithOnSuccessSdkApiAnnotation() {
        this.verifyMethod(this.sourceTypeWrapperForSdkApi.getOnResponseMethod(), ON_SUCCESS_METHOD_NAME);
    }

    @Test
    public void methodWithOnErrorLegacyAnnotation() {
        this.verifyMethod(this.sourceTypeWrapperForLegacyApi.getOnErrorMethod(), ON_ERROR_METHOD_NAME);
    }

    @Test
    public void methodWithOnErrorSdkApiAnnotation() {
        this.verifyMethod(this.sourceTypeWrapperForSdkApi.getOnErrorMethod(), ON_ERROR_METHOD_NAME);
    }

    @Test
    public void methodWithOnTerminateLegacyAnnotation() {
        this.verifyMethod(this.sourceTypeWrapperForLegacyApi.getOnTerminateMethod(), ON_TERMINATE_METHOD_NAME);
    }

    @Test
    public void methodWithOnTerminateSdkApiAnnotation() {
        this.verifyMethod(this.sourceTypeWrapperForSdkApi.getOnTerminateMethod(), ON_TERMINATE_METHOD_NAME);
    }

    @Test
    public void methodWithOnBackPressureLegacyAnnotation() {
        this.verifyMethod(this.sourceTypeWrapperForLegacyApi.getOnBackPressureMethod(), ON_BACK_PRESSURE_METHOD_NAME);
    }

    @Test
    public void methodWithOnBackPressureSdkApiAnnotation() {
        this.verifyMethod(this.sourceTypeWrapperForSdkApi.getOnBackPressureMethod(), ON_BACK_PRESSURE_METHOD_NAME);
    }

    @Test
    public void methodsWithMixedApiAnnotations() {
        this.verifyMethod(this.sourceTypeWrapperWithMixedApis.getOnResponseMethod(), ON_SUCCESS_METHOD_NAME);
        this.verifyMethod(this.sourceTypeWrapperWithMixedApis.getOnErrorMethod(), ON_ERROR_METHOD_NAME);
        this.verifyMethod(this.sourceTypeWrapperWithMixedApis.getOnTerminateMethod(), ON_TERMINATE_METHOD_NAME);
        this.verifyMethod(this.sourceTypeWrapperWithMixedApis.getOnBackPressureMethod(), ON_BACK_PRESSURE_METHOD_NAME);
    }

    @Test
    public void methodsWithInvalidAnnotationUsage() {
        this.expectedException.expect(IllegalSourceModelDefinitionException.class);
        this.sourceTypeWrapperWithInvalidApiUsage.getOnResponseMethod();
    }

    @Test
    public void methodsWithInvalidOnBackPressureAnnotationUsage() {
        this.expectedException.expect(IllegalSourceModelDefinitionException.class);
        this.sourceTypeWrapperWithInvalidOnBackPressureApiUsage.getOnBackPressureMethod();
    }

    private void verifyMethod(Optional<MethodElement> method, String methodName) {
        Assert.assertThat((Object)method.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)method.get().getName(), (Matcher)CoreMatchers.is((Object)methodName));
    }

    private class SourceTestWithInvalidOnBackPressureAnnotationsUsage {
        private SourceTestWithInvalidOnBackPressureAnnotationsUsage() {
        }

        @org.mule.runtime.extension.api.annotation.source.OnBackPressure
        @OnBackPressure
        public void onBackPressure() {
        }
    }

    private class SourceTestWithInvalidAnnotationsUsage {
        private SourceTestWithInvalidAnnotationsUsage() {
        }

        @OnSuccess
        @org.mule.sdk.api.annotation.execution.OnSuccess
        public void onSuccessMethod() {
        }
    }

    private class SourceTestWithMixedApiAnnotations {
        private SourceTestWithMixedApiAnnotations() {
        }

        @OnSuccess
        public void onSuccessMethod() {
        }

        @org.mule.sdk.api.annotation.execution.OnError
        public void onErrorMethod() {
        }

        @OnTerminate
        public void onTerminateMethod() {
        }

        @OnBackPressure
        public void onBackPressureMethod() {
        }
    }

    private class SourceTestWithSdkApiAnnotations {
        private SourceTestWithSdkApiAnnotations() {
        }

        @org.mule.sdk.api.annotation.execution.OnSuccess
        public void onSuccessMethod() {
        }

        @org.mule.sdk.api.annotation.execution.OnError
        public void onErrorMethod() {
        }

        @org.mule.sdk.api.annotation.execution.OnTerminate
        public void onTerminateMethod() {
        }

        @OnBackPressure
        public void onBackPressureMethod() {
        }
    }

    private class SourceTestWithLegacyAnnotations {
        private SourceTestWithLegacyAnnotations() {
        }

        @OnSuccess
        public void onSuccessMethod() {
        }

        @OnError
        public void onErrorMethod() {
        }

        @OnTerminate
        public void onTerminateMethod() {
        }

        @org.mule.runtime.extension.api.annotation.source.OnBackPressure
        public void onBackPressureMethod() {
        }
    }
}

