/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.resources.test;

import java.io.InputStream;
import org.custommonkey.xmlunit.XMLUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.resources.GeneratedResource;
import org.mule.runtime.module.extension.api.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.resources.documentation.ExtensionDocumentationResourceGenerator;
import org.mule.tck.size.SmallTest;
import org.mule.test.heisenberg.extension.HeisenbergExtension;

@SmallTest
public class ExtensionModelResourceFactoryTestCase {
    private static final String RESOURCE_NAME = "heisenberg-extension-descriptions.xml";
    private ExtensionDocumentationResourceGenerator resourceFactory = new ExtensionDocumentationResourceGenerator();
    private ExtensionModel extensionModel;

    @Before
    public void before() {
        this.extensionModel = MuleExtensionUtils.loadExtension(HeisenbergExtension.class);
    }

    @Test
    public void generate() throws Exception {
        GeneratedResource resource = (GeneratedResource)this.resourceFactory.generateResource(this.extensionModel).get();
        Assert.assertThat((Object)resource.getPath(), (Matcher)CoreMatchers.equalTo((Object)RESOURCE_NAME));
        XMLUnit.setIgnoreWhitespace((boolean)true);
        String expected = IOUtils.toString((InputStream)Thread.currentThread().getContextClassLoader().getResource(RESOURCE_NAME).openStream());
        XMLUnit.compareXML((String)expected, (String)new String(resource.getContent()));
    }
}

