/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.resources.documentation;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.metadata.api.annotation.DescriptionAnnotation;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.connection.HasConnectionProviderModels;
import org.mule.runtime.api.meta.model.operation.HasOperationModels;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.HasSourceModels;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.extension.api.resources.GeneratedResource;
import org.mule.runtime.extension.api.resources.spi.GeneratedResourceFactory;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.privileged.resources.documentation.ExtensionDescriptionsSerializer;
import org.mule.runtime.module.extension.privileged.resources.documentation.XmlExtensionDocumentation;
import org.mule.runtime.module.extension.privileged.resources.documentation.XmlExtensionElementDocumentation;
import org.mule.runtime.module.extension.privileged.resources.documentation.XmlExtensionParameterDocumentation;

public class ExtensionDocumentationResourceGenerator
implements GeneratedResourceFactory {
    public Optional<GeneratedResource> generateResource(ExtensionModel extensionModel) {
        ExtensionDocumenterWalker walker = new ExtensionDocumenterWalker();
        walker.walk(extensionModel);
        String documenter = ExtensionDescriptionsSerializer.SERIALIZER.serialize(this.getDocumenter(extensionModel, walker.getConfigs(), walker.getConnections(), walker.getOperations(), walker.getSources(), this.getTypesDocumentation(extensionModel)));
        return Optional.of(new GeneratedResource(ExtensionDescriptionsSerializer.SERIALIZER.getFileName(extensionModel.getName()), documenter.getBytes()));
    }

    private List<XmlExtensionElementDocumentation> getTypesDocumentation(ExtensionModel extensionModel) {
        ArrayList<XmlExtensionElementDocumentation> types = new ArrayList<XmlExtensionElementDocumentation>();
        extensionModel.getTypes().forEach(type -> ExtensionMetadataTypeUtils.getId((MetadataType)type).ifPresent(id -> {
            XmlExtensionElementDocumentation element = new XmlExtensionElementDocumentation();
            element.setName((String)id);
            element.setDescription(type.getAnnotation(DescriptionAnnotation.class).map(DescriptionAnnotation::getValue).orElse(""));
            element.setParameters(type.getFields().stream().map(f -> new XmlExtensionParameterDocumentation(ExtensionMetadataTypeUtils.getAlias((ObjectFieldType)f), f.getAnnotation(DescriptionAnnotation.class).map(DescriptionAnnotation::getValue).orElse(""))).collect(Collectors.toList()));
            types.add(element);
        }));
        return types;
    }

    private XmlExtensionDocumentation getDocumenter(ExtensionModel model, List<XmlExtensionElementDocumentation> configs, List<XmlExtensionElementDocumentation> connections, List<XmlExtensionElementDocumentation> operations, List<XmlExtensionElementDocumentation> sources, List<XmlExtensionElementDocumentation> types) {
        XmlExtensionDocumentation documenter = new XmlExtensionDocumentation();
        XmlExtensionElementDocumentation element = new XmlExtensionElementDocumentation();
        element.setName(model.getName());
        element.setDescription(model.getDescription());
        element.setParameters(Collections.emptyList());
        documenter.setExtension(element);
        documenter.setConfigs(configs);
        documenter.setConnections(connections);
        documenter.setOperation(operations);
        documenter.setSources(sources);
        documenter.setTypes(types);
        return documenter;
    }

    private class ExtensionDocumenterWalker
    extends ExtensionWalker {
        List<XmlExtensionElementDocumentation> configs = new ArrayList<XmlExtensionElementDocumentation>();
        List<XmlExtensionElementDocumentation> connections = new ArrayList<XmlExtensionElementDocumentation>();
        List<XmlExtensionElementDocumentation> operations = new ArrayList<XmlExtensionElementDocumentation>();
        List<XmlExtensionElementDocumentation> sources = new ArrayList<XmlExtensionElementDocumentation>();

        private ExtensionDocumenterWalker() {
        }

        protected void onConfiguration(ConfigurationModel model) {
            this.configs.addAll(this.createParameterizedElement((ParameterizedModel)model));
        }

        protected void onOperation(HasOperationModels owner, OperationModel model) {
            this.operations.addAll(this.createParameterizedElement((ParameterizedModel)model));
        }

        protected void onConnectionProvider(HasConnectionProviderModels owner, ConnectionProviderModel model) {
            this.connections.addAll(this.createParameterizedElement((ParameterizedModel)model));
        }

        protected void onSource(HasSourceModels owner, SourceModel model) {
            this.sources.addAll(this.createParameterizedElement((ParameterizedModel)model));
        }

        private List<XmlExtensionElementDocumentation> createParameterizedElement(ParameterizedModel model) {
            ImmutableList.Builder builder = ImmutableList.builder();
            XmlExtensionElementDocumentation element = new XmlExtensionElementDocumentation();
            element.setName(model.getName());
            element.setDescription(model.getDescription());
            element.setParameters(model.getAllParameterModels().stream().map(p -> new XmlExtensionParameterDocumentation(p.getName(), p.getDescription())).collect(Collectors.toList()));
            builder.add((Object)element);
            return builder.build();
        }

        public List<XmlExtensionElementDocumentation> getConfigs() {
            return this.configs;
        }

        public List<XmlExtensionElementDocumentation> getConnections() {
            return this.connections;
        }

        public List<XmlExtensionElementDocumentation> getOperations() {
            return this.operations;
        }

        public List<XmlExtensionElementDocumentation> getSources() {
            return this.sources;
        }
    }
}

