/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.parser.java.notification;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.declaration.fluent.ExecutableComponentDeclarer;
import org.mule.runtime.api.meta.model.notification.NotificationModel;
import org.mule.runtime.extension.api.annotation.notification.Fires;
import org.mule.runtime.extension.api.model.notification.ImmutableNotificationModel;
import org.mule.runtime.extension.api.notification.NotificationActionDefinition;
import org.mule.runtime.module.extension.api.loader.java.type.AnnotationValueFetcher;
import org.mule.runtime.module.extension.api.loader.java.type.WithAnnotations;
import org.mule.runtime.module.extension.internal.loader.parser.NotificationEmitterParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.MuleExtensionAnnotationParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.notification.SdkNotificationActionProviderAdapter;
import org.mule.sdk.api.annotation.notification.NotificationActionProvider;
import org.mule.sdk.api.annotation.notification.NotificationActions;

public final class NotificationModelParserUtils {
    public static List<NotificationModel> parseNotifications(AnnotationValueFetcher<NotificationActions> value, String extensionNamespace, ClassTypeLoader typeLoader) {
        Class enumType = value.getClassValue(NotificationActions::value).getDeclaringClass().orElse(null);
        if (enumType == null) {
            return new LinkedList<NotificationModel>();
        }
        return Stream.of((org.mule.sdk.api.notification.NotificationActionDefinition[])enumType.getEnumConstants()).map(action -> new ImmutableNotificationModel(extensionNamespace, ((Enum)action).name(), typeLoader.load((Type)action.getDataType().getType()))).collect(Collectors.toList());
    }

    public static List<NotificationModel> parseLegacyNotifications(AnnotationValueFetcher<org.mule.runtime.extension.api.annotation.notification.NotificationActions> value, String extensionNamespace, ClassTypeLoader typeLoader) {
        Class enumType = value.getClassValue(org.mule.runtime.extension.api.annotation.notification.NotificationActions::value).getDeclaringClass().orElse(null);
        if (enumType == null) {
            return new LinkedList<NotificationModel>();
        }
        return Stream.of((NotificationActionDefinition[])enumType.getEnumConstants()).map(action -> new ImmutableNotificationModel(extensionNamespace, ((Enum)action).name(), typeLoader.load((Type)action.getDataType().getType()))).collect(Collectors.toList());
    }

    public static List<String> getEmittedNotifications(WithAnnotations element, String componentType, String componentName) {
        return MuleExtensionAnnotationParser.mapReduceSingleAnnotation(element, componentType, componentName, Fires.class, org.mule.sdk.api.annotation.notification.Fires.class, value -> NotificationModelParserUtils.getEmittedNotifications(value.getClassArrayValue(Fires::value)), value -> NotificationModelParserUtils.getEmittedNotifications(value.getClassArrayValue(org.mule.sdk.api.annotation.notification.Fires::value))).orElse(Collections.emptyList());
    }

    public static void declareEmittedNotifications(NotificationEmitterParser parser, ExecutableComponentDeclarer declarer, Function<String, Optional<NotificationModel>> notificationMapper) {
        parser.getEmittedNotificationsStream(notificationMapper).forEach(arg_0 -> ((ExecutableComponentDeclarer)declarer).withNotificationModel(arg_0));
    }

    private static List<String> getEmittedNotifications(List<org.mule.runtime.module.extension.api.loader.java.type.Type> types) {
        return types.stream().filter(type -> type.getDeclaringClass().isPresent()).flatMap(type -> {
            Class<?> providerClass = type.getDeclaringClass().get();
            try {
                NotificationActionProvider provider = SdkNotificationActionProviderAdapter.from(providerClass.newInstance());
                return provider.getNotificationActions().stream().map(action -> ((Enum)action).name());
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Could not create NotificationActionProvider of type " + providerClass.getName())), (Throwable)e);
            }
        }).collect(Collectors.toList());
    }

    private NotificationModelParserUtils() {
    }
}

