/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.exception;

import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.extension.api.runtime.exception.SdkExceptionHandlerFactory;
import org.mule.runtime.module.extension.internal.runtime.exception.SdkExceptionHandlerAdapter;
import org.mule.sdk.api.runtime.exception.ExceptionHandler;

public final class DefaultExceptionHandlerFactory
implements SdkExceptionHandlerFactory {
    private final ExceptionHandler enricher;

    public DefaultExceptionHandlerFactory(Class<?> enricherType) {
        Preconditions.checkArgument((enricherType != null ? 1 : 0) != 0, (String)"ExceptionEnricher type cannot be null");
        try {
            this.enricher = SdkExceptionHandlerAdapter.from(ClassUtils.instantiateClass(enricherType, (Object[])new Object[0]));
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Could not create ExceptionEnricher of type " + enricherType.getName())), (Throwable)e);
        }
    }

    public ExceptionHandler createHandler() {
        return this.enricher;
    }
}

