/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation.resulthandler;

import java.util.Collection;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.CollectionDataType;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.module.extension.internal.runtime.operation.resulthandler.ReturnHandler;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

public final class CollectionReturnHandler
implements ReturnHandler<Collection> {
    private final CollectionDataType dataType;

    public CollectionReturnHandler(MetadataType outputType) {
        Preconditions.checkArgument((boolean)MetadataTypeUtils.isCollection((MetadataType)outputType), (String)"The output type is not a collection");
        this.dataType = (CollectionDataType)IntrospectionUtils.toDataType(outputType);
    }

    @Override
    public Message.Builder toMessageBuilder(Collection value) {
        return Message.builder().payload(new TypedValue((Object)value, this.getDataType()));
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public boolean handles(Object value) {
        return value instanceof Collection;
    }
}

