/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.catalog.loader.xml;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.mule.runtime.extension.internal.loader.catalog.builder.TypesCatalogBuilder;
import org.mule.runtime.extension.internal.loader.catalog.loader.TypesCatalogLoaderContext;
import org.mule.runtime.extension.internal.loader.catalog.loader.common.XmlMatcher;
import org.mule.runtime.extension.internal.loader.catalog.model.TypesCatalog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class TypesCatalogXmlLoader {
    private static final String NS_TYPES = "http://www.mulesoft.org/schema/mule/types";
    private static final QName ELEM_MULE = new QName("http://www.mulesoft.org/schema/mule/types", "mule");
    private static final QName ELEM_CATALOG = new QName("http://www.mulesoft.org/schema/mule/types", "catalog");
    private static final QName ELEM_TYPE = new QName("http://www.mulesoft.org/schema/mule/types", "type");
    private static final String ELEM_TYPE_ATTR_NAME = "name";
    private static final String ELEM_TYPE_ATTR_LOCATION = "location";
    private static final String ELEM_TYPE_ATTR_ELEMENT = "element";

    public TypesCatalog load(URL resourceType) throws Exception {
        TypesCatalogBuilder typesCatalogBuilder = new TypesCatalogBuilder(resourceType.toURI());
        TypesCatalogLoaderContext typesCatalogLoaderContext = new TypesCatalogLoaderContext(typesCatalogBuilder);
        this.load(resourceType, typesCatalogLoaderContext);
        return typesCatalogBuilder.build();
    }

    private void load(URL resourceType, TypesCatalogLoaderContext typesCatalogLoaderContext) {
        try {
            Element documentElement = this.parseRootElement(resourceType);
            TypesCatalogBuilder typesCatalogBuilder = typesCatalogLoaderContext.getTypesCatalogBuilder();
            XmlMatcher.match(documentElement, ELEM_MULE).ifPresent(xmlMatcher -> xmlMatcher.matchMany(ELEM_CATALOG).forEach(catalog -> catalog.matchMany(ELEM_TYPE).forEach(type -> typesCatalogBuilder.addTypesResolver(typesResolverBuilder -> {
                type.matchAttribute(ELEM_TYPE_ATTR_NAME).ifPresent(typesResolverBuilder::name);
                type.matchAttribute(ELEM_TYPE_ATTR_LOCATION).ifPresent(typesResolverBuilder::location);
                type.matchAttribute(ELEM_TYPE_ATTR_ELEMENT).ifPresent(typesResolverBuilder::element);
            }))));
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
    }

    private Element parseRootElement(URL resourceType) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(false);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(resourceType.openStream());
        return document.getDocumentElement();
    }
}

